/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.security.util;

import java.util.Collection;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;

public class AuthenticationUtils {
    public static final String ROLE_ADMIN = "ROLE_ADMIN";

    public static boolean hasRole(Authentication authentication, String role) {
        Collection grantedAuthorities = authentication.getAuthorities();
        if (grantedAuthorities == null || role == null || role.isEmpty()) {
            return false;
        }
        for (GrantedAuthority auth : grantedAuthorities) {
            if (!role.equalsIgnoreCase(auth.getAuthority())) continue;
            return true;
        }
        return false;
    }

    public static boolean isAdmin(Authentication authentication) {
        return AuthenticationUtils.hasRole(authentication, ROLE_ADMIN);
    }
}

