/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.service;

import java.util.Map;
import org.apache.rave.model.Widget;
import org.apache.rave.model.WidgetComment;
import org.apache.rave.model.WidgetRating;
import org.apache.rave.model.WidgetTag;
import org.apache.rave.portal.model.util.WidgetStatistics;
import org.apache.rave.rest.model.SearchResult;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.security.access.prepost.PreAuthorize;

public interface WidgetService {
    public SearchResult<Widget> getAll();

    public SearchResult<Widget> getLimitedList(int var1, int var2);

    public SearchResult<Widget> getWidgetsByFreeTextSearch(String var1, int var2, int var3);

    @PostAuthorize(value="returnObject == null or hasPermission(returnObject, 'read')")
    public Widget getWidget(String var1);

    public SearchResult<Widget> getPublishedWidgets(int var1, int var2);

    public SearchResult<Widget> getPublishedWidgetsByFreeTextSearch(String var1, int var2, int var3);

    public SearchResult<Widget> getWidgetsBySearchCriteria(String var1, String var2, String var3, int var4, int var5);

    public SearchResult<Widget> getWidgetsByOwner(String var1, int var2, int var3);

    public Widget getWidgetByUrl(String var1);

    public boolean isRegisteredUrl(String var1);

    @PostAuthorize(value="hasPermission(returnObject, 'create')")
    public Widget registerNewWidget(Widget var1);

    public WidgetStatistics getWidgetStatistics(String var1, String var2);

    public Map<String, WidgetStatistics> getAllWidgetStatistics(String var1);

    @PreAuthorize(value="hasPermission(#widget.id, 'org.apache.rave.model.Widget', 'update')")
    public void updateWidget(Widget var1);

    public SearchResult<Widget> getWidgetsByTag(String var1, int var2, int var3);

    public SearchResult<Widget> getWidgetsByCategory(String var1, int var2, int var3);

    public WidgetTag getWidgetTag(String var1);

    public WidgetTag getWidgetTagByWidgetIdAndKeyword(String var1, String var2);

    public WidgetTag createWidgetTag(String var1, WidgetTag var2);

    @PostAuthorize(value="hasPermission(returnObject, 'read')")
    public WidgetComment getWidgetComment(String var1, String var2);

    public void createWidgetComment(String var1, WidgetComment var2);

    @PreAuthorize(value="hasPermission(#widgetComment, 'update')")
    public void updateWidgetComment(String var1, WidgetComment var2);

    @PreAuthorize(value="hasPermission(#commentId, 'org.apache.rave.model.WidgetComment', 'delete')")
    public void removeWidgetComment(String var1, String var2);

    @PreAuthorize(value="hasPermission(new org.apache.rave.portal.security.impl.RaveSecurityContext(#userId, 'org.apache.rave.model.User'), 'org.apache.rave.model.WidgetComment', 'delete')")
    public int deleteAllWidgetComments(String var1);

    public WidgetRating getWidgetRatingByWidgetIdAndUserId(String var1, String var2);

    @PreAuthorize(value="hasPermission(#widgetRating.entityId, 'org.apache.rave.model.WidgetRating', 'update')")
    public void updateWidgetRatingScore(String var1, WidgetRating var2, Integer var3);

    public void saveWidgetRating(String var1, WidgetRating var2);

    @PreAuthorize(value="hasPermission(new org.apache.rave.portal.security.impl.RaveSecurityContext(#userId, 'org.apache.rave.model.User'), 'org.apache.rave.model.WidgetRating', 'delete')")
    public void removeWidgetRating(String var1, String var2);

    @PreAuthorize(value="hasPermission(new org.apache.rave.portal.security.impl.RaveSecurityContext(#userId, 'org.apache.rave.model.User'), 'org.apache.rave.model.WidgetRating', 'delete')")
    public int removeAllWidgetRatings(String var1);
}

