/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.service.impl;

import java.util.List;
import org.apache.rave.model.Authority;
import org.apache.rave.portal.repository.AuthorityRepository;
import org.apache.rave.portal.service.AuthorityService;
import org.apache.rave.rest.model.SearchResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DefaultAuthorityService
implements AuthorityService {
    private final AuthorityRepository repository;

    @Autowired
    public DefaultAuthorityService(AuthorityRepository repository) {
        this.repository = repository;
    }

    @Override
    public Authority getAuthorityById(String entityId) {
        return (Authority)this.repository.get(entityId);
    }

    @Override
    public Authority getAuthorityByName(String authorityName) {
        return this.repository.getByAuthority(authorityName);
    }

    @Override
    public SearchResult<Authority> getAllAuthorities() {
        int count = this.repository.getCountAll();
        List authorities = this.repository.getAll();
        return new SearchResult(authorities, count);
    }

    @Override
    public SearchResult<Authority> getDefaultAuthorities() {
        List<Authority> authorities = this.repository.getAllDefault();
        return new SearchResult(authorities, authorities.size());
    }
}

