/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.service.impl;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.rave.model.RegionWidget;
import org.apache.rave.model.RegionWidgetPreference;
import org.apache.rave.portal.model.util.ModelUtils;
import org.apache.rave.portal.repository.RegionWidgetRepository;
import org.apache.rave.portal.service.RegionWidgetService;
import org.apache.rave.rest.model.SearchResult;
import org.apache.rave.synchronization.annotation.Synchronized;
import org.apache.rave.util.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="regionWidgetService")
public class DefaultRegionWidgetService
implements RegionWidgetService {
    private RegionWidgetRepository regionWidgetRepository;

    @Autowired
    public DefaultRegionWidgetService(RegionWidgetRepository regionWidgetRepository) {
        this.regionWidgetRepository = regionWidgetRepository;
    }

    @Override
    public RegionWidget getRegionWidget(String regionWidgetId) {
        return (RegionWidget)this.regionWidgetRepository.get(regionWidgetId);
    }

    @Override
    public SearchResult<RegionWidget> getAll() {
        int count = this.regionWidgetRepository.getCountAll();
        List regionWidgets = this.regionWidgetRepository.getAll();
        return new SearchResult(regionWidgets, count);
    }

    @Override
    public SearchResult<RegionWidget> getLimitedList(int offset, int pageSize) {
        int count = this.regionWidgetRepository.getCountAll();
        List regionWidgets = this.regionWidgetRepository.getLimitedList(offset, pageSize);
        SearchResult searchResult = new SearchResult(regionWidgets, count);
        searchResult.setOffset(offset);
        searchResult.setPageSize(pageSize);
        return searchResult;
    }

    @Override
    @Transactional
    public RegionWidget saveRegionWidget(RegionWidget regionWidget) {
        return (RegionWidget)this.regionWidgetRepository.save(regionWidget);
    }

    @Override
    @Synchronized(discriminator="'RegionWidget'", id="#regionWidgetId")
    @Transactional
    public List<RegionWidgetPreference> saveRegionWidgetPreferences(String regionWidgetId, List<RegionWidgetPreference> preferences) {
        RegionWidget regionWidget = this.getValidRegionWidget(regionWidgetId);
        ModelUtils.normalizeRegionWidgetPreferences(regionWidgetId, preferences);
        DefaultRegionWidgetService.reconcileRegionWidgetPreferences(regionWidget.getPreferences(), preferences, true);
        return this.saveRegionWidget(regionWidget).getPreferences();
    }

    @Override
    @Synchronized(discriminator="'RegionWidget'", id="#regionWidgetId")
    @Transactional
    public RegionWidgetPreference saveRegionWidgetPreference(String regionWidgetId, RegionWidgetPreference preference) {
        RegionWidget regionWidget = this.getValidRegionWidget(regionWidgetId);
        ModelUtils.normalizeRegionWidgetPreference(regionWidgetId, preference);
        DefaultRegionWidgetService.reconcileRegionWidgetPreferences(regionWidget.getPreferences(), Arrays.asList(preference), false);
        regionWidget = this.saveRegionWidget(regionWidget);
        for (RegionWidgetPreference regionWidgetPreference : regionWidget.getPreferences()) {
            if (!regionWidgetPreference.getName().equals(preference.getName())) continue;
            preference = regionWidgetPreference;
            break;
        }
        return preference;
    }

    @Override
    @Transactional
    public RegionWidget saveRegionWidgetCollapsedState(String regionWidgetId, boolean collapsed) {
        RegionWidget regionWidget = this.getValidRegionWidget(regionWidgetId);
        regionWidget.setCollapsed(collapsed);
        return this.saveRegionWidget(regionWidget);
    }

    private RegionWidget getValidRegionWidget(String regionWidgetId) {
        RegionWidget regionWidget = this.getRegionWidget(regionWidgetId);
        if (regionWidget == null) {
            throw new IllegalArgumentException("Invalid RegionWidget ID");
        }
        return regionWidget;
    }

    private static void reconcileRegionWidgetPreferences(List<RegionWidgetPreference> existingPreferences, List<RegionWidgetPreference> updatedPreferences, boolean removeMissingObjects) {
        CollectionUtils.reconcileObjectCollections(existingPreferences, updatedPreferences, (CollectionUtils.CollectionReconciliationHelper)new CollectionUtils.CollectionReconciliationHelper<RegionWidgetPreference, String>(){

            public String extractKey(RegionWidgetPreference object) {
                return object.getName().toLowerCase();
            }

            public void reconcileValues(RegionWidgetPreference existingObject, RegionWidgetPreference updatedObject) {
                if (!StringUtils.equals((CharSequence)existingObject.getValue(), (CharSequence)updatedObject.getValue())) {
                    existingObject.setValue(updatedObject.getValue());
                }
            }
        }, (boolean)removeMissingObjects);
    }
}

