/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.service.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.rave.model.PortalPreference;
import org.apache.rave.model.User;
import org.apache.rave.model.Widget;
import org.apache.rave.model.WidgetStatus;
import org.apache.rave.portal.service.PortalPreferenceService;
import org.apache.rave.portal.service.RemoteWidgetResolverService;
import org.apache.rave.portal.service.UserService;
import org.apache.rave.portal.service.WidgetMetadataResolver;
import org.apache.rave.portal.service.WidgetService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DefaultRemoteWidgetResolverService
implements RemoteWidgetResolverService {
    private final WidgetService widgetService;
    private final UserService userService;
    private PortalPreferenceService portalPreferenceService;
    private Map<String, WidgetMetadataResolver> widgetMetadataResolverMap;

    @Autowired
    public DefaultRemoteWidgetResolverService(WidgetService widgetService, UserService userService, PortalPreferenceService pps, List<WidgetMetadataResolver> widgetMetadataResolvers) {
        this.widgetService = widgetService;
        this.userService = userService;
        this.portalPreferenceService = pps;
        this.widgetMetadataResolverMap = new HashMap<String, WidgetMetadataResolver>();
        for (WidgetMetadataResolver widgetMetadataResolver : widgetMetadataResolvers) {
            this.widgetMetadataResolverMap.put(widgetMetadataResolver.getSupportedContext(), widgetMetadataResolver);
        }
    }

    @Override
    public Widget resolveAndDownloadWidgetMetadata(String url, String type) throws Exception {
        String[] deNamespacedType;
        Widget widget = null;
        if (type.contains("#") && (deNamespacedType = type.split("#")).length > 0) {
            type = deNamespacedType[1];
        }
        if (type.equals("W3C") || type.equals("W3C Widget") || type.equals("W3CWidget")) {
            widget = this.widgetMetadataResolverMap.get("W3C").publishRemote(url);
        } else if (type.equals("OpenSocial") || type.startsWith("OpenSocial") || type.startsWith("Open Social")) {
            widget = this.widgetMetadataResolverMap.get("OpenSocial").getMetadata(url);
        } else {
            throw new Exception("Unsupported Widget format");
        }
        return widget;
    }

    @Override
    public Widget addWidget(Widget widget) throws Exception {
        PortalPreference status = this.portalPreferenceService.getPreference("initialWidgetStatus");
        User user = this.userService.getAuthenticatedUser();
        widget.setOwnerId(user.getId());
        if (status != null && status.getValue().equals("PUBLISHED")) {
            widget.setWidgetStatus(WidgetStatus.PUBLISHED);
        } else {
            widget.setWidgetStatus(WidgetStatus.PREVIEW);
        }
        return this.widgetService.registerNewWidget(widget);
    }

    @Override
    public boolean isPublished() {
        PortalPreference status = this.portalPreferenceService.getPreference("initialWidgetStatus");
        return status != null && status.getValue().equals("PUBLISHED");
    }
}

