/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.service.impl;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.rave.model.PortalPreference;
import org.apache.rave.model.Widget;
import org.apache.rave.portal.model.util.WidgetMarketplaceSearchResult;
import org.apache.rave.portal.model.util.WidgetMarketplaceWidgetResult;
import org.apache.rave.portal.service.PortalPreferenceService;
import org.apache.rave.portal.service.RemoteWidgetResolverService;
import org.apache.rave.portal.service.WidgetMarketplaceService;
import org.apache.rave.rest.model.SearchResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class DefaultWidgetMarketplaceService
implements WidgetMarketplaceService {
    private PortalPreferenceService portalPreferenceService;
    private RemoteWidgetResolverService widgetResolverService;
    private static final String DEFAULT_URL = null;
    private static final Logger logger = LoggerFactory.getLogger(DefaultWidgetMarketplaceService.class);
    private static final String SEARCH = "search?q=${SEARCHTERM}&start=${OFFSET}&rows=${LIMIT}";
    private static final String CATEGORY = "tag/${CATEGORY}/widgets?start=${OFFSET}&rows=${LIMIT}";
    private static final String DETAIL = "widget/${ID}";
    private static final String CATEGORY_LIST = "tag/all";

    @Autowired
    public DefaultWidgetMarketplaceService(RemoteWidgetResolverService widgetResolverService, PortalPreferenceService pps) {
        this.widgetResolverService = widgetResolverService;
        this.portalPreferenceService = pps;
    }

    @Override
    public SearchResult<Widget> getWidgetsByFreeTextSearch(String searchTerm, int offset, int pageSize) throws Exception {
        if (this.getStoreUrl() == null) {
            throw new Exception("External marketplace URL not configured");
        }
        String encodedSearchTerm = searchTerm;
        String url = this.getStoreUrl() + SEARCH;
        url = url.replace("${SEARCHTERM}", encodedSearchTerm);
        url = url.replace("${OFFSET}", String.valueOf(offset));
        url = url.replace("${LIMIT}", String.valueOf(pageSize));
        SearchResult<Widget> result = this.executeQuery(url);
        result.setOffset(offset);
        result.setPageSize(pageSize);
        return result;
    }

    @Override
    public SearchResult<Widget> getWidgetsByCategory(String category, int offset, int pageSize) throws Exception {
        if (this.getStoreUrl() == null) {
            throw new Exception("External marketplace URL not configured");
        }
        String url = this.getStoreUrl() + CATEGORY;
        url = url.replace("${CATEGORY}", category);
        url = url.replace("${OFFSET}", String.valueOf(offset));
        url = url.replace("${LIMIT}", String.valueOf(pageSize));
        SearchResult<Widget> result = this.executeQuery(url);
        result.setOffset(offset);
        result.setPageSize(pageSize);
        return result;
    }

    @Override
    public List<String> getCategories() throws Exception {
        if (this.getStoreUrl() == null) {
            throw new Exception("External marketplace URL not configured");
        }
        String url = this.getStoreUrl() + CATEGORY_LIST;
        ArrayList<String> categories = new ArrayList<String>();
        List result = (List)this.getRestJsonTemplate().getForObject(url, List.class, new Object[0]);
        for (Object category : result) {
            categories.add((String)((Map)category).get("tagtext"));
        }
        return categories;
    }

    private String getStoreUrl() {
        PortalPreference storePref = this.portalPreferenceService.getPreference("externalMarketplaceUrl");
        if (storePref != null) {
            return storePref.getValue();
        }
        return DEFAULT_URL;
    }

    private SearchResult<Widget> executeQuery(String query) throws Exception {
        WidgetMarketplaceSearchResult result = (WidgetMarketplaceSearchResult)this.getRestJsonTemplate().getForObject(query, WidgetMarketplaceSearchResult.class, new Object[0]);
        return result.toSearchResult();
    }

    private RestTemplate getRestJsonTemplate() {
        RestTemplate restTemplate = new RestTemplate();
        List mc = restTemplate.getMessageConverters();
        MappingJackson2HttpMessageConverter json = new MappingJackson2HttpMessageConverter();
        ArrayList<MediaType> supportedMediaTypes = new ArrayList<MediaType>();
        supportedMediaTypes.add(new MediaType("application", "json", Charset.forName("UTF-8")));
        supportedMediaTypes.add(new MediaType("application", "octet-stream", Charset.forName("UTF-8")));
        json.setSupportedMediaTypes(supportedMediaTypes);
        mc.add(json);
        restTemplate.setMessageConverters(mc);
        return restTemplate;
    }

    @Override
    public Widget getWidget(String id) throws Exception {
        if (this.getStoreUrl() == null) {
            throw new Exception("External marketplace URL not configured");
        }
        String url = this.getStoreUrl() + DETAIL;
        url = url.replace("${ID}", id);
        WidgetMarketplaceWidgetResult widgetResult = (WidgetMarketplaceWidgetResult)this.getRestJsonTemplate().getForObject(url, WidgetMarketplaceWidgetResult.class, new Object[0]);
        Widget widget = widgetResult.getWidget();
        return widget;
    }

    @Override
    public Widget addWidget(Widget widget) throws Exception {
        return this.widgetResolverService.addWidget(widget);
    }

    @Override
    public Widget resolveWidgetMetadata(String url, String type) throws Exception {
        return this.widgetResolverService.resolveAndDownloadWidgetMetadata(url, type);
    }
}

