/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.rave.exception.DuplicateItemException;
import org.apache.rave.model.Category;
import org.apache.rave.model.User;
import org.apache.rave.model.Widget;
import org.apache.rave.model.WidgetComment;
import org.apache.rave.model.WidgetRating;
import org.apache.rave.model.WidgetStatus;
import org.apache.rave.model.WidgetTag;
import org.apache.rave.portal.model.util.WidgetStatistics;
import org.apache.rave.portal.repository.CategoryRepository;
import org.apache.rave.portal.repository.UserRepository;
import org.apache.rave.portal.repository.WidgetRepository;
import org.apache.rave.portal.service.WidgetService;
import org.apache.rave.rest.model.SearchResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DefaultWidgetService
implements WidgetService {
    private final WidgetRepository widgetRepository;
    private final UserRepository userRepository;
    private final CategoryRepository categoryRepository;

    @Autowired
    public DefaultWidgetService(WidgetRepository widgetRepository, UserRepository userRepository, CategoryRepository categoryRepository) {
        this.widgetRepository = widgetRepository;
        this.userRepository = userRepository;
        this.categoryRepository = categoryRepository;
    }

    @Override
    public SearchResult<Widget> getAll() {
        int count = this.widgetRepository.getCountAll();
        List widgets = this.widgetRepository.getAll();
        return new SearchResult(widgets, count);
    }

    @Override
    public SearchResult<Widget> getLimitedList(int offset, int pageSize) {
        int count = this.widgetRepository.getCountAll();
        List widgets = this.widgetRepository.getLimitedList(offset, pageSize);
        SearchResult searchResult = new SearchResult(widgets, count);
        searchResult.setOffset(offset);
        searchResult.setPageSize(pageSize);
        return searchResult;
    }

    @Override
    public SearchResult<Widget> getWidgetsByFreeTextSearch(String searchTerm, int offset, int pageSize) {
        if (StringUtils.isBlank((CharSequence)searchTerm)) {
            return this.getLimitedList(offset, pageSize);
        }
        int count = this.widgetRepository.getCountFreeTextSearch(searchTerm);
        List<Widget> widgets = this.widgetRepository.getByFreeTextSearch(searchTerm, offset, pageSize);
        SearchResult searchResult = new SearchResult(widgets, count);
        searchResult.setOffset(offset);
        searchResult.setPageSize(pageSize);
        return searchResult;
    }

    @Override
    public Widget getWidget(String id) {
        return (Widget)this.widgetRepository.get(id);
    }

    @Override
    public SearchResult<Widget> getPublishedWidgets(int offset, int pageSize) {
        int count = this.widgetRepository.getCountByStatus(WidgetStatus.PUBLISHED);
        List<Widget> widgets = this.widgetRepository.getByStatus(WidgetStatus.PUBLISHED, offset, pageSize);
        SearchResult searchResult = new SearchResult(widgets, count);
        searchResult.setOffset(offset);
        searchResult.setPageSize(pageSize);
        return searchResult;
    }

    @Override
    public SearchResult<Widget> getPublishedWidgetsByFreeTextSearch(String searchTerm, int offset, int pageSize) {
        return this.getWidgetsBySearchCriteria(searchTerm, null, WidgetStatus.PUBLISHED.getWidgetStatus(), offset, pageSize);
    }

    @Override
    public SearchResult<Widget> getWidgetsBySearchCriteria(String searchTerm, String widgetType, String widgetStatus, int offset, int pageSize) {
        WidgetStatus status = StringUtils.isBlank((CharSequence)widgetStatus) ? null : WidgetStatus.get((String)widgetStatus);
        int count = this.widgetRepository.getCountByStatusAndTypeAndFreeText(status, widgetType, searchTerm);
        List<Widget> widgets = this.widgetRepository.getByStatusAndTypeAndFreeTextSearch(status, widgetType, searchTerm, offset, pageSize);
        SearchResult searchResult = new SearchResult(widgets, count);
        searchResult.setOffset(offset);
        searchResult.setPageSize(pageSize);
        return searchResult;
    }

    @Override
    public SearchResult<Widget> getWidgetsByOwner(String ownerId, int offset, int pageSize) {
        User user = (User)this.userRepository.get(ownerId);
        int count = this.widgetRepository.getCountByOwner(user, offset, pageSize);
        List<Widget> widgets = this.widgetRepository.getByOwner(user, offset, pageSize);
        SearchResult searchResult = new SearchResult(widgets, count);
        searchResult.setOffset(offset);
        searchResult.setPageSize(pageSize);
        return searchResult;
    }

    @Override
    public Widget getWidgetByUrl(String widgetUrl) {
        return this.widgetRepository.getByUrl(widgetUrl);
    }

    @Override
    public boolean isRegisteredUrl(String widgetUrl) {
        return this.widgetRepository.getByUrl(widgetUrl) != null;
    }

    @Override
    @Transactional
    public Widget registerNewWidget(Widget widget) {
        if (this.getWidgetByUrl(widget.getUrl()) != null) {
            throw new DuplicateItemException("Trying to add an existing widget for url " + widget.getUrl());
        }
        return (Widget)this.widgetRepository.save(widget);
    }

    @Override
    public WidgetStatistics getWidgetStatistics(String widgetId, String userId) {
        return this.widgetRepository.getWidgetStatistics(widgetId, userId);
    }

    @Override
    public Map<String, WidgetStatistics> getAllWidgetStatistics(String userId) {
        return this.widgetRepository.getAllWidgetStatistics(userId);
    }

    @Override
    @Transactional
    public void updateWidget(Widget widget) {
        this.widgetRepository.save(widget);
    }

    @Override
    public SearchResult<Widget> getWidgetsByTag(String tagKeyWord, int offset, int pageSize) {
        int count = this.widgetRepository.getCountByTag(tagKeyWord);
        List<Widget> widgets = this.widgetRepository.getWidgetsByTag(tagKeyWord, offset, pageSize);
        SearchResult searchResult = new SearchResult(widgets, count);
        searchResult.setOffset(offset);
        searchResult.setPageSize(pageSize);
        return searchResult;
    }

    @Override
    public SearchResult<Widget> getWidgetsByCategory(String categoryId, int offset, int pageSize) {
        Category category = (Category)this.categoryRepository.get(categoryId);
        if (category == null) {
            return new SearchResult(new ArrayList(), 0);
        }
        List widgets = category.getWidgets();
        SearchResult searchResult = new SearchResult(widgets, widgets.size());
        searchResult.setOffset(offset);
        searchResult.setPageSize(pageSize);
        return searchResult;
    }

    @Override
    public WidgetTag getWidgetTag(String id) {
        return this.widgetRepository.getTagById(id);
    }

    @Override
    @Transactional
    public WidgetTag createWidgetTag(String widgetId, WidgetTag widgetTag) {
        return this.widgetRepository.saveWidgetTag(widgetId, widgetTag);
    }

    @Override
    public WidgetTag getWidgetTagByWidgetIdAndKeyword(String widgetId, String keyword) {
        return this.widgetRepository.getTagByWidgetIdAndKeyword(widgetId, keyword);
    }

    @Override
    public WidgetComment getWidgetComment(String widgetId, String commentId) {
        return this.widgetRepository.getCommentById(widgetId, commentId);
    }

    @Override
    @Transactional
    public void createWidgetComment(String widgetId, WidgetComment widgetComment) {
        this.widgetRepository.createWidgetComment(widgetId, widgetComment);
    }

    @Override
    @Transactional
    public void updateWidgetComment(String widgetId, WidgetComment widgetComment) {
        this.widgetRepository.updateWidgetComment(widgetId, widgetComment);
    }

    @Override
    @Transactional
    public void removeWidgetComment(String widgetId, String commentId) {
        this.widgetRepository.deleteWidgetComment(widgetId, this.getWidgetComment(widgetId, commentId));
    }

    @Override
    @Transactional
    public int deleteAllWidgetComments(String userId) {
        return this.widgetRepository.deleteAllWidgetComments(userId);
    }

    @Override
    public WidgetRating getWidgetRatingByWidgetIdAndUserId(String widgetId, String userId) {
        return this.widgetRepository.getWidgetRatingsByWidgetIdAndUserId(widgetId, userId);
    }

    @Override
    @Transactional
    public void updateWidgetRatingScore(String widgetId, WidgetRating widgetRating, Integer score) {
        widgetRating.setScore(score);
        this.widgetRepository.updateWidgetRating(widgetId, widgetRating);
    }

    @Override
    @Transactional
    public void saveWidgetRating(String widgetId, WidgetRating rating) {
        WidgetRating existingRating = this.getWidgetRatingByWidgetIdAndUserId(widgetId, rating.getUserId());
        if (existingRating == null) {
            this.widgetRepository.createWidgetRating(widgetId, rating);
        } else {
            this.updateWidgetRatingScore(widgetId, existingRating, rating.getScore());
        }
    }

    @Override
    @Transactional
    public void removeWidgetRating(String widgetId, String userId) {
        WidgetRating widgetRating = this.widgetRepository.getWidgetRatingsByWidgetIdAndUserId(widgetId, userId);
        if (widgetRating == null) {
            return;
        }
        this.widgetRepository.deleteWidgetRating(widgetId, widgetRating);
    }

    @Override
    @Transactional
    public int removeAllWidgetRatings(String userId) {
        return this.widgetRepository.deleteAllWidgetRatings(userId);
    }
}

