/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.rave.model.Page;
import org.apache.rave.model.PageInvitationStatus;
import org.apache.rave.model.PageTemplate;
import org.apache.rave.model.PageTemplateRegion;
import org.apache.rave.model.PageTemplateWidget;
import org.apache.rave.model.PageUser;
import org.apache.rave.model.Region;
import org.apache.rave.model.RegionWidget;
import org.apache.rave.model.User;
import org.apache.rave.portal.model.impl.PageImpl;
import org.apache.rave.portal.model.impl.PageUserImpl;
import org.apache.rave.portal.model.impl.RegionImpl;
import org.apache.rave.portal.model.impl.RegionWidgetImpl;

public class PageUtil {
    private PageUtil() {
    }

    public static Page convert(PageTemplate template, User owner, boolean createIds) {
        PageImpl p = new PageImpl();
        if (createIds) {
            p.setId(String.valueOf(-1L));
        }
        p.setName(template.getName());
        p.setPageType(template.getPageType());
        p.setOwnerId(owner.getId());
        PageUserImpl pageUser = new PageUserImpl(owner.getId(), p, template.getRenderSequence());
        pageUser.setPageStatus(PageInvitationStatus.OWNER);
        pageUser.setEditor(true);
        ArrayList<PageUserImpl> members = new ArrayList<PageUserImpl>();
        members.add(pageUser);
        p.setMembers(members);
        p.setPageLayout(template.getPageLayout());
        p.setRegions(PageUtil.convertRegions(template.getPageTemplateRegions(), p, createIds));
        p.setSubPages(PageUtil.convertPages(template.getSubPageTemplates(), p, createIds));
        return p;
    }

    private static List<Region> convertRegions(List<PageTemplateRegion> pageTemplateRegions, Page page, boolean createIds) {
        ArrayList<Region> regions = new ArrayList<Region>();
        int idx = 0;
        for (PageTemplateRegion ptr : pageTemplateRegions) {
            RegionImpl region = new RegionImpl();
            if (createIds) {
                region.setId(String.valueOf(--idx));
            }
            region.setRenderOrder((int)ptr.getRenderSequence());
            region.setPage(page);
            region.setLocked(ptr.isLocked());
            region.setRegionWidgets(PageUtil.convertWidgets(ptr.getPageTemplateWidgets(), region, createIds));
            region.setProperties(ptr.getProperties());
            regions.add(region);
        }
        return regions;
    }

    private static List<RegionWidget> convertWidgets(List<PageTemplateWidget> pageTemplateWidgets, Region region, boolean createIds) {
        ArrayList<RegionWidget> widgets = new ArrayList<RegionWidget>();
        int idx = createIds ? 100 * Integer.parseInt(region.getId()) : 0;
        for (PageTemplateWidget ptw : pageTemplateWidgets) {
            RegionWidgetImpl regionWidget = new RegionWidgetImpl();
            if (createIds) {
                regionWidget.setId(String.valueOf(--idx));
            }
            regionWidget.setRegion(region);
            regionWidget.setCollapsed(false);
            regionWidget.setLocked(ptw.isLocked());
            regionWidget.setHideChrome(ptw.isHideChrome());
            regionWidget.setRenderOrder((int)ptw.getRenderSeq());
            regionWidget.setWidgetId(ptw.getWidgetId());
            regionWidget.setProperties(ptw.getProperties());
            widgets.add(regionWidget);
        }
        return widgets;
    }

    private static List<Page> convertPages(List<PageTemplate> pageTemplates, Page page, boolean createIds) {
        ArrayList<Page> pages = new ArrayList<Page>();
        int idx = -1;
        for (PageTemplate pt : pageTemplates) {
            PageImpl lPage = new PageImpl();
            if (createIds) {
                lPage.setId(String.valueOf(--idx));
            }
            lPage.setName(pt.getName());
            lPage.setPageType(pt.getPageType());
            lPage.setOwnerId(page.getOwnerId());
            lPage.setPageLayout(pt.getPageLayout());
            lPage.setParentPage(page);
            lPage.setRegions(PageUtil.convertRegions(pt.getPageTemplateRegions(), lPage, createIds));
            PageUserImpl pageUser = new PageUserImpl(lPage.getOwnerId(), lPage, pt.getRenderSequence());
            pageUser.setPageStatus(PageInvitationStatus.OWNER);
            pageUser.setEditor(true);
            ArrayList<PageUser> members = new ArrayList<PageUser>();
            members.add(pageUser);
            lPage.setMembers(members);
            lPage.setSubPages(pt.getSubPageTemplates() == null || pt.getSubPageTemplates().isEmpty() ? null : PageUtil.convertPages(pt.getSubPageTemplates(), lPage, createIds));
            pages.add(lPage);
        }
        return pages;
    }
}

