/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.util.data;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.rave.model.ActivityStreamsEntry;
import org.apache.rave.model.Authority;
import org.apache.rave.model.Category;
import org.apache.rave.model.Page;
import org.apache.rave.model.PageLayout;
import org.apache.rave.model.PageTemplate;
import org.apache.rave.model.PageTemplateRegion;
import org.apache.rave.model.PageTemplateWidget;
import org.apache.rave.model.PageUser;
import org.apache.rave.model.PortalPreference;
import org.apache.rave.model.Region;
import org.apache.rave.model.RegionWidget;
import org.apache.rave.model.User;
import org.apache.rave.model.Widget;
import org.apache.rave.portal.repository.ActivityStreamsRepository;
import org.apache.rave.portal.repository.AuthorityRepository;
import org.apache.rave.portal.repository.CategoryRepository;
import org.apache.rave.portal.repository.PageLayoutRepository;
import org.apache.rave.portal.repository.PageRepository;
import org.apache.rave.portal.repository.PageTemplateRepository;
import org.apache.rave.portal.repository.PortalPreferenceRepository;
import org.apache.rave.portal.repository.UserRepository;
import org.apache.rave.portal.repository.WidgetRepository;
import org.apache.rave.portal.util.data.DataImporter;
import org.apache.rave.portal.util.data.ModelWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class ModelWrapperDataExecutor
implements DataImporter.Executor<ModelWrapper> {
    @Autowired
    private PageLayoutRepository pageLayoutRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private WidgetRepository widgetRepository;
    @Autowired
    private PageRepository pageRepository;
    @Autowired
    private AuthorityRepository authorityRepository;
    @Autowired
    private PortalPreferenceRepository portalPreferenceRepository;
    @Autowired
    private CategoryRepository categoryRepository;
    @Autowired
    private PageTemplateRepository pageTemplateRepository;
    @Autowired
    private ActivityStreamsRepository activityStreamsRepository;

    @Override
    public boolean needsLoading() {
        return this.widgetRepository.getCountAll() == 0;
    }

    @Override
    @Transactional
    public void loadData(ModelWrapper wrapper) {
        this.savePageLayouts(wrapper);
        this.saveAuthorities(wrapper);
        Map<String, User> usersByOriginalId = this.saveUsers(wrapper);
        Map<String, Category> categoryByOldId = this.saveCategories(wrapper, usersByOriginalId);
        Map<String, Widget> widgetsById = this.saveWidgets(wrapper, usersByOriginalId, categoryByOldId);
        this.savePages(wrapper, usersByOriginalId, widgetsById);
        this.savePreferences(wrapper);
        this.saveTemplates(wrapper, widgetsById);
        this.saveActivities(wrapper);
    }

    private void saveActivities(ModelWrapper wrapper) {
        if (wrapper.getActivities() != null) {
            for (ActivityStreamsEntry activity : wrapper.getActivities()) {
                this.activityStreamsRepository.save(activity);
            }
        }
    }

    private void saveTemplates(ModelWrapper wrapper, Map<String, Widget> widgetsById) {
        for (PageTemplate template : wrapper.getPageTemplates()) {
            this.updateTemplate(widgetsById, template);
            for (PageTemplate sub : template.getSubPageTemplates()) {
                sub.setParentPageTemplate(template);
                this.updateTemplate(widgetsById, sub);
            }
            this.pageTemplateRepository.save(template);
        }
    }

    private void updateTemplate(Map<String, Widget> widgetsById, PageTemplate template) {
        this.setIdViaReflection(template, null);
        for (PageTemplateRegion region : template.getPageTemplateRegions()) {
            this.setIdViaReflection(region, null);
            region.setPageTemplate(template);
            for (PageTemplateWidget widget : region.getPageTemplateWidgets()) {
                Widget fromDb = widgetsById.get(widget.getWidgetId());
                if (fromDb != null) {
                    widget.setWidgetId(fromDb.getId());
                }
                this.setIdViaReflection(widget, null);
                widget.setPageTemplateRegion(region);
            }
        }
    }

    private Map<String, Category> saveCategories(ModelWrapper wrapper, Map<String, User> usersByOriginalId) {
        HashMap categoryByOldId = Maps.newHashMap();
        if (wrapper.getCategories() != null) {
            for (Category category : wrapper.getCategories()) {
                User created;
                String id = category.getId() == null ? category.getText() : category.getId();
                category.setId(null);
                User lastModified = usersByOriginalId.get(category.getLastModifiedUserId());
                if (lastModified != null) {
                    category.setLastModifiedUserId(lastModified.getId());
                }
                if ((created = usersByOriginalId.get(category.getCreatedUserId())) != null) {
                    category.setCreatedUserId(created.getId());
                }
                categoryByOldId.put(id, this.categoryRepository.save(category));
            }
        }
        return categoryByOldId;
    }

    private void savePreferences(ModelWrapper wrapper) {
        if (wrapper.getPortalPreferences() != null) {
            for (PortalPreference preference : wrapper.getPortalPreferences()) {
                this.portalPreferenceRepository.save(preference);
            }
        }
    }

    private Map<String, User> saveUsers(ModelWrapper wrapper) {
        HashMap usersByOriginalId = Maps.newHashMap();
        if (wrapper.getUsers() != null) {
            for (User user : wrapper.getUsers()) {
                String id = user.getId();
                user.setId(null);
                usersByOriginalId.put(id, this.userRepository.save(user));
            }
        }
        return usersByOriginalId;
    }

    private void savePages(ModelWrapper wrapper, Map<String, User> usersByOriginalId, Map<String, Widget> widgetsById) {
        if (wrapper.getPages() != null) {
            for (Page page : wrapper.getPages()) {
                this.updatePage(usersByOriginalId, widgetsById, page);
                for (Page sub : page.getSubPages()) {
                    sub.setParentPage(page);
                    this.updatePage(usersByOriginalId, widgetsById, sub);
                }
                this.pageRepository.save(page);
            }
        }
    }

    private void updatePage(Map<String, User> usersByOriginalId, Map<String, Widget> widgetsById, Page page) {
        for (Region region : page.getRegions()) {
            region.setPage(page);
            this.setIdViaReflection(region, null);
            for (RegionWidget widget : region.getRegionWidgets()) {
                widget.setRegion(region);
                Widget fromDb = widgetsById.get(widget.getId());
                if (fromDb != null) {
                    widget.setWidgetId(fromDb.getId());
                }
                this.setIdViaReflection(widget, null);
            }
        }
        for (PageUser user : page.getMembers()) {
            user.setPage(page);
            this.setIdViaReflection(user, null);
            User fromDb = usersByOriginalId.get(user.getUserId());
            if (fromDb == null) continue;
            user.setUserId(fromDb.getId());
        }
        User user = usersByOriginalId.get(page.getOwnerId());
        page.setOwnerId(user.getId());
    }

    private Map<String, Widget> saveWidgets(ModelWrapper wrapper, Map<String, User> usersById, Map<String, Category> categoryMap) {
        HashMap widgetsByOldId = Maps.newHashMap();
        if (wrapper.getWidgets() != null) {
            for (Widget widget : wrapper.getWidgets()) {
                String id = widget.getId() == null ? widget.getUrl() : widget.getId();
                this.setIdViaReflection(widget, null);
                User user = usersById.get(widget.getOwnerId());
                if (user != null) {
                    widget.setOwnerId(user.getId());
                }
                ArrayList categories = Lists.newArrayList();
                if (widget.getCategories() != null) {
                    for (Category c : widget.getCategories()) {
                        categories.add(categoryMap.get(c.getId()));
                    }
                    widget.setCategories((List)categories);
                }
                widgetsByOldId.put(id, this.widgetRepository.save(widget));
            }
        }
        return widgetsByOldId;
    }

    private void setIdViaReflection(Object target, Object id) {
        Class<?> clazz = target.getClass();
        Method setter = this.getMethod(clazz, "setId");
        if (setter != null) {
            this.callMethod(target, setter, id);
        } else {
            this.setField(target, id, clazz);
        }
    }

    private void setField(Object target, Object id, Class clazz) {
        List<String> potentialFields = Arrays.asList("id", "_id", "id_");
        for (String name : potentialFields) {
            if (!this.findAndSetField(clazz, target, id, name)) continue;
            return;
        }
        throw new IllegalStateException("Could not match field");
    }

    private boolean findAndSetField(Class clazz, Object target, Object value, String name) {
        Field idField = this.getField(clazz, name);
        if (idField != null) {
            this.setField(target, idField, value);
            return true;
        }
        return false;
    }

    private Field getField(Class clazz, String match) {
        Field field = null;
        try {
            field = clazz.getDeclaredField(match);
        }
        catch (NoSuchFieldException e) {
            // empty catch block
        }
        return field;
    }

    private Method getMethod(Class clazz, String match) {
        Method method = null;
        try {
            method = clazz.getMethod(match, Void.class);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        return method;
    }

    private void callMethod(Object o, Method m, Object ... param) {
        try {
            m.invoke(o, param);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Unable to call method", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("Unable to call method", e);
        }
    }

    private void setField(Object o, Field f, Object val) {
        try {
            f.set(o, val);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Unable to set field", e);
        }
    }

    private void saveAuthorities(ModelWrapper wrapper) {
        if (wrapper.getAuthorities() != null) {
            for (Authority authority : wrapper.getAuthorities()) {
                this.authorityRepository.save(authority);
            }
        }
    }

    private void savePageLayouts(ModelWrapper wrapper) {
        if (wrapper.getPageLayouts() != null) {
            for (PageLayout layout : wrapper.getPageLayouts()) {
                this.pageLayoutRepository.save(layout);
            }
        }
    }

    public void setPageLayoutRepository(PageLayoutRepository pageLayoutRepository) {
        this.pageLayoutRepository = pageLayoutRepository;
    }

    public void setUserRepository(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    public void setWidgetRepository(WidgetRepository widgetRepository) {
        this.widgetRepository = widgetRepository;
    }

    public void setPageRepository(PageRepository pageRepository) {
        this.pageRepository = pageRepository;
    }

    public void setAuthorityRepository(AuthorityRepository authorityRepository) {
        this.authorityRepository = authorityRepository;
    }

    public void setPortalPreferenceRepository(PortalPreferenceRepository portalPreferenceRepository) {
        this.portalPreferenceRepository = portalPreferenceRepository;
    }

    public void setCategoryRepository(CategoryRepository categoryRepository) {
        this.categoryRepository = categoryRepository;
    }

    public void setPageTemplateRepository(PageTemplateRepository pageTemplateRepository) {
        this.pageTemplateRepository = pageTemplateRepository;
    }

    public void setActivityStreamsRepository(ActivityStreamsRepository activityStreamsRepository) {
        this.activityStreamsRepository = activityStreamsRepository;
    }
}

