/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.web.renderer.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.rave.exception.NotSupportedException;
import org.apache.rave.model.Widget;
import org.apache.rave.portal.repository.WidgetRepository;
import org.apache.rave.portal.web.renderer.RegionWidgetRenderer;
import org.apache.rave.portal.web.renderer.RegionWidgetWrapperRenderer;
import org.apache.rave.portal.web.renderer.RenderService;
import org.apache.rave.portal.web.renderer.Renderer;
import org.apache.rave.portal.web.renderer.model.RegionWidgetWrapper;
import org.apache.rave.portal.web.renderer.model.RenderContext;
import org.apache.rave.rest.model.Page;
import org.apache.rave.rest.model.Region;
import org.apache.rave.rest.model.RegionWidget;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DefaultRenderService
implements RenderService {
    public static final String WIDGET_CONTEXT_KEY = "widget";
    private final Map<String, RegionWidgetWrapperRenderer> supportedWidgets;
    private final Map<String, RegionWidgetRenderer> supportedApiWidgets;
    private final WidgetRepository repository;

    @Autowired
    public DefaultRenderService(List<RegionWidgetWrapperRenderer> widgetRenderers, List<RegionWidgetRenderer> apiWidgetRenderers, WidgetRepository widgetRepository) {
        this.repository = widgetRepository;
        this.supportedWidgets = Maps.newHashMap();
        this.supportedApiWidgets = Maps.newHashMap();
        DefaultRenderService.mapRenderersByType(this.supportedWidgets, widgetRenderers);
        DefaultRenderService.mapRenderersByType(this.supportedApiWidgets, apiWidgetRenderers);
    }

    @Override
    public Collection<String> getSupportedWidgetTypes() {
        return this.supportedWidgets.keySet();
    }

    @Override
    public String render(RegionWidgetWrapper rw, RenderContext context) {
        RegionWidgetWrapperRenderer renderer = this.supportedWidgets.get(rw.getWidget().getType());
        if (renderer == null) {
            throw new NotSupportedException(rw.getWidget().getType() + " is not supported");
        }
        return renderer.render(rw, context);
    }

    @Override
    public RegionWidget prepareForRender(RegionWidget source) {
        RegionWidgetRenderer renderer;
        if (source.getType() == null || source.getWidgetUrl() == null) {
            this.updateRegionWidget(source);
        }
        if ((renderer = this.supportedApiWidgets.get(source.getType())) == null) {
            throw new NotSupportedException(source.getType() + " is not supported");
        }
        return renderer.prepareForRender(source);
    }

    @Override
    public Page prepareForRender(Page source) {
        for (Region region : source.getRegions()) {
            ArrayList widgetList = Lists.newArrayListWithCapacity((int)region.getRegionWidgets().size());
            for (RegionWidget widget : region.getRegionWidgets()) {
                widgetList.add(this.prepareForRender(widget));
            }
            region.setRegionWidgets((List)widgetList);
        }
        if (source.getSubPages() != null) {
            for (Page sub : source.getSubPages()) {
                this.prepareForRender(sub);
            }
        }
        return source;
    }

    private static <T extends Renderer> void mapRenderersByType(Map<String, T> map, List<T> renderers) {
        if (renderers != null) {
            for (Renderer renderer : renderers) {
                map.put(renderer.getSupportedContext(), renderer);
            }
        }
    }

    private void updateRegionWidget(RegionWidget source) {
        Widget widget = (Widget)this.repository.get(source.getWidgetId());
        if (widget == null) {
            throw new IllegalArgumentException("Could not retrieve widget for RegionWidget " + source.getId());
        }
        source.setType(widget.getType());
        source.setWidgetUrl(widget.getUrl());
    }
}

