/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.rest.impl;

import java.util.ArrayList;
import javax.ws.rs.core.UriInfo;
import org.apache.rave.exception.ResourceNotFoundException;
import org.apache.rave.model.User;
import org.apache.rave.portal.service.CategoryService;
import org.apache.rave.portal.service.UserService;
import org.apache.rave.rest.CategoriesResource;
import org.apache.rave.rest.model.Category;
import org.apache.rave.rest.model.SearchResult;

public class DefaultCategoriesResource
implements CategoriesResource {
    private CategoryService categoryService;
    private UserService userService;

    public SearchResult<Category> getCategories() {
        SearchResult<org.apache.rave.model.Category> fromDb = this.categoryService.getAll();
        ArrayList<Category> categories = new ArrayList<Category>();
        for (org.apache.rave.model.Category category : fromDb.getResultSet()) {
            categories.add(new Category(category));
        }
        return new SearchResult(categories, fromDb.getTotalResults());
    }

    public Category getCategory(String id) {
        org.apache.rave.model.Category fromDb = this.categoryService.get(id);
        if (fromDb == null) {
            throw new ResourceNotFoundException(id);
        }
        return new Category(fromDb);
    }

    public Category updateCategory(String id, Category category, UriInfo uri) {
        User user = this.userService.getAuthenticatedUser();
        org.apache.rave.model.Category updatedCategory = this.categoryService.update(id, category.getText(), user);
        return new Category(updatedCategory);
    }

    public Category createCategory(Category category) {
        User user = this.userService.getAuthenticatedUser();
        org.apache.rave.model.Category newCategory = this.categoryService.create(category.getText(), user);
        return new Category(newCategory);
    }

    public void setCategoryService(CategoryService categoryService) {
        this.categoryService = categoryService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }
}

