/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.rest.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.rave.portal.service.PageService;
import org.apache.rave.portal.service.UserService;
import org.apache.rave.rest.PageUsersResource;
import org.apache.rave.rest.PagesResource;
import org.apache.rave.rest.RegionsResource;
import org.apache.rave.rest.exception.BadRequestException;
import org.apache.rave.rest.exception.ResourceNotFoundException;
import org.apache.rave.rest.impl.DefaultPageUsersResource;
import org.apache.rave.rest.impl.DefaultRegionsResource;
import org.apache.rave.rest.model.Page;
import org.apache.rave.rest.model.SearchResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPageResource
implements PagesResource {
    public static final String SELF = "@self";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private PageService pageService;
    private DefaultRegionsResource regionsResouce;
    private DefaultPageUsersResource pageUsersResource;
    private UserService userService;

    public SearchResult<Page> getPages() {
        SearchResult<org.apache.rave.model.Page> fromDb = this.pageService.getAll();
        return this.convert(fromDb.getResultSet(), fromDb.getTotalResults());
    }

    public SearchResult<Page> getContextPages(String context, String identifier) {
        List<org.apache.rave.model.Page> pages;
        String contextId = identifier.equals(SELF) ? this.userService.getAuthenticatedUser().getId() : identifier;
        try {
            pages = "portal".equals(context) ? this.pageService.getAllUserPages(contextId) : ("profile".equals(context) ? Arrays.asList(this.pageService.getPersonProfilePage(contextId)) : this.pageService.getPages(context, contextId));
        }
        catch (Exception e) {
            throw new ResourceNotFoundException(contextId);
        }
        if (pages == null) {
            throw new ResourceNotFoundException(contextId);
        }
        return this.convert(pages, pages.size());
    }

    public Page getPage(String id) {
        this.logger.debug("Retrieving page for export: " + id);
        org.apache.rave.model.Page fromDb = this.pageService.getPage(id);
        if (fromDb == null) {
            throw new ResourceNotFoundException(id);
        }
        return new Page(fromDb);
    }

    public Page createPage(String pageTemplateId, Page page) {
        org.apache.rave.model.Page fromDb;
        if (page.getName() == null) {
            throw new BadRequestException("Page name property must be defined.");
        }
        if (StringUtils.isNotBlank((CharSequence)pageTemplateId)) {
            fromDb = this.pageService.addNewPage(page.getName(), null, pageTemplateId);
        } else if (page.getPageType().equals("user")) {
            if (page.getPageLayoutCode() == null) {
                throw new BadRequestException("Page pageLayoutCode property must be defined.");
            }
            fromDb = this.pageService.addNewUserPage(page.getName(), page.getPageLayoutCode());
        } else {
            throw new BadRequestException("Page pageType property must equal 'user'.");
        }
        return new Page(fromDb);
    }

    public Page updatePage(String id, Page page) {
        if (page.getName() == null) {
            throw new BadRequestException("Page name property must be defined.");
        }
        if (page.getPageLayoutCode() == null) {
            throw new BadRequestException("Page pageLayoutCode property must be defined.");
        }
        org.apache.rave.model.Page fromDb = this.pageService.updatePage(id, page.getName(), page.getPageLayoutCode(), page.getProperties());
        Page responsePage = new Page(fromDb);
        return responsePage;
    }

    public Page deletePage(String id) {
        this.logger.debug("Deleting page " + id);
        this.pageService.deletePage(id);
        return null;
    }

    public Response getPageOmdl(String id) {
        return null;
    }

    public RegionsResource getRegionsResource(String pageId) {
        Page page = this.getPage(pageId);
        this.regionsResouce.setPage(page);
        return this.regionsResouce;
    }

    public PageUsersResource getPageMembersResource(String pageId) {
        Page page = this.getPage(pageId);
        this.pageUsersResource.setPage(page);
        return this.pageUsersResource;
    }

    private SearchResult<Page> convert(List<org.apache.rave.model.Page> fromDb, int total) {
        ArrayList pages = Lists.newArrayList();
        for (org.apache.rave.model.Page page : fromDb) {
            pages.add(new Page(page));
        }
        return new SearchResult((List)pages, total);
    }

    @Inject
    public void setPageService(PageService pageService) {
        this.pageService = pageService;
    }

    @Inject
    public void setRegionsResouce(DefaultRegionsResource regionsResouce) {
        this.regionsResouce = regionsResouce;
    }

    @Inject
    public void setPageUsersResource(DefaultPageUsersResource pageUsersResource) {
        this.pageUsersResource = pageUsersResource;
    }

    @Inject
    public void setUserService(UserService userService) {
        this.userService = userService;
    }
}

