/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.rest.impl;

import java.util.List;
import javax.inject.Inject;
import org.apache.rave.model.RegionWidget;
import org.apache.rave.portal.service.PageService;
import org.apache.rave.rest.RegionWidgetsResource;
import org.apache.rave.rest.exception.BadRequestException;
import org.apache.rave.rest.exception.ResourceNotFoundException;
import org.apache.rave.rest.model.Page;
import org.apache.rave.rest.model.Region;
import org.apache.rave.rest.model.SearchResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRegionWidgetsResource
implements RegionWidgetsResource {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private PageService pageService;
    private Page page;
    private Region region;

    public void setPage(Page page) {
        this.page = page;
    }

    public void setRegion(Region region) {
        this.region = region;
    }

    public SearchResult<org.apache.rave.rest.model.RegionWidget> getPageRegionRegionWidgets() {
        List regionWidgets = this.region.getRegionWidgets();
        SearchResult results = new SearchResult(regionWidgets, regionWidgets.size());
        return results;
    }

    public org.apache.rave.rest.model.RegionWidget createPageRegionRegionWidget(org.apache.rave.rest.model.RegionWidget regionWidget) {
        if (regionWidget.getWidgetId() == null) {
            throw new BadRequestException("RegionWidget widgetId property must be defined.");
        }
        RegionWidget fromDb = this.pageService.addWidgetToPageRegion(this.page.getId(), regionWidget.getWidgetId(), this.region.getId());
        return new org.apache.rave.rest.model.RegionWidget(fromDb);
    }

    public org.apache.rave.rest.model.RegionWidget getPageRegionRegionWidget(String regionWidgetId) {
        List regionWidgets = this.region.getRegionWidgets();
        org.apache.rave.rest.model.RegionWidget match = null;
        for (org.apache.rave.rest.model.RegionWidget widget : regionWidgets) {
            if (!widget.getId().equals(regionWidgetId)) continue;
            match = widget;
            break;
        }
        if (match == null) {
            throw new ResourceNotFoundException(regionWidgetId);
        }
        return match;
    }

    public org.apache.rave.rest.model.RegionWidget updatePageRegionRegionWidget(String regionWidgetId, org.apache.rave.rest.model.RegionWidget regionWidget) {
        return null;
    }

    public org.apache.rave.rest.model.RegionWidget deletePageRegionRegionWidget(String regionWidgetId) {
        this.pageService.removeWidgetFromPage(regionWidgetId);
        return null;
    }

    @Inject
    public void setPageService(PageService pageService) {
        this.pageService = pageService;
    }
}

