/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.rest.impl;

import java.util.List;
import javax.inject.Inject;
import org.apache.rave.rest.RegionWidgetsResource;
import org.apache.rave.rest.RegionsResource;
import org.apache.rave.rest.exception.BadRequestException;
import org.apache.rave.rest.exception.ResourceNotFoundException;
import org.apache.rave.rest.impl.DefaultRegionWidgetsResource;
import org.apache.rave.rest.model.Page;
import org.apache.rave.rest.model.Region;
import org.apache.rave.rest.model.SearchResult;

public class DefaultRegionsResource
implements RegionsResource {
    private Page page;
    private DefaultRegionWidgetsResource regionWidgetsResource;

    public void setPage(Page page) {
        this.page = page;
    }

    public SearchResult<Region> getPageRegions() {
        List regions = this.page.getRegions();
        SearchResult results = new SearchResult(regions, regions.size());
        return results;
    }

    public Region createPageRegion(Region region) {
        throw new BadRequestException("Direct manipulation of Regions is not allowed. Too add or delete page regions, edit a page's pageLayoutCode property.");
    }

    public Region getPageRegion(String regionId) {
        List regions = this.page.getRegions();
        Region match = null;
        for (Region region : regions) {
            if (!region.getId().equals(regionId)) continue;
            match = region;
            break;
        }
        if (match == null) {
            throw new ResourceNotFoundException(regionId);
        }
        return match;
    }

    public Region updatePageRegion(String regionId, Region region) {
        throw new BadRequestException("Direct manipulation of Regions is not allowed. Too add or delete page regions, edit a page's pageLayoutCode property.");
    }

    public Region deletePageRegion(String regionId) {
        throw new BadRequestException("Direct manipulation of Regions is not allowed. Too add or delete page regions, edit a page's pageLayoutCode property.");
    }

    public RegionWidgetsResource getRegionWidgetsResource(String regionId) {
        Region region = this.getPageRegion(regionId);
        this.regionWidgetsResource.setPage(this.page);
        this.regionWidgetsResource.setRegion(region);
        return this.regionWidgetsResource;
    }

    @Inject
    public void setRegionWidgetsResource(DefaultRegionWidgetsResource regionWidgetsResource) {
        this.regionWidgetsResource = regionWidgetsResource;
    }
}

