/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.RedefinitionHelper;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.LongId;
import org.apache.rave.model.Page;
import org.apache.rave.model.PageLayout;
import org.apache.rave.model.PageUser;
import org.apache.rave.model.Region;
import org.apache.rave.persistence.jpa.JpaSerializable;
import org.apache.rave.portal.model.BasicEntity;
import org.apache.rave.portal.model.JpaPageLayout;
import org.apache.rave.portal.model.JpaPageUser;
import org.apache.rave.portal.model.JpaRegion;
import org.apache.rave.portal.model.conversion.ConvertingListProxyFactory;
import org.apache.rave.portal.model.conversion.JpaConverter;
import org.apache.rave.util.JsonUtils;

@Entity
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
@Table(name="page", uniqueConstraints={@UniqueConstraint(columnNames={"owner_id", "name", "page_type"})})
@NamedQueries(value={@NamedQuery(name="JpaPage.getAll", query="SELECT p FROM JpaPage p"), @NamedQuery(name="JpaPage.getCount", query="SELECT count(p) FROM JpaPage p"), @NamedQuery(name="JpaPage.deleteByUserIdAndPageType", query="DELETE FROM JpaPage p WHERE p.ownerId = :userId and p.pageType = :pageType"), @NamedQuery(name="JpaPage.hasPersonPage", query="SELECT count(p) FROM JpaPage p WHERE p.ownerId = :userId and p.pageType = :pageType"), @NamedQuery(name="JpaPage.hasContextPage", query="SELECT count(p) FROM JpaPage p WHERE p.contextId = :contextId and p.pageType = :pageType"), @NamedQuery(name="JpaPage.getByContextAndPageType", query="SELECT p FROM JpaPage p WHERE p.contextId = :contextId and p.pageType = :pageType")})
@Access(value=AccessType.FIELD)
public class JpaPage
implements BasicEntity,
Serializable,
JpaSerializable,
Page,
PersistenceCapable {
    private static final long serialVersionUID = 2L;
    public static final String DELETE_BY_USER_ID_AND_PAGE_TYPE = "JpaPage.deleteByUserIdAndPageType";
    public static final String USER_HAS_PERSON_PAGE = "JpaPage.hasPersonPage";
    public static final String GET_ALL = "JpaPage.getAll";
    public static final String GET_COUNT = "JpaPage.getCount";
    public static final String HAS_CONTEXT_PAGE = "JpaPage.hasContextPage";
    public static final String GET_BY_CONTEXT_AND_PAGE_TYPE = "JpaPage.getByContextAndPageType";
    @XmlAttribute(name="id")
    @Id
    @Column(name="entity_id")
    @GeneratedValue(strategy=GenerationType.TABLE, generator="pageIdGenerator")
    @TableGenerator(name="pageIdGenerator", table="RAVE_PORTAL_SEQUENCES", pkColumnName="SEQ_NAME", valueColumnName="SEQ_COUNT", pkColumnValue="page", allocationSize=1, initialValue=1)
    private Long entityId;
    @XmlElement
    @Basic(optional=false)
    @Column(name="name")
    private String name;
    @Basic
    @Column(name="owner_id")
    private String ownerId;
    @Basic
    @Column(name="context_id")
    private String contextId;
    @ManyToOne(cascade={CascadeType.ALL}, optional=true)
    @JoinColumn(name="parent_page_id")
    private JpaPage parentPage;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, mappedBy="parentPage")
    private List<JpaPage> subPages;
    @ManyToOne
    @JoinColumn(name="page_layout_id")
    private JpaPageLayout pageLayout;
    @XmlElement(name="region")
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderBy(value="renderOrder")
    @JoinColumn(name="page_id")
    private List<JpaRegion> regions;
    @Basic
    @Column(name="page_type")
    private String pageType;
    @OneToMany(targetEntity=JpaPageUser.class, fetch=FetchType.EAGER, cascade={CascadeType.ALL}, mappedBy="page", orphanRemoval=true)
    private List<JpaPageUser> members;
    @Lob
    @JsonIgnore
    @Column(name="serialized_data")
    private String serializedData;
    @Transient
    private Map<String, Object> properties;
    private static int pcInheritedFieldCount;
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    protected transient StateManager pcStateManager;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Ljava$lang$Long;
    static /* synthetic */ Class class$Ljava$util$List;
    static /* synthetic */ Class class$Lorg$apache$rave$portal$model$JpaPageLayout;
    static /* synthetic */ Class class$Lorg$apache$rave$portal$model$JpaPage;
    private transient Object pcDetachedState;

    public JpaPage() {
    }

    public JpaPage(Long entityId) {
        this.entityId = entityId;
    }

    public JpaPage(Long entityId, String ownerId) {
        this.entityId = entityId;
        this.ownerId = ownerId;
    }

    public String getId() {
        return this.getEntityId().toString();
    }

    public void setId(String id) {
        this.setEntityId(id == null ? null : Long.valueOf(Long.parseLong(id)));
    }

    @Override
    public Long getEntityId() {
        return JpaPage.pcGetentityId(this);
    }

    @Override
    public void setEntityId(Long entityId) {
        JpaPage.pcSetentityId(this, entityId);
    }

    public String getName() {
        return JpaPage.pcGetname(this);
    }

    public void setName(String name) {
        JpaPage.pcSetname(this, name);
    }

    public String getOwnerId() {
        return JpaPage.pcGetownerId(this);
    }

    public void setOwnerId(String ownerId) {
        JpaPage.pcSetownerId(this, ownerId);
    }

    public String getContextId() {
        return JpaPage.pcGetcontextId(this);
    }

    public void setContextId(String contextId) {
        JpaPage.pcSetcontextId(this, contextId);
    }

    public PageLayout getPageLayout() {
        return JpaPage.pcGetpageLayout(this);
    }

    public void setPageLayout(PageLayout pageLayout) {
        JpaPage.pcSetpageLayout(this, (JpaPageLayout)JpaConverter.getInstance().convert(pageLayout, PageLayout.class));
    }

    @JsonManagedReference
    public List<Region> getRegions() {
        return ConvertingListProxyFactory.createProxyList(Region.class, JpaPage.pcGetregions(this));
    }

    public void setRegions(List<Region> regions) {
        if (JpaPage.pcGetregions(this) == null) {
            JpaPage.pcSetregions(this, new ArrayList());
        }
        this.getRegions().clear();
        if (regions != null) {
            for (Region region : regions) {
                region.setPage((Page)this);
                this.getRegions().add(region);
            }
        }
    }

    public String getPageType() {
        return JpaPage.pcGetpageType(this);
    }

    public void setPageType(String pageType) {
        JpaPage.pcSetpageType(this, pageType);
    }

    public Page getParentPage() {
        return JpaPage.pcGetparentPage(this);
    }

    public void setParentPage(Page parentPage) {
        JpaPage.pcSetparentPage(this, (JpaPage)JpaConverter.getInstance().convert(parentPage, Page.class));
    }

    public List<Page> getSubPages() {
        List<Page> orderedSubPages = null;
        if (JpaPage.pcGetsubPages(this) != null) {
            orderedSubPages = ConvertingListProxyFactory.createProxyList(Page.class, JpaPage.pcGetsubPages(this));
            Collections.sort(orderedSubPages, new SubPageComparator());
        }
        return orderedSubPages;
    }

    public void setSubPages(List<Page> subPages) {
        if (JpaPage.pcGetsubPages(this) == null) {
            JpaPage.pcSetsubPages(this, new ArrayList());
        }
        this.getSubPages().clear();
        if (subPages != null) {
            for (Page subPage : subPages) {
                subPage.setParentPage((Page)this);
                this.getSubPages().add(subPage);
            }
        }
    }

    @JsonManagedReference
    public List<PageUser> getMembers() {
        return ConvertingListProxyFactory.createProxyList(PageUser.class, JpaPage.pcGetmembers(this));
    }

    public void setMembers(List<PageUser> members) {
        if (JpaPage.pcGetmembers(this) == null) {
            JpaPage.pcSetmembers(this, new ArrayList());
        }
        this.getMembers().clear();
        if (members != null) {
            this.getMembers().addAll(members);
        }
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JpaPage other = (JpaPage)obj;
        return JpaPage.pcGetentityId(this) == JpaPage.pcGetentityId(other) || JpaPage.pcGetentityId(this) != null && JpaPage.pcGetentityId(this).equals(JpaPage.pcGetentityId(other));
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + (JpaPage.pcGetentityId(this) != null ? JpaPage.pcGetentityId(this).hashCode() : 0);
        return hash;
    }

    public String toString() {
        return "Page{entityId=" + JpaPage.pcGetentityId(this) + ", name=" + JpaPage.pcGetname(this) + ", ownerId=" + JpaPage.pcGetownerId(this) + ", pageLayout=" + JpaPage.pcGetpageLayout(this) + ", pageType=" + JpaPage.pcGetpageType(this) + "}";
    }

    @Override
    public void serializeData() {
        Map<String, Object> properties = this.getProperties();
        if (properties != null) {
            JpaPage.pcSetserializedData(this, JsonUtils.stringify(properties));
        }
    }

    @Override
    public void deserializeData() {
        if (JpaPage.pcGetserializedData(this) != null) {
            this.setProperties((Map)JsonUtils.parse((String)JpaPage.pcGetserializedData(this), Map.class));
        }
    }

    public int pcGetEnhancementContractVersion() {
        return 1468245;
    }

    static {
        pcFieldNames = new String[]{"contextId", "entityId", "members", "name", "ownerId", "pageLayout", "pageType", "parentPage", "regions", "serializedData", "subPages"};
        Class[] classArray = new Class[11];
        Class clazz = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JpaPage.class$("java.lang.String"));
        classArray[0] = clazz;
        Class clazz2 = class$Ljava$lang$Long != null ? class$Ljava$lang$Long : (class$Ljava$lang$Long = JpaPage.class$("java.lang.Long"));
        classArray[1] = clazz2;
        Class clazz3 = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = JpaPage.class$("java.util.List"));
        classArray[2] = clazz3;
        classArray[3] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JpaPage.class$("java.lang.String"));
        classArray[4] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JpaPage.class$("java.lang.String"));
        Class clazz4 = class$Lorg$apache$rave$portal$model$JpaPageLayout != null ? class$Lorg$apache$rave$portal$model$JpaPageLayout : (class$Lorg$apache$rave$portal$model$JpaPageLayout = JpaPage.class$("org.apache.rave.portal.model.JpaPageLayout"));
        classArray[5] = clazz4;
        classArray[6] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JpaPage.class$("java.lang.String"));
        Class clazz5 = class$Lorg$apache$rave$portal$model$JpaPage != null ? class$Lorg$apache$rave$portal$model$JpaPage : (class$Lorg$apache$rave$portal$model$JpaPage = JpaPage.class$("org.apache.rave.portal.model.JpaPage"));
        classArray[7] = clazz5;
        classArray[8] = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = JpaPage.class$("java.util.List"));
        classArray[9] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JpaPage.class$("java.lang.String"));
        classArray[10] = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = JpaPage.class$("java.util.List"));
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 26, 10, 26, 26, 26, 26, 26, 10, 26, 10};
        PCRegistry.register((Class)(class$Lorg$apache$rave$portal$model$JpaPage != null ? class$Lorg$apache$rave$portal$model$JpaPage : (class$Lorg$apache$rave$portal$model$JpaPage = JpaPage.class$("org.apache.rave.portal.model.JpaPage"))), (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"JpaPage", (PersistenceCapable)new JpaPage());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void pcClearFields() {
        this.contextId = null;
        this.entityId = null;
        this.members = null;
        this.name = null;
        this.ownerId = null;
        this.pageLayout = null;
        this.pageType = null;
        this.parentPage = null;
        this.regions = null;
        this.serializedData = null;
        this.subPages = null;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        JpaPage jpaPage = new JpaPage();
        if (bl) {
            jpaPage.pcClearFields();
        }
        jpaPage.pcStateManager = stateManager;
        jpaPage.pcCopyKeyFieldsFromObjectId(object);
        return jpaPage;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        JpaPage jpaPage = new JpaPage();
        if (bl) {
            jpaPage.pcClearFields();
        }
        jpaPage.pcStateManager = stateManager;
        return jpaPage;
    }

    protected static int pcGetManagedFieldCount() {
        return 11;
    }

    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.contextId = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.entityId = (Long)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.members = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.name = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.ownerId = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.pageLayout = (JpaPageLayout)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.pageType = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.parentPage = (JpaPage)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 8: {
                this.regions = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 9: {
                this.serializedData = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 10: {
                this.subPages = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.contextId);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.entityId);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.members);
                return;
            }
            case 3: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.name);
                return;
            }
            case 4: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.ownerId);
                return;
            }
            case 5: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.pageLayout);
                return;
            }
            case 6: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.pageType);
                return;
            }
            case 7: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.parentPage);
                return;
            }
            case 8: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.regions);
                return;
            }
            case 9: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.serializedData);
                return;
            }
            case 10: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.subPages);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(JpaPage jpaPage, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.contextId = jpaPage.contextId;
                return;
            }
            case 1: {
                this.entityId = jpaPage.entityId;
                return;
            }
            case 2: {
                this.members = jpaPage.members;
                return;
            }
            case 3: {
                this.name = jpaPage.name;
                return;
            }
            case 4: {
                this.ownerId = jpaPage.ownerId;
                return;
            }
            case 5: {
                this.pageLayout = jpaPage.pageLayout;
                return;
            }
            case 6: {
                this.pageType = jpaPage.pageType;
                return;
            }
            case 7: {
                this.parentPage = jpaPage.parentPage;
                return;
            }
            case 8: {
                this.regions = jpaPage.regions;
                return;
            }
            case 9: {
                this.serializedData = jpaPage.serializedData;
                return;
            }
            case 10: {
                this.subPages = jpaPage.subPages;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcCopyFields(Object object, int[] nArray) {
        JpaPage jpaPage = (JpaPage)object;
        if (jpaPage.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(jpaPage, nArray[n]);
            ++n;
        }
    }

    public Object pcGetGenericContext() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getGenericContext();
    }

    public Object pcFetchObjectId() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.fetchObjectId();
    }

    public boolean pcIsDeleted() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isDeleted();
    }

    public boolean pcIsDirty() {
        if (this.pcStateManager == null) {
            return false;
        }
        StateManager stateManager = this.pcStateManager;
        RedefinitionHelper.dirtyCheck((StateManager)stateManager);
        return stateManager.isDirty();
    }

    public boolean pcIsNew() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isNew();
    }

    public boolean pcIsPersistent() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isPersistent();
    }

    public boolean pcIsTransactional() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isTransactional();
    }

    public boolean pcSerializing() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.serializing();
    }

    public void pcDirty(String string) {
        if (this.pcStateManager == null) {
            return;
        }
        this.pcStateManager.dirty(string);
    }

    public StateManager pcGetStateManager() {
        return this.pcStateManager;
    }

    public Object pcGetVersion() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getVersion();
    }

    public void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
        if (this.pcStateManager != null) {
            this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
            return;
        }
        this.pcStateManager = stateManager;
    }

    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsToObjectId(Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        LongId longId = (LongId)object;
        fieldConsumer.storeObjectField(1 + pcInheritedFieldCount, (Object)new Long(longId.getId()));
    }

    public void pcCopyKeyFieldsFromObjectId(Object object) {
        LongId longId = (LongId)object;
        this.entityId = new Long(longId.getId());
    }

    public Object pcNewObjectIdInstance(Object object) {
        Class clazz = class$Lorg$apache$rave$portal$model$JpaPage != null ? class$Lorg$apache$rave$portal$model$JpaPage : (class$Lorg$apache$rave$portal$model$JpaPage = JpaPage.class$("org.apache.rave.portal.model.JpaPage"));
        return new LongId(clazz, (String)object);
    }

    public Object pcNewObjectIdInstance() {
        Class clazz = class$Lorg$apache$rave$portal$model$JpaPage != null ? class$Lorg$apache$rave$portal$model$JpaPage : (class$Lorg$apache$rave$portal$model$JpaPage = JpaPage.class$("org.apache.rave.portal.model.JpaPage"));
        return new LongId(clazz, this.entityId);
    }

    private static final String pcGetcontextId(JpaPage jpaPage) {
        if (jpaPage.pcStateManager == null) {
            return jpaPage.contextId;
        }
        int n = pcInheritedFieldCount + 0;
        jpaPage.pcStateManager.accessingField(n);
        return jpaPage.contextId;
    }

    private static final void pcSetcontextId(JpaPage jpaPage, String string) {
        if (jpaPage.pcStateManager == null) {
            jpaPage.contextId = string;
            return;
        }
        jpaPage.pcStateManager.settingStringField((PersistenceCapable)jpaPage, pcInheritedFieldCount + 0, jpaPage.contextId, string, 0);
    }

    private static final Long pcGetentityId(JpaPage jpaPage) {
        if (jpaPage.pcStateManager == null) {
            return jpaPage.entityId;
        }
        int n = pcInheritedFieldCount + 1;
        jpaPage.pcStateManager.accessingField(n);
        return jpaPage.entityId;
    }

    private static final void pcSetentityId(JpaPage jpaPage, Long l) {
        if (jpaPage.pcStateManager == null) {
            jpaPage.entityId = l;
            return;
        }
        jpaPage.pcStateManager.settingObjectField((PersistenceCapable)jpaPage, pcInheritedFieldCount + 1, (Object)jpaPage.entityId, (Object)l, 0);
    }

    private static final List pcGetmembers(JpaPage jpaPage) {
        if (jpaPage.pcStateManager == null) {
            return jpaPage.members;
        }
        int n = pcInheritedFieldCount + 2;
        jpaPage.pcStateManager.accessingField(n);
        return jpaPage.members;
    }

    private static final void pcSetmembers(JpaPage jpaPage, List list) {
        if (jpaPage.pcStateManager == null) {
            jpaPage.members = list;
            return;
        }
        jpaPage.pcStateManager.settingObjectField((PersistenceCapable)jpaPage, pcInheritedFieldCount + 2, jpaPage.members, (Object)list, 0);
    }

    private static final String pcGetname(JpaPage jpaPage) {
        if (jpaPage.pcStateManager == null) {
            return jpaPage.name;
        }
        int n = pcInheritedFieldCount + 3;
        jpaPage.pcStateManager.accessingField(n);
        return jpaPage.name;
    }

    private static final void pcSetname(JpaPage jpaPage, String string) {
        if (jpaPage.pcStateManager == null) {
            jpaPage.name = string;
            return;
        }
        jpaPage.pcStateManager.settingStringField((PersistenceCapable)jpaPage, pcInheritedFieldCount + 3, jpaPage.name, string, 0);
    }

    private static final String pcGetownerId(JpaPage jpaPage) {
        if (jpaPage.pcStateManager == null) {
            return jpaPage.ownerId;
        }
        int n = pcInheritedFieldCount + 4;
        jpaPage.pcStateManager.accessingField(n);
        return jpaPage.ownerId;
    }

    private static final void pcSetownerId(JpaPage jpaPage, String string) {
        if (jpaPage.pcStateManager == null) {
            jpaPage.ownerId = string;
            return;
        }
        jpaPage.pcStateManager.settingStringField((PersistenceCapable)jpaPage, pcInheritedFieldCount + 4, jpaPage.ownerId, string, 0);
    }

    private static final JpaPageLayout pcGetpageLayout(JpaPage jpaPage) {
        if (jpaPage.pcStateManager == null) {
            return jpaPage.pageLayout;
        }
        int n = pcInheritedFieldCount + 5;
        jpaPage.pcStateManager.accessingField(n);
        return jpaPage.pageLayout;
    }

    private static final void pcSetpageLayout(JpaPage jpaPage, JpaPageLayout jpaPageLayout) {
        if (jpaPage.pcStateManager == null) {
            jpaPage.pageLayout = jpaPageLayout;
            return;
        }
        jpaPage.pcStateManager.settingObjectField((PersistenceCapable)jpaPage, pcInheritedFieldCount + 5, (Object)jpaPage.pageLayout, (Object)jpaPageLayout, 0);
    }

    private static final String pcGetpageType(JpaPage jpaPage) {
        if (jpaPage.pcStateManager == null) {
            return jpaPage.pageType;
        }
        int n = pcInheritedFieldCount + 6;
        jpaPage.pcStateManager.accessingField(n);
        return jpaPage.pageType;
    }

    private static final void pcSetpageType(JpaPage jpaPage, String string) {
        if (jpaPage.pcStateManager == null) {
            jpaPage.pageType = string;
            return;
        }
        jpaPage.pcStateManager.settingStringField((PersistenceCapable)jpaPage, pcInheritedFieldCount + 6, jpaPage.pageType, string, 0);
    }

    private static final JpaPage pcGetparentPage(JpaPage jpaPage) {
        if (jpaPage.pcStateManager == null) {
            return jpaPage.parentPage;
        }
        int n = pcInheritedFieldCount + 7;
        jpaPage.pcStateManager.accessingField(n);
        return jpaPage.parentPage;
    }

    private static final void pcSetparentPage(JpaPage jpaPage, JpaPage jpaPage2) {
        if (jpaPage.pcStateManager == null) {
            jpaPage.parentPage = jpaPage2;
            return;
        }
        jpaPage.pcStateManager.settingObjectField((PersistenceCapable)jpaPage, pcInheritedFieldCount + 7, (Object)jpaPage.parentPage, (Object)jpaPage2, 0);
    }

    private static final List pcGetregions(JpaPage jpaPage) {
        if (jpaPage.pcStateManager == null) {
            return jpaPage.regions;
        }
        int n = pcInheritedFieldCount + 8;
        jpaPage.pcStateManager.accessingField(n);
        return jpaPage.regions;
    }

    private static final void pcSetregions(JpaPage jpaPage, List list) {
        if (jpaPage.pcStateManager == null) {
            jpaPage.regions = list;
            return;
        }
        jpaPage.pcStateManager.settingObjectField((PersistenceCapable)jpaPage, pcInheritedFieldCount + 8, jpaPage.regions, (Object)list, 0);
    }

    private static final String pcGetserializedData(JpaPage jpaPage) {
        if (jpaPage.pcStateManager == null) {
            return jpaPage.serializedData;
        }
        int n = pcInheritedFieldCount + 9;
        jpaPage.pcStateManager.accessingField(n);
        return jpaPage.serializedData;
    }

    private static final void pcSetserializedData(JpaPage jpaPage, String string) {
        if (jpaPage.pcStateManager == null) {
            jpaPage.serializedData = string;
            return;
        }
        jpaPage.pcStateManager.settingStringField((PersistenceCapable)jpaPage, pcInheritedFieldCount + 9, jpaPage.serializedData, string, 0);
    }

    private static final List pcGetsubPages(JpaPage jpaPage) {
        if (jpaPage.pcStateManager == null) {
            return jpaPage.subPages;
        }
        int n = pcInheritedFieldCount + 10;
        jpaPage.pcStateManager.accessingField(n);
        return jpaPage.subPages;
    }

    private static final void pcSetsubPages(JpaPage jpaPage, List list) {
        if (jpaPage.pcStateManager == null) {
            jpaPage.subPages = list;
            return;
        }
        jpaPage.pcStateManager.settingObjectField((PersistenceCapable)jpaPage, pcInheritedFieldCount + 10, jpaPage.subPages, (Object)list, 0);
    }

    public Boolean pcIsDetached() {
        if (this.pcStateManager != null) {
            if (this.pcStateManager.isDetached()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
            return Boolean.TRUE;
        }
        if (this.entityId != null) {
            return Boolean.TRUE;
        }
        if (!this.pcisDetachedStateDefinitive()) {
            return null;
        }
        if (this.pcGetDetachedState() == null) {
            return Boolean.FALSE;
        }
        return null;
    }

    private boolean pcisDetachedStateDefinitive() {
        return false;
    }

    public Object pcGetDetachedState() {
        return this.pcDetachedState;
    }

    public void pcSetDetachedState(Object object) {
        this.pcDetachedState = object;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }

    class SubPageComparator
    implements Comparator<Page> {
        SubPageComparator() {
        }

        @Override
        public int compare(Page o1, Page o2) {
            if (o1 == null || o1.getMembers() == null || o1.getMembers().isEmpty()) {
                return 1;
            }
            if (o2 == null || o2.getMembers() == null || o2.getMembers().isEmpty()) {
                return -1;
            }
            Long o1RenderSequence = null;
            Long o2RenderSequence = null;
            for (PageUser pageUser : o1.getMembers()) {
                if (!pageUser.getUserId().equals(o1.getOwnerId())) continue;
                o1RenderSequence = pageUser.getRenderSequence();
                break;
            }
            for (PageUser pageUser : o2.getMembers()) {
                if (!pageUser.getUserId().equals(o2.getOwnerId())) continue;
                o2RenderSequence = pageUser.getRenderSequence();
                break;
            }
            return o1RenderSequence.compareTo(o2RenderSequence);
        }
    }
}

