/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.RedefinitionHelper;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.LongId;
import org.apache.rave.model.Category;
import org.apache.rave.model.Widget;
import org.apache.rave.model.WidgetComment;
import org.apache.rave.model.WidgetRating;
import org.apache.rave.model.WidgetStatus;
import org.apache.rave.model.WidgetTag;
import org.apache.rave.persistence.jpa.JpaSerializable;
import org.apache.rave.portal.model.BasicEntity;
import org.apache.rave.portal.model.JpaCategory;
import org.apache.rave.portal.model.JpaWidgetComment;
import org.apache.rave.portal.model.JpaWidgetRating;
import org.apache.rave.portal.model.JpaWidgetTag;
import org.apache.rave.portal.model.conversion.ConvertingListProxyFactory;
import org.apache.rave.util.JsonUtils;

@XmlAccessorType(value=XmlAccessType.NONE)
@Entity
@Access(value=AccessType.FIELD)
@Table(name="widget")
@NamedQueries(value={@NamedQuery(name="Widget.getAll", query="SELECT w FROM JpaWidget w  ORDER BY w.featured DESC, w.title ASC "), @NamedQuery(name="Widget.countAll", query="SELECT count(w) FROM JpaWidget w "), @NamedQuery(name="Widget.getByOwner", query="SELECT w FROM JpaWidget w  WHERE w.ownerId = :owner ORDER BY w.featured DESC, w.title ASC "), @NamedQuery(name="Widget.countByOwner", query="SELECT count(w) FROM JpaWidget w  WHERE w.ownerId = :owner"), @NamedQuery(name="Widget.getByFreeText", query="SELECT w FROM JpaWidget w  WHERE lower(w.title) LIKE :searchTerm OR w.description LIKE :description ORDER BY w.featured DESC, w.title ASC "), @NamedQuery(name="Widget.countByFreeText", query="SELECT count(w) FROM JpaWidget w  WHERE lower(w.title) LIKE :searchTerm OR w.description LIKE :description"), @NamedQuery(name="Widget.getByStatus", query="SELECT w FROM JpaWidget w  WHERE w.widgetStatus = :widgetStatus ORDER BY w.featured DESC, w.title ASC "), @NamedQuery(name="Widget.countByStatus", query="SELECT count(w) FROM JpaWidget w  WHERE w.widgetStatus = :widgetStatus"), @NamedQuery(name="Widget.getByUrl", query="SELECT w FROM JpaWidget w  WHERE w.url = :url"), @NamedQuery(name="Widget.getByTag", query="SELECT w FROM JpaWidget w  join w.tags wt WHERE wt.tagId = :tagId ORDER BY w.featured DESC, w.title ASC "), @NamedQuery(name="Widget.countByTag", query="SELECT count(w) FROM JpaWidget w  join w.tags wt WHERE wt.tagId = :tagId"), @NamedQuery(name="Widget.unassignOwner", query="UPDATE JpaWidget w SET w.ownerId = null  WHERE w.ownerId = :owner")})
public class JpaWidget
implements BasicEntity,
Serializable,
JpaSerializable,
Widget,
PersistenceCapable {
    private static final long serialVersionUID = 2L;
    public static final String PARAM_SEARCH_TERM = "searchTerm";
    public static final String PARAM_STATUS = "widgetStatus";
    public static final String PARAM_URL = "url";
    public static final String PARAM_OWNER = "owner";
    public static final String PARAM_TAG_ID = "tagId";
    public static final String GET_ALL = "Widget.getAll";
    public static final String GET_COUNT = "Widget.countAll";
    public static final String WIDGET_GET_BY_OWNER = "Widget.getByOwner";
    public static final String WIDGET_COUNT_BY_OWNER = "Widget.countByOwner";
    public static final String WIDGET_GET_BY_FREE_TEXT = "Widget.getByFreeText";
    public static final String WIDGET_COUNT_BY_FREE_TEXT = "Widget.countByFreeText";
    public static final String WIDGET_GET_BY_STATUS = "Widget.getByStatus";
    public static final String WIDGET_COUNT_BY_STATUS = "Widget.countByStatus";
    public static final String WIDGET_GET_BY_URL = "Widget.getByUrl";
    public static final String WIDGET_GET_BY_TAG = "Widget.getByTag";
    public static final String WIDGET_COUNT_BY_TAG = "Widget.countByTag";
    public static final String WIDGET_UNASSIGN_OWNER = "Widget.unassignOwner";
    static final String SELECT_W_FROM_WIDGET_W = "SELECT w FROM JpaWidget w ";
    static final String SELECT_COUNT_W_FROM_WIDGET_W = "SELECT count(w) FROM JpaWidget w ";
    static final String WHERE_CLAUSE_FREE_TEXT = " WHERE lower(w.title) LIKE :searchTerm OR w.description LIKE :description";
    static final String WHERE_CLAUSE_STATUS = " WHERE w.widgetStatus = :widgetStatus";
    static final String WHERE_CLAUSE_URL = " WHERE w.url = :url";
    static final String WHERE_CLAUSE_OWNER = " WHERE w.ownerId = :owner";
    static final String WHERE_CLAUSE_TAG_ID = " WHERE wt.tagId = :tagId";
    static final String JOIN_TAGS = " join w.tags wt";
    static final String ORDER_BY_TITLE_ASC = " ORDER BY w.featured DESC, w.title ASC ";
    @Id
    @Column(name="entity_id")
    @GeneratedValue(strategy=GenerationType.TABLE, generator="widgetIdGenerator")
    @TableGenerator(name="widgetIdGenerator", table="RAVE_PORTAL_SEQUENCES", pkColumnName="SEQ_NAME", valueColumnName="SEQ_COUNT", pkColumnValue="widget", allocationSize=1, initialValue=1)
    private Long entityId;
    @XmlElement
    @Basic
    @Column(name="title")
    private String title;
    @XmlElement
    @Basic
    @Column(name="title_url")
    private String titleUrl;
    @XmlElement
    @Basic
    @Column(name="url", unique=true)
    private String url;
    @Basic
    @Column(name="thumbnail_url")
    private String thumbnailUrl;
    @Basic
    @Column(name="screenshot_url")
    private String screenshotUrl;
    @XmlElement
    @Basic
    @Column(name="type")
    private String type;
    @XmlElement
    @Basic
    @Column(name="author")
    private String author;
    @XmlElement
    @Basic
    @Column(name="author_email")
    private String authorEmail;
    @XmlElement
    @Basic
    @Column(name="description")
    @Lob
    private String description;
    @XmlElement(name="status")
    @Basic
    @Column(name="widget_status")
    @Enumerated(value=EnumType.STRING)
    private WidgetStatus widgetStatus;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="widget_id", referencedColumnName="entity_id")
    private List<JpaWidgetComment> comments;
    @Basic
    @Column(name="owner_id")
    private String ownerId;
    @XmlElement
    @Basic
    @Column(name="disable_rendering")
    private boolean disableRendering;
    @XmlElement
    @Basic
    @Column(name="disable_rendering_message")
    private String disableRenderingMessage;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="widget_id", referencedColumnName="entity_id")
    private List<JpaWidgetRating> ratings;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="widget_id", referencedColumnName="entity_id")
    private List<JpaWidgetTag> tags;
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="widget_category", joinColumns={@JoinColumn(name="widget_id", referencedColumnName="entity_id")}, inverseJoinColumns={@JoinColumn(name="category_id", referencedColumnName="entity_id")})
    @OrderBy(value="text")
    private List<JpaCategory> categories;
    @XmlElement
    @Basic
    @Column(name="featured", columnDefinition="boolean default false")
    private boolean featured;
    @Lob
    @JsonIgnore
    @Column(name="serialized_data")
    private String serializedData;
    @Transient
    private Map<String, Object> properties;
    private static int pcInheritedFieldCount;
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    protected transient StateManager pcStateManager;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Ljava$util$List;
    static /* synthetic */ Class class$Ljava$lang$Long;
    static /* synthetic */ Class class$Lorg$apache$rave$model$WidgetStatus;
    static /* synthetic */ Class class$Lorg$apache$rave$portal$model$JpaWidget;
    private transient Object pcDetachedState;

    public JpaWidget() {
    }

    public JpaWidget(Long entityId, String url) {
        this.entityId = entityId;
        this.url = url;
    }

    @Override
    public Long getEntityId() {
        return JpaWidget.pcGetentityId(this);
    }

    @Override
    public void setEntityId(Long entityId) {
        JpaWidget.pcSetentityId(this, entityId);
    }

    public String getId() {
        return this.getEntityId() == null ? null : this.getEntityId().toString();
    }

    public String getScreenshotUrl() {
        return JpaWidget.pcGetscreenshotUrl(this);
    }

    public void setScreenshotUrl(String screenshotUrl) {
        JpaWidget.pcSetscreenshotUrl(this, screenshotUrl);
    }

    public String getAuthor() {
        return JpaWidget.pcGetauthor(this);
    }

    public void setAuthor(String author) {
        JpaWidget.pcSetauthor(this, author);
    }

    public String getAuthorEmail() {
        return JpaWidget.pcGetauthorEmail(this);
    }

    public void setAuthorEmail(String authorEmail) {
        JpaWidget.pcSetauthorEmail(this, authorEmail);
    }

    public String getDescription() {
        return JpaWidget.pcGetdescription(this);
    }

    public void setDescription(String description) {
        JpaWidget.pcSetdescription(this, description);
    }

    public String getThumbnailUrl() {
        return JpaWidget.pcGetthumbnailUrl(this);
    }

    public void setThumbnailUrl(String thumbnailUrl) {
        JpaWidget.pcSetthumbnailUrl(this, thumbnailUrl);
    }

    public String getType() {
        return JpaWidget.pcGettype(this);
    }

    public void setType(String type) {
        JpaWidget.pcSettype(this, type);
    }

    public String getTitle() {
        return JpaWidget.pcGettitle(this);
    }

    public void setTitle(String title) {
        JpaWidget.pcSettitle(this, title);
    }

    public String getTitleUrl() {
        return JpaWidget.pcGettitleUrl(this);
    }

    public void setTitleUrl(String titleUrl) {
        JpaWidget.pcSettitleUrl(this, titleUrl);
    }

    public String getUrl() {
        return JpaWidget.pcGeturl(this);
    }

    public void setUrl(String url) {
        JpaWidget.pcSeturl(this, url);
    }

    public WidgetStatus getWidgetStatus() {
        return JpaWidget.pcGetwidgetStatus(this);
    }

    public void setWidgetStatus(WidgetStatus widgetStatus) {
        JpaWidget.pcSetwidgetStatus(this, widgetStatus);
    }

    public List<WidgetComment> getComments() {
        return ConvertingListProxyFactory.createProxyList(WidgetComment.class, JpaWidget.pcGetcomments(this));
    }

    public void setComments(List<WidgetComment> comments) {
        if (JpaWidget.pcGetcomments(this) == null) {
            JpaWidget.pcSetcomments(this, new ArrayList());
        }
        this.getComments().clear();
        if (comments != null) {
            this.getComments().addAll(comments);
        }
    }

    public String getOwnerId() {
        return JpaWidget.pcGetownerId(this);
    }

    public void setOwnerId(String owner) {
        JpaWidget.pcSetownerId(this, owner);
    }

    public List<WidgetRating> getRatings() {
        return ConvertingListProxyFactory.createProxyList(WidgetRating.class, JpaWidget.pcGetratings(this));
    }

    public void setRatings(List<WidgetRating> ratings) {
        if (JpaWidget.pcGetratings(this) == null) {
            JpaWidget.pcSetratings(this, new ArrayList());
        }
        this.getRatings().clear();
        if (ratings != null) {
            this.getRatings().addAll(ratings);
        }
    }

    public boolean isDisableRendering() {
        return JpaWidget.pcGetdisableRendering(this);
    }

    public void setDisableRendering(boolean disableRendering) {
        JpaWidget.pcSetdisableRendering(this, disableRendering);
    }

    public String getDisableRenderingMessage() {
        return JpaWidget.pcGetdisableRenderingMessage(this);
    }

    public void setDisableRenderingMessage(String disableRenderingMessage) {
        JpaWidget.pcSetdisableRenderingMessage(this, disableRenderingMessage);
    }

    public List<WidgetTag> getTags() {
        return ConvertingListProxyFactory.createProxyList(WidgetTag.class, JpaWidget.pcGettags(this));
    }

    public void setTags(List<WidgetTag> tags) {
        if (JpaWidget.pcGettags(this) == null) {
            JpaWidget.pcSettags(this, new ArrayList());
        }
        this.getTags().clear();
        if (tags != null) {
            this.getTags().addAll(tags);
        }
    }

    public List<Category> getCategories() {
        return ConvertingListProxyFactory.createProxyList(Category.class, JpaWidget.pcGetcategories(this));
    }

    public void setCategories(List<Category> categories) {
        if (JpaWidget.pcGetcategories(this) == null) {
            JpaWidget.pcSetcategories(this, new ArrayList());
        }
        this.getCategories().clear();
        if (categories != null) {
            this.getCategories().addAll(categories);
        }
    }

    public boolean isFeatured() {
        return JpaWidget.pcGetfeatured(this);
    }

    public void setFeatured(boolean featured) {
        JpaWidget.pcSetfeatured(this, featured);
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public String getSerializedData() {
        return JpaWidget.pcGetserializedData(this);
    }

    public void setSerializedData(String serializedData) {
        JpaWidget.pcSetserializedData(this, serializedData);
    }

    @Override
    public void serializeData() {
        Map<String, Object> properties = this.getProperties();
        if (properties != null) {
            JpaWidget.pcSetserializedData(this, JsonUtils.stringify(properties));
        }
    }

    @Override
    public void deserializeData() {
        if (JpaWidget.pcGetserializedData(this) != null) {
            this.setProperties((Map)JsonUtils.parse((String)JpaWidget.pcGetserializedData(this), Map.class));
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JpaWidget other = (JpaWidget)obj;
        return JpaWidget.pcGetentityId(this) == JpaWidget.pcGetentityId(other) || JpaWidget.pcGetentityId(this) != null && JpaWidget.pcGetentityId(this).equals(JpaWidget.pcGetentityId(other));
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + (JpaWidget.pcGetentityId(this) != null ? JpaWidget.pcGetentityId(this).hashCode() : 0);
        return hash;
    }

    public String toString() {
        return "Widget{entityId=" + JpaWidget.pcGetentityId(this) + ", title='" + JpaWidget.pcGettitle(this) + '\'' + ", url='" + JpaWidget.pcGeturl(this) + '\'' + ", thumbnailUrl='" + JpaWidget.pcGetthumbnailUrl(this) + '\'' + ", screenshotUrl='" + JpaWidget.pcGetscreenshotUrl(this) + '\'' + ", type='" + JpaWidget.pcGettype(this) + '\'' + ", author='" + JpaWidget.pcGetauthor(this) + '\'' + ", description='" + JpaWidget.pcGetdescription(this) + '\'' + ", widgetStatus=" + JpaWidget.pcGetwidgetStatus(this) + '\'' + ", ownerId=" + JpaWidget.pcGetownerId(this) + '\'' + ", featured=" + JpaWidget.pcGetfeatured(this) + '\'' + ", disable_rendering=" + JpaWidget.pcGetdisableRendering(this) + '\'' + ", disable_rendering_message=" + JpaWidget.pcGetdisableRenderingMessage(this) + '}';
    }

    public int pcGetEnhancementContractVersion() {
        return 1468245;
    }

    static {
        pcFieldNames = new String[]{"author", "authorEmail", "categories", "comments", "description", "disableRendering", "disableRenderingMessage", "entityId", "featured", "ownerId", "ratings", "screenshotUrl", "serializedData", "tags", "thumbnailUrl", "title", "titleUrl", "type", PARAM_URL, PARAM_STATUS};
        Class[] classArray = new Class[20];
        Class clazz = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JpaWidget.class$("java.lang.String"));
        classArray[0] = clazz;
        classArray[1] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JpaWidget.class$("java.lang.String"));
        Class clazz2 = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = JpaWidget.class$("java.util.List"));
        classArray[2] = clazz2;
        classArray[3] = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = JpaWidget.class$("java.util.List"));
        classArray[4] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JpaWidget.class$("java.lang.String"));
        classArray[5] = Boolean.TYPE;
        classArray[6] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JpaWidget.class$("java.lang.String"));
        Class clazz3 = class$Ljava$lang$Long != null ? class$Ljava$lang$Long : (class$Ljava$lang$Long = JpaWidget.class$("java.lang.Long"));
        classArray[7] = clazz3;
        classArray[8] = Boolean.TYPE;
        classArray[9] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JpaWidget.class$("java.lang.String"));
        classArray[10] = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = JpaWidget.class$("java.util.List"));
        classArray[11] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JpaWidget.class$("java.lang.String"));
        classArray[12] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JpaWidget.class$("java.lang.String"));
        classArray[13] = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = JpaWidget.class$("java.util.List"));
        classArray[14] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JpaWidget.class$("java.lang.String"));
        classArray[15] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JpaWidget.class$("java.lang.String"));
        classArray[16] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JpaWidget.class$("java.lang.String"));
        classArray[17] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JpaWidget.class$("java.lang.String"));
        classArray[18] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JpaWidget.class$("java.lang.String"));
        Class clazz4 = class$Lorg$apache$rave$model$WidgetStatus != null ? class$Lorg$apache$rave$model$WidgetStatus : (class$Lorg$apache$rave$model$WidgetStatus = JpaWidget.class$("org.apache.rave.model.WidgetStatus"));
        classArray[19] = clazz4;
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 26, 10, 10, 26, 26, 26, 26, 26, 26, 10, 26, 26, 10, 26, 26, 26, 26, 26, 26};
        Class clazz5 = class$Lorg$apache$rave$portal$model$JpaWidget != null ? class$Lorg$apache$rave$portal$model$JpaWidget : (class$Lorg$apache$rave$portal$model$JpaWidget = JpaWidget.class$("org.apache.rave.portal.model.JpaWidget"));
        PCRegistry.register((Class)clazz5, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"JpaWidget", (PersistenceCapable)new JpaWidget());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void pcClearFields() {
        this.author = null;
        this.authorEmail = null;
        this.categories = null;
        this.comments = null;
        this.description = null;
        this.disableRendering = false;
        this.disableRenderingMessage = null;
        this.entityId = null;
        this.featured = false;
        this.ownerId = null;
        this.ratings = null;
        this.screenshotUrl = null;
        this.serializedData = null;
        this.tags = null;
        this.thumbnailUrl = null;
        this.title = null;
        this.titleUrl = null;
        this.type = null;
        this.url = null;
        this.widgetStatus = null;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        JpaWidget jpaWidget = new JpaWidget();
        if (bl) {
            jpaWidget.pcClearFields();
        }
        jpaWidget.pcStateManager = stateManager;
        jpaWidget.pcCopyKeyFieldsFromObjectId(object);
        return jpaWidget;
    }

    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        JpaWidget jpaWidget = new JpaWidget();
        if (bl) {
            jpaWidget.pcClearFields();
        }
        jpaWidget.pcStateManager = stateManager;
        return jpaWidget;
    }

    protected static int pcGetManagedFieldCount() {
        return 20;
    }

    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.author = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.authorEmail = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.categories = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.comments = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.description = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.disableRendering = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.disableRenderingMessage = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.entityId = (Long)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 8: {
                this.featured = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 9: {
                this.ownerId = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 10: {
                this.ratings = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 11: {
                this.screenshotUrl = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 12: {
                this.serializedData = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 13: {
                this.tags = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 14: {
                this.thumbnailUrl = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 15: {
                this.title = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 16: {
                this.titleUrl = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 17: {
                this.type = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 18: {
                this.url = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 19: {
                this.widgetStatus = (WidgetStatus)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.author);
                return;
            }
            case 1: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.authorEmail);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.categories);
                return;
            }
            case 3: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.comments);
                return;
            }
            case 4: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.description);
                return;
            }
            case 5: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.disableRendering);
                return;
            }
            case 6: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.disableRenderingMessage);
                return;
            }
            case 7: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.entityId);
                return;
            }
            case 8: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.featured);
                return;
            }
            case 9: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.ownerId);
                return;
            }
            case 10: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.ratings);
                return;
            }
            case 11: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.screenshotUrl);
                return;
            }
            case 12: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.serializedData);
                return;
            }
            case 13: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.tags);
                return;
            }
            case 14: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.thumbnailUrl);
                return;
            }
            case 15: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.title);
                return;
            }
            case 16: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.titleUrl);
                return;
            }
            case 17: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.type);
                return;
            }
            case 18: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.url);
                return;
            }
            case 19: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.widgetStatus);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(JpaWidget jpaWidget, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 0: {
                this.author = jpaWidget.author;
                return;
            }
            case 1: {
                this.authorEmail = jpaWidget.authorEmail;
                return;
            }
            case 2: {
                this.categories = jpaWidget.categories;
                return;
            }
            case 3: {
                this.comments = jpaWidget.comments;
                return;
            }
            case 4: {
                this.description = jpaWidget.description;
                return;
            }
            case 5: {
                this.disableRendering = jpaWidget.disableRendering;
                return;
            }
            case 6: {
                this.disableRenderingMessage = jpaWidget.disableRenderingMessage;
                return;
            }
            case 7: {
                this.entityId = jpaWidget.entityId;
                return;
            }
            case 8: {
                this.featured = jpaWidget.featured;
                return;
            }
            case 9: {
                this.ownerId = jpaWidget.ownerId;
                return;
            }
            case 10: {
                this.ratings = jpaWidget.ratings;
                return;
            }
            case 11: {
                this.screenshotUrl = jpaWidget.screenshotUrl;
                return;
            }
            case 12: {
                this.serializedData = jpaWidget.serializedData;
                return;
            }
            case 13: {
                this.tags = jpaWidget.tags;
                return;
            }
            case 14: {
                this.thumbnailUrl = jpaWidget.thumbnailUrl;
                return;
            }
            case 15: {
                this.title = jpaWidget.title;
                return;
            }
            case 16: {
                this.titleUrl = jpaWidget.titleUrl;
                return;
            }
            case 17: {
                this.type = jpaWidget.type;
                return;
            }
            case 18: {
                this.url = jpaWidget.url;
                return;
            }
            case 19: {
                this.widgetStatus = jpaWidget.widgetStatus;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void pcCopyFields(Object object, int[] nArray) {
        JpaWidget jpaWidget = (JpaWidget)object;
        if (jpaWidget.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(jpaWidget, nArray[n]);
            ++n;
        }
    }

    public Object pcGetGenericContext() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getGenericContext();
    }

    public Object pcFetchObjectId() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.fetchObjectId();
    }

    public boolean pcIsDeleted() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isDeleted();
    }

    public boolean pcIsDirty() {
        if (this.pcStateManager == null) {
            return false;
        }
        StateManager stateManager = this.pcStateManager;
        RedefinitionHelper.dirtyCheck((StateManager)stateManager);
        return stateManager.isDirty();
    }

    public boolean pcIsNew() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isNew();
    }

    public boolean pcIsPersistent() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isPersistent();
    }

    public boolean pcIsTransactional() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.isTransactional();
    }

    public boolean pcSerializing() {
        if (this.pcStateManager == null) {
            return false;
        }
        return this.pcStateManager.serializing();
    }

    public void pcDirty(String string) {
        if (this.pcStateManager == null) {
            return;
        }
        this.pcStateManager.dirty(string);
    }

    public StateManager pcGetStateManager() {
        return this.pcStateManager;
    }

    public Object pcGetVersion() {
        if (this.pcStateManager == null) {
            return null;
        }
        return this.pcStateManager.getVersion();
    }

    public void pcReplaceStateManager(StateManager stateManager) throws SecurityException {
        if (this.pcStateManager != null) {
            this.pcStateManager = this.pcStateManager.replaceStateManager(stateManager);
            return;
        }
        this.pcStateManager = stateManager;
    }

    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsToObjectId(Object object) {
        throw new InternalException();
    }

    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        LongId longId = (LongId)object;
        fieldConsumer.storeObjectField(7 + pcInheritedFieldCount, (Object)new Long(longId.getId()));
    }

    public void pcCopyKeyFieldsFromObjectId(Object object) {
        LongId longId = (LongId)object;
        this.entityId = new Long(longId.getId());
    }

    public Object pcNewObjectIdInstance(Object object) {
        Class clazz = class$Lorg$apache$rave$portal$model$JpaWidget != null ? class$Lorg$apache$rave$portal$model$JpaWidget : (class$Lorg$apache$rave$portal$model$JpaWidget = JpaWidget.class$("org.apache.rave.portal.model.JpaWidget"));
        return new LongId(clazz, (String)object);
    }

    public Object pcNewObjectIdInstance() {
        Class clazz = class$Lorg$apache$rave$portal$model$JpaWidget != null ? class$Lorg$apache$rave$portal$model$JpaWidget : (class$Lorg$apache$rave$portal$model$JpaWidget = JpaWidget.class$("org.apache.rave.portal.model.JpaWidget"));
        return new LongId(clazz, this.entityId);
    }

    private static final String pcGetauthor(JpaWidget jpaWidget) {
        if (jpaWidget.pcStateManager == null) {
            return jpaWidget.author;
        }
        int n = pcInheritedFieldCount + 0;
        jpaWidget.pcStateManager.accessingField(n);
        return jpaWidget.author;
    }

    private static final void pcSetauthor(JpaWidget jpaWidget, String string) {
        if (jpaWidget.pcStateManager == null) {
            jpaWidget.author = string;
            return;
        }
        jpaWidget.pcStateManager.settingStringField((PersistenceCapable)jpaWidget, pcInheritedFieldCount + 0, jpaWidget.author, string, 0);
    }

    private static final String pcGetauthorEmail(JpaWidget jpaWidget) {
        if (jpaWidget.pcStateManager == null) {
            return jpaWidget.authorEmail;
        }
        int n = pcInheritedFieldCount + 1;
        jpaWidget.pcStateManager.accessingField(n);
        return jpaWidget.authorEmail;
    }

    private static final void pcSetauthorEmail(JpaWidget jpaWidget, String string) {
        if (jpaWidget.pcStateManager == null) {
            jpaWidget.authorEmail = string;
            return;
        }
        jpaWidget.pcStateManager.settingStringField((PersistenceCapable)jpaWidget, pcInheritedFieldCount + 1, jpaWidget.authorEmail, string, 0);
    }

    private static final List pcGetcategories(JpaWidget jpaWidget) {
        if (jpaWidget.pcStateManager == null) {
            return jpaWidget.categories;
        }
        int n = pcInheritedFieldCount + 2;
        jpaWidget.pcStateManager.accessingField(n);
        return jpaWidget.categories;
    }

    private static final void pcSetcategories(JpaWidget jpaWidget, List list) {
        if (jpaWidget.pcStateManager == null) {
            jpaWidget.categories = list;
            return;
        }
        jpaWidget.pcStateManager.settingObjectField((PersistenceCapable)jpaWidget, pcInheritedFieldCount + 2, jpaWidget.categories, (Object)list, 0);
    }

    private static final List pcGetcomments(JpaWidget jpaWidget) {
        if (jpaWidget.pcStateManager == null) {
            return jpaWidget.comments;
        }
        int n = pcInheritedFieldCount + 3;
        jpaWidget.pcStateManager.accessingField(n);
        return jpaWidget.comments;
    }

    private static final void pcSetcomments(JpaWidget jpaWidget, List list) {
        if (jpaWidget.pcStateManager == null) {
            jpaWidget.comments = list;
            return;
        }
        jpaWidget.pcStateManager.settingObjectField((PersistenceCapable)jpaWidget, pcInheritedFieldCount + 3, jpaWidget.comments, (Object)list, 0);
    }

    private static final String pcGetdescription(JpaWidget jpaWidget) {
        if (jpaWidget.pcStateManager == null) {
            return jpaWidget.description;
        }
        int n = pcInheritedFieldCount + 4;
        jpaWidget.pcStateManager.accessingField(n);
        return jpaWidget.description;
    }

    private static final void pcSetdescription(JpaWidget jpaWidget, String string) {
        if (jpaWidget.pcStateManager == null) {
            jpaWidget.description = string;
            return;
        }
        jpaWidget.pcStateManager.settingStringField((PersistenceCapable)jpaWidget, pcInheritedFieldCount + 4, jpaWidget.description, string, 0);
    }

    private static final boolean pcGetdisableRendering(JpaWidget jpaWidget) {
        if (jpaWidget.pcStateManager == null) {
            return jpaWidget.disableRendering;
        }
        int n = pcInheritedFieldCount + 5;
        jpaWidget.pcStateManager.accessingField(n);
        return jpaWidget.disableRendering;
    }

    private static final void pcSetdisableRendering(JpaWidget jpaWidget, boolean bl) {
        if (jpaWidget.pcStateManager == null) {
            jpaWidget.disableRendering = bl;
            return;
        }
        jpaWidget.pcStateManager.settingBooleanField((PersistenceCapable)jpaWidget, pcInheritedFieldCount + 5, jpaWidget.disableRendering, bl, 0);
    }

    private static final String pcGetdisableRenderingMessage(JpaWidget jpaWidget) {
        if (jpaWidget.pcStateManager == null) {
            return jpaWidget.disableRenderingMessage;
        }
        int n = pcInheritedFieldCount + 6;
        jpaWidget.pcStateManager.accessingField(n);
        return jpaWidget.disableRenderingMessage;
    }

    private static final void pcSetdisableRenderingMessage(JpaWidget jpaWidget, String string) {
        if (jpaWidget.pcStateManager == null) {
            jpaWidget.disableRenderingMessage = string;
            return;
        }
        jpaWidget.pcStateManager.settingStringField((PersistenceCapable)jpaWidget, pcInheritedFieldCount + 6, jpaWidget.disableRenderingMessage, string, 0);
    }

    private static final Long pcGetentityId(JpaWidget jpaWidget) {
        if (jpaWidget.pcStateManager == null) {
            return jpaWidget.entityId;
        }
        int n = pcInheritedFieldCount + 7;
        jpaWidget.pcStateManager.accessingField(n);
        return jpaWidget.entityId;
    }

    private static final void pcSetentityId(JpaWidget jpaWidget, Long l) {
        if (jpaWidget.pcStateManager == null) {
            jpaWidget.entityId = l;
            return;
        }
        jpaWidget.pcStateManager.settingObjectField((PersistenceCapable)jpaWidget, pcInheritedFieldCount + 7, (Object)jpaWidget.entityId, (Object)l, 0);
    }

    private static final boolean pcGetfeatured(JpaWidget jpaWidget) {
        if (jpaWidget.pcStateManager == null) {
            return jpaWidget.featured;
        }
        int n = pcInheritedFieldCount + 8;
        jpaWidget.pcStateManager.accessingField(n);
        return jpaWidget.featured;
    }

    private static final void pcSetfeatured(JpaWidget jpaWidget, boolean bl) {
        if (jpaWidget.pcStateManager == null) {
            jpaWidget.featured = bl;
            return;
        }
        jpaWidget.pcStateManager.settingBooleanField((PersistenceCapable)jpaWidget, pcInheritedFieldCount + 8, jpaWidget.featured, bl, 0);
    }

    private static final String pcGetownerId(JpaWidget jpaWidget) {
        if (jpaWidget.pcStateManager == null) {
            return jpaWidget.ownerId;
        }
        int n = pcInheritedFieldCount + 9;
        jpaWidget.pcStateManager.accessingField(n);
        return jpaWidget.ownerId;
    }

    private static final void pcSetownerId(JpaWidget jpaWidget, String string) {
        if (jpaWidget.pcStateManager == null) {
            jpaWidget.ownerId = string;
            return;
        }
        jpaWidget.pcStateManager.settingStringField((PersistenceCapable)jpaWidget, pcInheritedFieldCount + 9, jpaWidget.ownerId, string, 0);
    }

    private static final List pcGetratings(JpaWidget jpaWidget) {
        if (jpaWidget.pcStateManager == null) {
            return jpaWidget.ratings;
        }
        int n = pcInheritedFieldCount + 10;
        jpaWidget.pcStateManager.accessingField(n);
        return jpaWidget.ratings;
    }

    private static final void pcSetratings(JpaWidget jpaWidget, List list) {
        if (jpaWidget.pcStateManager == null) {
            jpaWidget.ratings = list;
            return;
        }
        jpaWidget.pcStateManager.settingObjectField((PersistenceCapable)jpaWidget, pcInheritedFieldCount + 10, jpaWidget.ratings, (Object)list, 0);
    }

    private static final String pcGetscreenshotUrl(JpaWidget jpaWidget) {
        if (jpaWidget.pcStateManager == null) {
            return jpaWidget.screenshotUrl;
        }
        int n = pcInheritedFieldCount + 11;
        jpaWidget.pcStateManager.accessingField(n);
        return jpaWidget.screenshotUrl;
    }

    private static final void pcSetscreenshotUrl(JpaWidget jpaWidget, String string) {
        if (jpaWidget.pcStateManager == null) {
            jpaWidget.screenshotUrl = string;
            return;
        }
        jpaWidget.pcStateManager.settingStringField((PersistenceCapable)jpaWidget, pcInheritedFieldCount + 11, jpaWidget.screenshotUrl, string, 0);
    }

    private static final String pcGetserializedData(JpaWidget jpaWidget) {
        if (jpaWidget.pcStateManager == null) {
            return jpaWidget.serializedData;
        }
        int n = pcInheritedFieldCount + 12;
        jpaWidget.pcStateManager.accessingField(n);
        return jpaWidget.serializedData;
    }

    private static final void pcSetserializedData(JpaWidget jpaWidget, String string) {
        if (jpaWidget.pcStateManager == null) {
            jpaWidget.serializedData = string;
            return;
        }
        jpaWidget.pcStateManager.settingStringField((PersistenceCapable)jpaWidget, pcInheritedFieldCount + 12, jpaWidget.serializedData, string, 0);
    }

    private static final List pcGettags(JpaWidget jpaWidget) {
        if (jpaWidget.pcStateManager == null) {
            return jpaWidget.tags;
        }
        int n = pcInheritedFieldCount + 13;
        jpaWidget.pcStateManager.accessingField(n);
        return jpaWidget.tags;
    }

    private static final void pcSettags(JpaWidget jpaWidget, List list) {
        if (jpaWidget.pcStateManager == null) {
            jpaWidget.tags = list;
            return;
        }
        jpaWidget.pcStateManager.settingObjectField((PersistenceCapable)jpaWidget, pcInheritedFieldCount + 13, jpaWidget.tags, (Object)list, 0);
    }

    private static final String pcGetthumbnailUrl(JpaWidget jpaWidget) {
        if (jpaWidget.pcStateManager == null) {
            return jpaWidget.thumbnailUrl;
        }
        int n = pcInheritedFieldCount + 14;
        jpaWidget.pcStateManager.accessingField(n);
        return jpaWidget.thumbnailUrl;
    }

    private static final void pcSetthumbnailUrl(JpaWidget jpaWidget, String string) {
        if (jpaWidget.pcStateManager == null) {
            jpaWidget.thumbnailUrl = string;
            return;
        }
        jpaWidget.pcStateManager.settingStringField((PersistenceCapable)jpaWidget, pcInheritedFieldCount + 14, jpaWidget.thumbnailUrl, string, 0);
    }

    private static final String pcGettitle(JpaWidget jpaWidget) {
        if (jpaWidget.pcStateManager == null) {
            return jpaWidget.title;
        }
        int n = pcInheritedFieldCount + 15;
        jpaWidget.pcStateManager.accessingField(n);
        return jpaWidget.title;
    }

    private static final void pcSettitle(JpaWidget jpaWidget, String string) {
        if (jpaWidget.pcStateManager == null) {
            jpaWidget.title = string;
            return;
        }
        jpaWidget.pcStateManager.settingStringField((PersistenceCapable)jpaWidget, pcInheritedFieldCount + 15, jpaWidget.title, string, 0);
    }

    private static final String pcGettitleUrl(JpaWidget jpaWidget) {
        if (jpaWidget.pcStateManager == null) {
            return jpaWidget.titleUrl;
        }
        int n = pcInheritedFieldCount + 16;
        jpaWidget.pcStateManager.accessingField(n);
        return jpaWidget.titleUrl;
    }

    private static final void pcSettitleUrl(JpaWidget jpaWidget, String string) {
        if (jpaWidget.pcStateManager == null) {
            jpaWidget.titleUrl = string;
            return;
        }
        jpaWidget.pcStateManager.settingStringField((PersistenceCapable)jpaWidget, pcInheritedFieldCount + 16, jpaWidget.titleUrl, string, 0);
    }

    private static final String pcGettype(JpaWidget jpaWidget) {
        if (jpaWidget.pcStateManager == null) {
            return jpaWidget.type;
        }
        int n = pcInheritedFieldCount + 17;
        jpaWidget.pcStateManager.accessingField(n);
        return jpaWidget.type;
    }

    private static final void pcSettype(JpaWidget jpaWidget, String string) {
        if (jpaWidget.pcStateManager == null) {
            jpaWidget.type = string;
            return;
        }
        jpaWidget.pcStateManager.settingStringField((PersistenceCapable)jpaWidget, pcInheritedFieldCount + 17, jpaWidget.type, string, 0);
    }

    private static final String pcGeturl(JpaWidget jpaWidget) {
        if (jpaWidget.pcStateManager == null) {
            return jpaWidget.url;
        }
        int n = pcInheritedFieldCount + 18;
        jpaWidget.pcStateManager.accessingField(n);
        return jpaWidget.url;
    }

    private static final void pcSeturl(JpaWidget jpaWidget, String string) {
        if (jpaWidget.pcStateManager == null) {
            jpaWidget.url = string;
            return;
        }
        jpaWidget.pcStateManager.settingStringField((PersistenceCapable)jpaWidget, pcInheritedFieldCount + 18, jpaWidget.url, string, 0);
    }

    private static final WidgetStatus pcGetwidgetStatus(JpaWidget jpaWidget) {
        if (jpaWidget.pcStateManager == null) {
            return jpaWidget.widgetStatus;
        }
        int n = pcInheritedFieldCount + 19;
        jpaWidget.pcStateManager.accessingField(n);
        return jpaWidget.widgetStatus;
    }

    private static final void pcSetwidgetStatus(JpaWidget jpaWidget, WidgetStatus widgetStatus) {
        if (jpaWidget.pcStateManager == null) {
            jpaWidget.widgetStatus = widgetStatus;
            return;
        }
        jpaWidget.pcStateManager.settingObjectField((PersistenceCapable)jpaWidget, pcInheritedFieldCount + 19, (Object)jpaWidget.widgetStatus, (Object)widgetStatus, 0);
    }

    public Boolean pcIsDetached() {
        if (this.pcStateManager != null) {
            if (this.pcStateManager.isDetached()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (this.pcGetDetachedState() != null && this.pcGetDetachedState() != PersistenceCapable.DESERIALIZED) {
            return Boolean.TRUE;
        }
        if (this.entityId != null) {
            return Boolean.TRUE;
        }
        if (!this.pcisDetachedStateDefinitive()) {
            return null;
        }
        if (this.pcGetDetachedState() == null) {
            return Boolean.FALSE;
        }
        return null;
    }

    private boolean pcisDetachedStateDefinitive() {
        return false;
    }

    public Object pcGetDetachedState() {
        return this.pcDetachedState;
    }

    public void pcSetDetachedState(Object object) {
        this.pcDetachedState = object;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

