/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.model.conversion;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import org.apache.rave.portal.model.conversion.JpaConverter;
import org.springframework.stereotype.Component;

@Component
public class ConvertingListProxyFactory {
    public static <E, T extends E> List<E> createProxyList(Class<E> targetType, List<T> underlyingList) {
        if (underlyingList == null) {
            underlyingList = new ArrayList<T>();
        }
        return (List)Proxy.newProxyInstance(ConvertingListProxyFactory.class.getClassLoader(), new Class[]{List.class}, new ConvertingListInvocationHandler<E, T>(underlyingList, targetType));
    }

    public static class ConvertingListInvocationHandler<S, T>
    implements InvocationHandler {
        public static final String ADD_METHOD = "add";
        public static final String SET_METHOD = "set";
        public static final String ADD_ALL_METHOD = "addAll";
        private List<T> underlying;
        private Class<S> targetClass;

        public ConvertingListInvocationHandler(List<T> underlying, Class<S> targetClass) {
            this.underlying = underlying;
            this.targetClass = targetClass;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] parameters) throws Throwable {
            int convertIndex;
            String methodName = method.getName();
            int n = convertIndex = method.getParameterTypes().length == 1 ? 0 : 1;
            if (ADD_METHOD.equals(methodName) || SET_METHOD.equals(methodName)) {
                parameters[convertIndex] = JpaConverter.getInstance().convert(parameters[convertIndex], this.targetClass);
            } else if (ADD_ALL_METHOD.equals(methodName)) {
                this.convertAll((List)parameters[convertIndex]);
            }
            return method.invoke(this.underlying, parameters);
        }

        private void convertAll(List<S> parameter) {
            for (int i = 0; i < parameter.size(); ++i) {
                parameter.set(i, JpaConverter.getInstance().convert(parameter.get(i), this.targetClass));
            }
        }
    }
}

