/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.model.conversion;

import java.util.UUID;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.apache.rave.model.ActivityStreamsEntry;
import org.apache.rave.model.ModelConverter;
import org.apache.rave.persistence.jpa.util.JpaUtil;
import org.apache.rave.portal.model.JpaActivityStreamsEntry;
import org.springframework.stereotype.Component;

@Component
public class JpaActivityStreamsEntryConverter
implements ModelConverter<ActivityStreamsEntry, JpaActivityStreamsEntry> {
    @PersistenceContext
    private EntityManager manager;

    public JpaActivityStreamsEntry convert(ActivityStreamsEntry source) {
        if (source != null && source.getId() == null) {
            source.setId(UUID.randomUUID().toString());
        }
        return source instanceof JpaActivityStreamsEntry ? (JpaActivityStreamsEntry)source : this.createEntity(source);
    }

    public Class<ActivityStreamsEntry> getSourceType() {
        return ActivityStreamsEntry.class;
    }

    private JpaActivityStreamsEntry createEntity(ActivityStreamsEntry source) {
        JpaActivityStreamsEntry converted = null;
        if (source != null) {
            TypedQuery query = this.manager.createNamedQuery("JpaActivityStreamsEntry.findById", JpaActivityStreamsEntry.class);
            query.setParameter("id", (Object)source.getId());
            converted = (JpaActivityStreamsEntry)JpaUtil.getSingleResult(query.getResultList());
            if (converted == null) {
                converted = new JpaActivityStreamsEntry();
            }
            this.updateProperties(source, converted);
        }
        return converted;
    }

    private void updateProperties(ActivityStreamsEntry source, JpaActivityStreamsEntry converted) {
        converted.setId(source.getId());
        converted.setActor(source.getActor());
        converted.setOpenSocial(source.getOpenSocial());
        converted.setObject(source.getObject());
        converted.setObjectType(source.getObjectType());
        converted.setExtensions(source.getExtensions());
        converted.setGenerator(source.getGenerator());
        converted.setUrl(source.getUrl());
        converted.setIcon(source.getIcon());
        converted.setAppId(source.getAppId());
        converted.setProvider(source.getProvider());
        converted.setBcc(source.getBcc());
        converted.setBto(source.getBto());
        converted.setCc(source.getCc());
        converted.setContent(source.getContent());
        converted.setDc(source.getDc());
        converted.setContext(source.getContext());
        converted.setGeojson(source.getGeojson());
        converted.setGroupId(source.getGroupId());
        converted.setInReplyTo(source.getInReplyTo());
        converted.setLd(source.getLd());
        converted.setLinks(source.getLinks());
        converted.setEndTime(source.getEndTime());
        converted.setLocation(source.getLocation());
        converted.setMood(source.getMood());
        converted.setOdata(source.getOdata());
        converted.setPriority(source.getPriority());
        converted.setPublished(source.getPublished());
        converted.setTarget(source.getTarget());
        converted.setOpengraph(source.getOpengraph());
        converted.setProvider(source.getProvider());
        converted.setRating(source.getRating());
        converted.setResult(source.getResult());
        converted.setSchema_org(source.getSchema_org());
        converted.setSource(source.getSource());
        converted.setTags(source.getTags());
        converted.setTitle(source.getTitle());
        converted.setSource(source.getSource());
        converted.setTo(source.getTo());
        converted.setUpdated(source.getUpdated());
        converted.setUserId(source.getUserId());
        converted.setVerb(source.getVerb());
        converted.setUrl(source.getUrl());
    }
}

