/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.model.conversion;

import java.util.UUID;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.apache.rave.model.ActivityStreamsMediaLink;
import org.apache.rave.model.ModelConverter;
import org.apache.rave.persistence.jpa.util.JpaUtil;
import org.apache.rave.portal.model.JpaActivityStreamsMediaLink;
import org.springframework.stereotype.Component;

@Component
public class JpaActivityStreamsMediaLinkConverter
implements ModelConverter<ActivityStreamsMediaLink, JpaActivityStreamsMediaLink> {
    @PersistenceContext
    private EntityManager manager;

    public JpaActivityStreamsMediaLink convert(ActivityStreamsMediaLink source) {
        if (source != null && source.getId() == null) {
            source.setId(source.getUrl() == null ? UUID.randomUUID().toString() : source.getUrl());
        }
        return source instanceof JpaActivityStreamsMediaLink ? (JpaActivityStreamsMediaLink)source : this.createEntity(source);
    }

    public Class<ActivityStreamsMediaLink> getSourceType() {
        return ActivityStreamsMediaLink.class;
    }

    private JpaActivityStreamsMediaLink createEntity(ActivityStreamsMediaLink source) {
        JpaActivityStreamsMediaLink converted = null;
        if (source != null) {
            TypedQuery query = this.manager.createNamedQuery("JpaActivityStreamsMediaLink.findById", JpaActivityStreamsMediaLink.class);
            query.setParameter("id", (Object)source.getId());
            converted = (JpaActivityStreamsMediaLink)JpaUtil.getSingleResult(query.getResultList());
            if (converted == null) {
                converted = new JpaActivityStreamsMediaLink();
            }
            this.updateProperties(source, converted);
        }
        return converted;
    }

    private void updateProperties(ActivityStreamsMediaLink source, JpaActivityStreamsMediaLink converted) {
        converted.setDuration(source.getDuration());
        converted.setHeight(source.getHeight());
        converted.setWidth(source.getWidth());
        converted.setUrl(source.getUrl());
    }
}

