/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.model.conversion;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.rave.model.ModelConverter;
import org.apache.rave.model.OAuthTokenInfo;
import org.apache.rave.portal.model.JpaOAuthTokenInfo;
import org.springframework.stereotype.Component;

@Component
public class JpaOAuthTokenInfoConverter
implements ModelConverter<OAuthTokenInfo, JpaOAuthTokenInfo> {
    @PersistenceContext
    private EntityManager manager;

    public Class<OAuthTokenInfo> getSourceType() {
        return OAuthTokenInfo.class;
    }

    public JpaOAuthTokenInfo convert(OAuthTokenInfo source) {
        return source instanceof JpaOAuthTokenInfo ? (JpaOAuthTokenInfo)source : this.createEntity(source);
    }

    private JpaOAuthTokenInfo createEntity(OAuthTokenInfo source) {
        JpaOAuthTokenInfo converted = null;
        if (source != null) {
            JpaOAuthTokenInfo jpaOAuthTokenInfo = converted = source.getId() == null ? new JpaOAuthTokenInfo() : (JpaOAuthTokenInfo)this.manager.find(JpaOAuthTokenInfo.class, (Object)Long.parseLong(source.getId()));
            if (converted == null) {
                converted = new JpaOAuthTokenInfo();
            }
            this.updateProperties(source, converted);
        }
        return converted;
    }

    private void updateProperties(OAuthTokenInfo source, JpaOAuthTokenInfo converted) {
        converted.setId(source.getId());
        converted.setAccessToken(source.getAccessToken());
        converted.setAppUrl(source.getAppUrl());
        converted.setModuleId(source.getModuleId());
        converted.setServiceName(source.getServiceName());
        converted.setSessionHandle(source.getSessionHandle());
        converted.setTokenExpireMillis(source.getTokenExpireMillis());
        converted.setTokenName(source.getTokenName());
        converted.setTokenSecret(source.getTokenSecret());
        converted.setUserId(source.getUserId());
    }
}

