/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.model.conversion;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.rave.model.ModelConverter;
import org.apache.rave.model.Page;
import org.apache.rave.model.PageUser;
import org.apache.rave.portal.model.JpaPage;
import org.springframework.stereotype.Component;

@Component
public class JpaPageConverter
implements ModelConverter<Page, JpaPage> {
    @PersistenceContext
    private EntityManager manager;

    public Class<Page> getSourceType() {
        return Page.class;
    }

    public JpaPage convert(Page source) {
        if (source != null) {
            source.setPageType(source.getPageType() == null ? null : source.getPageType().toUpperCase());
            return source instanceof JpaPage ? (JpaPage)source : this.createEntity(source);
        }
        return null;
    }

    private JpaPage createEntity(Page source) {
        JpaPage converted;
        JpaPage jpaPage = converted = source.getId() == null ? new JpaPage() : (JpaPage)this.manager.find(JpaPage.class, (Object)Long.parseLong(source.getId()));
        if (converted == null) {
            converted = new JpaPage();
        }
        this.updateProperties(source, converted);
        return converted;
    }

    private void updateProperties(Page source, JpaPage converted) {
        this.replacePageReferences(source, converted);
        converted.setId(source.getId());
        converted.setMembers(source.getMembers());
        converted.setName(source.getName());
        converted.setOwnerId(source.getOwnerId());
        converted.setContextId(source.getContextId());
        converted.setPageLayout(source.getPageLayout());
        converted.setPageType(source.getPageType());
        converted.setParentPage(source.getParentPage());
        converted.setRegions(source.getRegions());
        converted.setSubPages(source.getSubPages());
        converted.setProperties(source.getProperties());
    }

    private void replacePageReferences(Page source, JpaPage converted) {
        if (source.getMembers() != null) {
            for (PageUser user : source.getMembers()) {
                user.setPage((Page)converted);
            }
        }
    }
}

