/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.model.conversion;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.rave.model.ModelConverter;
import org.apache.rave.model.PageTemplate;
import org.apache.rave.portal.model.JpaPageTemplate;
import org.springframework.stereotype.Component;

@Component
public class JpaPageTemplateConverter
implements ModelConverter<PageTemplate, JpaPageTemplate> {
    @PersistenceContext
    private EntityManager manager;

    public Class<PageTemplate> getSourceType() {
        return PageTemplate.class;
    }

    public JpaPageTemplate convert(PageTemplate source) {
        if (source != null) {
            source.setPageType(source.getPageType() == null ? null : source.getPageType().toUpperCase());
            return source instanceof JpaPageTemplate ? (JpaPageTemplate)source : this.createEntity(source);
        }
        return null;
    }

    private JpaPageTemplate createEntity(PageTemplate source) {
        JpaPageTemplate converted;
        JpaPageTemplate jpaPageTemplate = converted = source.getId() == null ? new JpaPageTemplate() : (JpaPageTemplate)this.manager.find(JpaPageTemplate.class, (Object)Long.parseLong(source.getId()));
        if (converted == null) {
            converted = new JpaPageTemplate();
        }
        this.updateProperties(source, converted);
        return converted;
    }

    private void updateProperties(PageTemplate source, JpaPageTemplate converted) {
        converted.setEntityId(source.getId() == null ? null : Long.valueOf(Long.parseLong(source.getId())));
        converted.setName(source.getName());
        converted.setDescription(source.getDescription());
        converted.setPageType(source.getPageType());
        converted.setParentPageTemplate(source.getParentPageTemplate());
        converted.setSubPageTemplates(source.getSubPageTemplates());
        converted.setPageLayout(source.getPageLayout());
        converted.setPageTemplateRegions(source.getPageTemplateRegions());
        converted.setRenderSequence(source.getRenderSequence());
        converted.setDefaultTemplate(source.isDefaultTemplate());
        converted.setProperties(source.getProperties());
    }
}

