/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.model.conversion;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.apache.rave.model.ModelConverter;
import org.apache.rave.model.Person;
import org.apache.rave.persistence.jpa.util.JpaUtil;
import org.apache.rave.portal.model.JpaPerson;
import org.springframework.stereotype.Component;

@Component
public class JpaPersonConverter
implements ModelConverter<Person, JpaPerson> {
    @PersistenceContext
    private EntityManager manager;

    public JpaPerson convert(Person source) {
        return source instanceof JpaPerson ? (JpaPerson)source : this.createEntity(source);
    }

    public Class<Person> getSourceType() {
        return Person.class;
    }

    private JpaPerson createEntity(Person source) {
        JpaPerson converted = null;
        if (source != null) {
            TypedQuery query = this.manager.createNamedQuery("Person.findByUsername", JpaPerson.class);
            query.setParameter("username", (Object)source.getUsername());
            converted = (JpaPerson)JpaUtil.getSingleResult(query.getResultList());
            if (converted == null) {
                converted = new JpaPerson();
            }
            this.updateProperties(source, converted);
        }
        return converted;
    }

    private void updateProperties(Person source, JpaPerson converted) {
        converted.setUsername(source.getUsername());
        converted.setEmail(source.getEmail());
        converted.setDisplayName(source.getDisplayName());
        converted.setAdditionalName(source.getUsername());
        converted.setFamilyName(source.getFamilyName());
        converted.setGivenName(source.getGivenName());
        converted.setHonorificPrefix(source.getHonorificPrefix());
        converted.setHonorificSuffix(source.getHonorificSuffix());
        converted.setPreferredName(source.getPreferredName());
        converted.setAboutMe(source.getAboutMe());
        converted.setStatus(source.getStatus());
        converted.setAddresses(source.getAddresses());
        converted.setOrganizations(source.getOrganizations());
        converted.setProperties(source.getProperties());
    }
}

