/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.model.conversion;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.apache.rave.model.ModelConverter;
import org.apache.rave.model.Region;
import org.apache.rave.persistence.jpa.util.JpaUtil;
import org.apache.rave.portal.model.JpaRegion;
import org.springframework.stereotype.Component;

@Component
public class JpaRegionConverter
implements ModelConverter<Region, JpaRegion> {
    @PersistenceContext
    private EntityManager manager;

    public Class<Region> getSourceType() {
        return Region.class;
    }

    public JpaRegion convert(Region source) {
        return source instanceof JpaRegion ? (JpaRegion)source : this.createEntity(source);
    }

    private JpaRegion createEntity(Region source) {
        JpaRegion converted = null;
        if (source != null) {
            TypedQuery query = this.manager.createNamedQuery("Region.findByEntityId", JpaRegion.class);
            query.setParameter("entity_id", source.getId() == null ? null : Long.valueOf(Long.parseLong(source.getId())));
            converted = (JpaRegion)JpaUtil.getSingleResult(query.getResultList());
            if (converted == null) {
                converted = new JpaRegion();
            }
            this.updateProperties(source, converted);
        }
        return converted;
    }

    private void updateProperties(Region source, JpaRegion converted) {
        converted.setEntityId(source.getId() == null ? null : Long.valueOf(Long.parseLong(source.getId())));
        converted.setLocked(source.isLocked());
        converted.setPage(source.getPage());
        converted.setRegionWidgets(source.getRegionWidgets());
        converted.setRenderOrder(source.getRenderOrder());
    }
}

