/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.model.conversion;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.apache.rave.model.ModelConverter;
import org.apache.rave.model.RegionWidget;
import org.apache.rave.persistence.jpa.util.JpaUtil;
import org.apache.rave.portal.model.JpaRegionWidget;
import org.springframework.stereotype.Component;

@Component
public class JpaRegionWidgetConverter
implements ModelConverter<RegionWidget, JpaRegionWidget> {
    @PersistenceContext
    private EntityManager manager;

    public Class<RegionWidget> getSourceType() {
        return RegionWidget.class;
    }

    public JpaRegionWidget convert(RegionWidget source) {
        return source instanceof JpaRegionWidget ? (JpaRegionWidget)source : this.createEntity(source);
    }

    private JpaRegionWidget createEntity(RegionWidget source) {
        JpaRegionWidget converted = null;
        if (source != null) {
            TypedQuery query = this.manager.createNamedQuery("RegionWidget.findById", JpaRegionWidget.class);
            query.setParameter("widgetId", source.getId() == null ? null : Long.valueOf(Long.parseLong(source.getId())));
            converted = (JpaRegionWidget)JpaUtil.getSingleResult(query.getResultList());
            if (converted == null) {
                converted = new JpaRegionWidget();
            }
            this.updateProperties(source, converted);
        }
        return converted;
    }

    private void updateProperties(RegionWidget source, JpaRegionWidget converted) {
        converted.setEntityId(source.getId() == null ? null : Long.valueOf(Long.parseLong(source.getId())));
        converted.setLocked(source.isLocked());
        converted.setCollapsed(source.isCollapsed());
        converted.setHideChrome(source.isHideChrome());
        converted.setPreferences(source.getPreferences());
        converted.setRegion(source.getRegion());
        converted.setRenderPosition(source.getRenderPosition());
        converted.setWidgetId(source.getWidgetId());
        converted.setRenderOrder(source.getRenderOrder());
    }
}

