/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.model.conversion;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.apache.rave.model.ModelConverter;
import org.apache.rave.model.RegionWidgetPreference;
import org.apache.rave.persistence.jpa.util.JpaUtil;
import org.apache.rave.portal.model.JpaRegionWidgetPreference;
import org.springframework.stereotype.Component;

@Component
public class JpaRegionWidgetPreferenceConverter
implements ModelConverter<RegionWidgetPreference, JpaRegionWidgetPreference> {
    @PersistenceContext
    private EntityManager manager;

    public Class<RegionWidgetPreference> getSourceType() {
        return RegionWidgetPreference.class;
    }

    public JpaRegionWidgetPreference convert(RegionWidgetPreference source) {
        return source instanceof JpaRegionWidgetPreference ? (JpaRegionWidgetPreference)source : this.createEntity(source);
    }

    private JpaRegionWidgetPreference createEntity(RegionWidgetPreference source) {
        JpaRegionWidgetPreference converted = null;
        if (source != null) {
            TypedQuery query = this.manager.createNamedQuery("JpaRegionWidgetPreference.findByRegionWidgetAndName", JpaRegionWidgetPreference.class);
            query.setParameter("name", (Object)source.getName());
            query.setParameter("widgetId", (Object)Long.parseLong(source.getRegionWidgetId()));
            converted = (JpaRegionWidgetPreference)JpaUtil.getSingleResult(query.getResultList());
            if (converted == null) {
                converted = new JpaRegionWidgetPreference();
            }
            this.updateProperties(source, converted);
        }
        return converted;
    }

    private void updateProperties(RegionWidgetPreference source, JpaRegionWidgetPreference converted) {
        converted.setName(source.getName());
        converted.setRegionWidgetId(source.getRegionWidgetId());
        converted.setValue(source.getValue());
    }
}

