/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.model.conversion;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.rave.model.Authority;
import org.apache.rave.model.ModelConverter;
import org.apache.rave.model.User;
import org.apache.rave.portal.model.JpaUser;
import org.apache.rave.portal.model.impl.AuthorityImpl;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.stereotype.Component;

@Component
public class JpaUserConverter
implements ModelConverter<User, JpaUser> {
    @PersistenceContext
    private EntityManager manager;

    public JpaUser convert(User source) {
        return source instanceof JpaUser ? (JpaUser)source : this.createEntity(source);
    }

    public Class<User> getSourceType() {
        return User.class;
    }

    private JpaUser createEntity(User source) {
        JpaUser converted = null;
        if (source != null) {
            converted = new JpaUser();
            this.updateProperties(source, converted);
        }
        return converted;
    }

    private void updateProperties(User source, JpaUser converted) {
        converted.setEntityId(source.getId() == null ? null : Long.valueOf(Long.parseLong(source.getId())));
        converted.setUsername(source.getUsername());
        converted.setEmail(source.getEmail());
        converted.setDisplayName(source.getDisplayName());
        converted.setAdditionalName(source.getUsername());
        converted.setFamilyName(source.getFamilyName());
        converted.setGivenName(source.getGivenName());
        converted.setHonorificPrefix(source.getHonorificPrefix());
        converted.setHonorificSuffix(source.getHonorificSuffix());
        converted.setPreferredName(source.getPreferredName());
        converted.setAboutMe(source.getAboutMe());
        converted.setStatus(source.getStatus());
        converted.setAddresses(source.getAddresses());
        converted.setOrganizations(source.getOrganizations());
        converted.setProperties(source.getProperties());
        converted.setPassword(source.getPassword());
        converted.setConfirmPassword(source.getConfirmPassword());
        converted.setDefaultPageLayout(source.getDefaultPageLayout());
        converted.setDefaultPageLayoutCode(source.getDefaultPageLayoutCode());
        converted.setEnabled(source.isEnabled());
        converted.setExpired(source.isExpired());
        converted.setLocked(source.isLocked());
        converted.setOpenId(source.getOpenId());
        converted.setForgotPasswordHash(source.getForgotPasswordHash());
        converted.setForgotPasswordTime(source.getForgotPasswordTime());
        this.updateAuthorities(source, converted);
    }

    private void updateAuthorities(User source, JpaUser converted) {
        converted.getAuthorities().clear();
        for (GrantedAuthority grantedAuthority : source.getAuthorities()) {
            converted.addAuthority((Authority)(grantedAuthority instanceof Authority ? (Authority)grantedAuthority : new AuthorityImpl(grantedAuthority)));
        }
    }
}

