/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.model.conversion;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.rave.model.WidgetComment;
import org.apache.rave.portal.model.JpaWidgetComment;
import org.springframework.stereotype.Component;

@Component
public class JpaWidgetCommentConverter {
    @PersistenceContext
    private EntityManager manager;

    public Class<WidgetComment> getSourceType() {
        return WidgetComment.class;
    }

    public JpaWidgetComment convert(WidgetComment source, String widgetId) {
        return source instanceof JpaWidgetComment ? (JpaWidgetComment)source : this.createEntity(source, widgetId);
    }

    private JpaWidgetComment createEntity(WidgetComment source, String widgetId) {
        JpaWidgetComment converted = null;
        if (source != null) {
            JpaWidgetComment jpaWidgetComment = converted = source.getId() == null ? new JpaWidgetComment() : (JpaWidgetComment)this.manager.find(JpaWidgetComment.class, (Object)Long.parseLong(source.getId()));
            if (converted == null) {
                converted = new JpaWidgetComment();
            }
            this.updateProperties(source, converted, widgetId);
        }
        return converted;
    }

    private void updateProperties(WidgetComment source, JpaWidgetComment converted, String widgetId) {
        converted.setEntityId(source.getId() == null ? null : Long.valueOf(Long.parseLong(source.getId())));
        converted.setCreatedDate(source.getCreatedDate());
        converted.setLastModifiedDate(source.getLastModifiedDate());
        converted.setText(source.getText());
        converted.setUserId(source.getUserId());
        converted.setWidgetId(widgetId);
    }
}

