/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.repository.impl;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.apache.rave.exception.NotSupportedException;
import org.apache.rave.model.OAuthTokenInfo;
import org.apache.rave.persistence.jpa.util.JpaUtil;
import org.apache.rave.portal.model.JpaOAuthTokenInfo;
import org.apache.rave.portal.model.conversion.JpaOAuthTokenInfoConverter;
import org.apache.rave.portal.repository.OAuthTokenInfoRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class JpaOAuthTokenInfoRepository
implements OAuthTokenInfoRepository {
    @PersistenceContext
    private EntityManager manager;
    @Autowired
    private JpaOAuthTokenInfoConverter converter;

    public Class<? extends OAuthTokenInfo> getType() {
        return JpaOAuthTokenInfo.class;
    }

    public OAuthTokenInfo get(String id) {
        return (OAuthTokenInfo)this.manager.find(JpaOAuthTokenInfo.class, (Object)Long.parseLong(id));
    }

    public OAuthTokenInfo save(OAuthTokenInfo item) {
        JpaOAuthTokenInfo jpaItem = this.converter.convert(item);
        return JpaUtil.saveOrUpdate(jpaItem.getEntityId(), this.manager, jpaItem);
    }

    public void delete(OAuthTokenInfo item) {
        this.manager.remove((Object)this.converter.convert(item));
    }

    public List<OAuthTokenInfo> getAll() {
        throw new NotSupportedException("This function is not yet implemented for this class.");
    }

    public List<OAuthTokenInfo> getLimitedList(int offset, int limit) {
        throw new NotSupportedException("This function is not yet implemented for this class.");
    }

    public int getCountAll() {
        throw new NotSupportedException("This function is not yet implemented for this class.");
    }

    public OAuthTokenInfo findOAuthTokenInfo(String userId, String appUrl, String moduleId, String tokenName, String serviceName) {
        TypedQuery query = this.manager.createNamedQuery("OAuthTokenInfo.findOAuthTokenInfo", JpaOAuthTokenInfo.class);
        query.setParameter("userIdParam", (Object)userId);
        query.setParameter("appUrlParam", (Object)appUrl);
        query.setParameter("moduleIdParam", (Object)moduleId);
        query.setParameter("tokenNameParam", (Object)tokenName);
        query.setParameter("serviceNameParam", (Object)serviceName);
        return (OAuthTokenInfo)JpaUtil.getSingleResult(query.getResultList());
    }
}

