/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.repository.impl;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.apache.rave.exception.NotSupportedException;
import org.apache.rave.model.PageLayout;
import org.apache.rave.persistence.jpa.util.JpaUtil;
import org.apache.rave.portal.model.JpaPageLayout;
import org.apache.rave.portal.model.conversion.JpaPageLayoutConverter;
import org.apache.rave.portal.repository.PageLayoutRepository;
import org.apache.rave.util.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class JpaPageLayoutRepository
implements PageLayoutRepository {
    @PersistenceContext
    private EntityManager manager;
    @Autowired
    private JpaPageLayoutConverter converter;

    public JpaPageLayout getByPageLayoutCode(String codename) {
        TypedQuery query = this.manager.createNamedQuery("PageLayout.getByLayoutCode", JpaPageLayout.class);
        query.setParameter("code", (Object)codename);
        return (JpaPageLayout)JpaUtil.getSingleResult(query.getResultList());
    }

    public List<PageLayout> getAll() {
        return CollectionUtils.toBaseTypedList((List)this.manager.createNamedQuery("PageLayout.getAll", JpaPageLayout.class).getResultList());
    }

    public List<PageLayout> getLimitedList(int offset, int limit) {
        throw new NotSupportedException("This function is not yet implemented for this class.");
    }

    public int getCountAll() {
        throw new NotSupportedException("This function is not yet implemented for this class.");
    }

    public List<PageLayout> getAllUserSelectable() {
        return CollectionUtils.toBaseTypedList((List)this.manager.createNamedQuery("PageLayout.getAllUserSelectable", JpaPageLayout.class).getResultList());
    }

    public Class<? extends PageLayout> getType() {
        return JpaPageLayout.class;
    }

    public PageLayout get(String id) {
        return (PageLayout)this.manager.find(JpaPageLayout.class, (Object)Long.parseLong(id));
    }

    public PageLayout save(PageLayout item) {
        JpaPageLayout layout = this.converter.convert(item);
        return JpaUtil.saveOrUpdate(layout.getEntityId(), this.manager, layout);
    }

    public void delete(PageLayout item) {
        this.manager.remove((Object)this.converter.convert(item));
    }
}

