/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.repository.impl;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.apache.rave.model.Page;
import org.apache.rave.model.PageInvitationStatus;
import org.apache.rave.model.PageTemplate;
import org.apache.rave.model.PageTemplateRegion;
import org.apache.rave.model.PageTemplateWidget;
import org.apache.rave.model.PageType;
import org.apache.rave.model.PageUser;
import org.apache.rave.model.Region;
import org.apache.rave.model.RegionWidget;
import org.apache.rave.model.User;
import org.apache.rave.persistence.jpa.util.JpaUtil;
import org.apache.rave.portal.model.JpaPage;
import org.apache.rave.portal.model.JpaPageUser;
import org.apache.rave.portal.model.JpaRegion;
import org.apache.rave.portal.model.JpaRegionWidget;
import org.apache.rave.portal.model.conversion.JpaPageConverter;
import org.apache.rave.portal.repository.PageRepository;
import org.apache.rave.util.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class JpaPageRepository
implements PageRepository {
    @PersistenceContext
    private EntityManager manager;
    @Autowired
    private JpaPageConverter pageConverter;

    public Class<? extends Page> getType() {
        return JpaPage.class;
    }

    public Page get(String id) {
        return this.expandProperties((JpaPage)this.manager.find(JpaPage.class, (Object)Long.parseLong(id)));
    }

    public Page save(Page item) {
        JpaPage page = this.pageConverter.convert(item);
        page.serializeData();
        return JpaUtil.saveOrUpdate(page.getEntityId(), this.manager, page);
    }

    public void delete(Page item) {
        JpaPage jpaPage = item instanceof JpaPage ? (JpaPage)item : (JpaPage)this.get(item.getId());
        for (Page p : jpaPage.getSubPages()) {
            this.delete(p);
        }
        this.removePageUsers(jpaPage);
        jpaPage.setParentPage(null);
        this.manager.flush();
        this.manager.remove((Object)jpaPage);
    }

    public List<Page> getAllPagesForUserType(String userId, String pageType) {
        TypedQuery query = this.manager.createNamedQuery("JpaPageUser.getByUserIdAndPageType", JpaPage.class);
        query.setParameter("userId", (Object)userId);
        query.setParameter("pageType", (Object)pageType.toUpperCase());
        return this.expandProperties(CollectionUtils.toBaseTypedList((List)query.getResultList()));
    }

    public List<Page> getPagesForContextType(String contextId, String pageType) {
        TypedQuery query = this.manager.createNamedQuery("JpaPage.getByContextAndPageType", JpaPage.class);
        query.setParameter("contextId", (Object)contextId);
        query.setParameter("pageType", (Object)pageType.toUpperCase());
        return this.expandProperties(CollectionUtils.toBaseTypedList((List)query.getResultList()));
    }

    public int deletePages(String userId, String pageType) {
        List<Page> pages = this.getAllPagesForUserType(userId, pageType);
        int pageCount = pages.size();
        for (Page page : pages) {
            if (page.getOwnerId().equals(userId)) {
                this.delete(page);
                continue;
            }
            PageUser pageUserToRemove = null;
            for (PageUser pageUser : page.getMembers()) {
                if (!pageUser.getUserId().equals(userId)) continue;
                pageUserToRemove = pageUser;
                break;
            }
            if (pageUserToRemove == null) continue;
            page.getMembers().remove(pageUserToRemove);
            this.save(page);
        }
        return pageCount;
    }

    public boolean hasPersonPage(String userId) {
        TypedQuery query = this.manager.createNamedQuery("JpaPage.hasPersonPage", Long.class);
        query.setParameter("userId", (Object)userId);
        query.setParameter("pageType", (Object)PageType.PERSON_PROFILE.toString().toUpperCase());
        return (Long)query.getSingleResult() > 0L;
    }

    public boolean hasPage(String contextId, String pageType) {
        TypedQuery query = this.manager.createNamedQuery("JpaPage.hasContextPage", Long.class);
        query.setParameter("contextId", (Object)contextId);
        query.setParameter("pageType", (Object)pageType);
        return (Long)query.getSingleResult() > 0L;
    }

    public List<PageUser> getPagesForUser(String userId, String pageType) {
        TypedQuery query = this.manager.createNamedQuery("JpaPageUser.getPagesForUser", JpaPageUser.class);
        query.setParameter("userId", (Object)userId);
        query.setParameter("pageType", (Object)pageType.toUpperCase());
        return this.expandPageUserProperties(CollectionUtils.toBaseTypedList((List)query.getResultList()));
    }

    public PageUser getSingleRecord(String userId, String pageId) {
        TypedQuery query = this.manager.createNamedQuery("JpaPageUser.getSingleRecord", JpaPageUser.class);
        query.setParameter("userId", (Object)userId);
        query.setParameter("pageId", pageId == null ? null : Long.valueOf(Long.parseLong(pageId)));
        return this.expandPageUserProperties((JpaPageUser)query.getSingleResult());
    }

    public Page createPageForUser(User user, PageTemplate pt) {
        return this.convert(pt, user);
    }

    public List<Page> getAll() {
        TypedQuery query = this.manager.createNamedQuery("JpaPage.getAll", JpaPage.class);
        return this.expandProperties(CollectionUtils.toBaseTypedList((List)query.getResultList()));
    }

    public List<Page> getLimitedList(int offset, int limit) {
        TypedQuery query = this.manager.createNamedQuery("JpaPage.getAll", JpaPage.class);
        return this.expandProperties(CollectionUtils.toBaseTypedList(JpaUtil.getPagedResultList(query, offset, limit)));
    }

    public int getCountAll() {
        Query query = this.manager.createNamedQuery("JpaPage.getCount");
        Number countResult = (Number)query.getSingleResult();
        return countResult.intValue();
    }

    private void removePageUsers(JpaPage item) {
        for (PageUser user : item.getMembers()) {
            user.setPage(null);
            user.setUserId(null);
            this.manager.flush();
            this.manager.remove((Object)user);
        }
    }

    private JpaPage expandProperties(JpaPage page) {
        if (page != null) {
            page.deserializeData();
        }
        return page;
    }

    private List<Page> expandProperties(List<Page> pages) {
        for (Page page : pages) {
            if (!(page instanceof JpaPage)) continue;
            this.expandProperties((JpaPage)page);
        }
        return pages;
    }

    private JpaPageUser expandPageUserProperties(JpaPageUser pageUser) {
        Page page = pageUser.getPage();
        if (page != null && page instanceof JpaPage) {
            ((JpaPage)page).deserializeData();
        }
        return pageUser;
    }

    private List<PageUser> expandPageUserProperties(List<PageUser> pageUsers) {
        for (PageUser page : pageUsers) {
            if (!(page instanceof JpaPageUser)) continue;
            this.expandPageUserProperties((JpaPageUser)page);
        }
        return pageUsers;
    }

    private Page convert(PageTemplate pt, User user) {
        JpaPage p = new JpaPage();
        p.setName(pt.getName());
        p.setPageType(pt.getPageType());
        p.setOwnerId(user.getId());
        JpaPageUser pageUser = new JpaPageUser(user, (Page)p, pt.getRenderSequence());
        pageUser.setPageStatus(PageInvitationStatus.OWNER);
        pageUser.setEditor(true);
        ArrayList<JpaPageUser> members = new ArrayList<JpaPageUser>();
        members.add(pageUser);
        p.setMembers(members);
        p.setPageLayout(pt.getPageLayout());
        p.setRegions(this.convertRegions(pt.getPageTemplateRegions(), p));
        p = this.save(p);
        p.setSubPages(this.convertPages(pt.getSubPageTemplates(), p));
        p = this.save(p);
        return p;
    }

    private List<Region> convertRegions(List<PageTemplateRegion> pageTemplateRegions, Page page) {
        ArrayList<Region> regions = new ArrayList<Region>();
        for (PageTemplateRegion ptr : pageTemplateRegions) {
            JpaRegion region = new JpaRegion();
            region.setRenderOrder((int)ptr.getRenderSequence());
            region.setPage(page);
            region.setLocked(ptr.isLocked());
            region.setRegionWidgets(this.convertWidgets(ptr.getPageTemplateWidgets(), region));
            regions.add(region);
        }
        return regions;
    }

    private List<RegionWidget> convertWidgets(List<PageTemplateWidget> pageTemplateWidgets, JpaRegion region) {
        ArrayList<RegionWidget> widgets = new ArrayList<RegionWidget>();
        for (PageTemplateWidget ptw : pageTemplateWidgets) {
            JpaRegionWidget regionWidget = new JpaRegionWidget();
            regionWidget.setRegion(region);
            regionWidget.setCollapsed(false);
            regionWidget.setLocked(ptw.isLocked());
            regionWidget.setHideChrome(ptw.isHideChrome());
            regionWidget.setRenderOrder((int)ptw.getRenderSeq());
            regionWidget.setWidgetId(ptw.getWidgetId());
            widgets.add(regionWidget);
        }
        return widgets;
    }

    private List<Page> convertPages(List<PageTemplate> pageTemplates, Page page) {
        ArrayList<Page> pages = new ArrayList<Page>();
        for (PageTemplate pt : pageTemplates) {
            JpaPage lPage = new JpaPage();
            lPage.setName(pt.getName());
            lPage.setPageType(pt.getPageType());
            lPage.setOwnerId(page.getOwnerId());
            lPage.setPageLayout(pt.getPageLayout());
            lPage.setParentPage(page);
            lPage.setRegions(this.convertRegions(pt.getPageTemplateRegions(), lPage));
            JpaPageUser pageUser = new JpaPageUser(lPage.getOwnerId(), (Page)lPage, pt.getRenderSequence());
            pageUser.setPageStatus(PageInvitationStatus.OWNER);
            pageUser.setEditor(true);
            ArrayList<JpaPageUser> members = new ArrayList<JpaPageUser>();
            members.add(pageUser);
            lPage.setMembers(members);
            lPage = this.save(lPage);
            lPage.setSubPages(pt.getSubPageTemplates() == null || pt.getSubPageTemplates().isEmpty() ? null : this.convertPages(pt.getSubPageTemplates(), lPage));
            lPage = this.save(lPage);
            pages.add(lPage);
        }
        return pages;
    }
}

