/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.repository.impl;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.apache.rave.model.PageTemplate;
import org.apache.rave.persistence.jpa.JpaSerializable;
import org.apache.rave.persistence.jpa.util.JpaUtil;
import org.apache.rave.portal.model.JpaPageTemplate;
import org.apache.rave.portal.model.conversion.JpaConverter;
import org.apache.rave.portal.repository.PageTemplateRepository;
import org.apache.rave.util.CollectionUtils;
import org.springframework.stereotype.Repository;

@Repository
public class JpaPageTemplateRepository
implements PageTemplateRepository {
    @PersistenceContext
    private EntityManager manager;

    public List<PageTemplate> getAll() {
        TypedQuery query = this.manager.createNamedQuery("PageTemplate.getAll", JpaPageTemplate.class);
        return CollectionUtils.toBaseTypedList((List)this.expandProperties((JpaSerializable)((Object)query.getResultList())));
    }

    public List<PageTemplate> getLimitedList(int offset, int limit) {
        TypedQuery query = this.manager.createNamedQuery("PageTemplate.getAll", JpaPageTemplate.class);
        return CollectionUtils.toBaseTypedList(this.expandProperties((JpaSerializable)((Object)JpaUtil.getPagedResultList(query, offset, limit))));
    }

    public int getCountAll() {
        return this.getAll().size();
    }

    public List<PageTemplate> getAll(String pageType) {
        TypedQuery query = this.manager.createNamedQuery("PageTemplate.getAllByType", JpaPageTemplate.class);
        query.setParameter("pageType", (Object)pageType.toUpperCase());
        return CollectionUtils.toBaseTypedList((List)this.expandProperties((JpaSerializable)((Object)query.getResultList())));
    }

    public JpaPageTemplate getDefaultPage(String pageType) {
        TypedQuery query = this.manager.createNamedQuery("PageTemplate.getDefaultPage", JpaPageTemplate.class);
        query.setParameter("pageType", (Object)pageType.toUpperCase());
        return (JpaPageTemplate)this.expandProperties((JpaSerializable)query.getSingleResult());
    }

    public Class<? extends PageTemplate> getType() {
        return PageTemplate.class;
    }

    public PageTemplate get(String id) {
        return (PageTemplate)this.expandProperties((JpaSerializable)this.manager.find(JpaPageTemplate.class, (Object)id));
    }

    public PageTemplate save(PageTemplate template) {
        JpaPageTemplate converted = (JpaPageTemplate)JpaConverter.getInstance().convert(template, PageTemplate.class);
        converted.serializeData();
        return (PageTemplate)this.expandProperties((JpaSerializable)JpaUtil.saveOrUpdate(template.getId(), this.manager, converted));
    }

    public void delete(PageTemplate item) {
        this.manager.remove(JpaConverter.getInstance().convert(item, PageTemplate.class));
    }

    private List<JpaPageTemplate> expandProperties(List<JpaPageTemplate> resultList) {
        for (JpaPageTemplate serializable : resultList) {
            this.expandProperties(serializable);
        }
        return resultList;
    }

    private <T extends JpaSerializable> T expandProperties(T jpaPageTemplate) {
        jpaPageTemplate.deserializeData();
        return jpaPageTemplate;
    }
}

