/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.repository.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.commons.lang3.StringUtils;
import org.apache.rave.model.Tag;
import org.apache.rave.model.User;
import org.apache.rave.model.Widget;
import org.apache.rave.model.WidgetComment;
import org.apache.rave.model.WidgetRating;
import org.apache.rave.model.WidgetStatus;
import org.apache.rave.model.WidgetTag;
import org.apache.rave.persistence.jpa.util.JpaUtil;
import org.apache.rave.portal.model.JpaWidget;
import org.apache.rave.portal.model.JpaWidgetComment;
import org.apache.rave.portal.model.JpaWidgetRating;
import org.apache.rave.portal.model.JpaWidgetTag;
import org.apache.rave.portal.model.conversion.JpaWidgetCommentConverter;
import org.apache.rave.portal.model.conversion.JpaWidgetConverter;
import org.apache.rave.portal.model.conversion.JpaWidgetRatingConverter;
import org.apache.rave.portal.model.conversion.JpaWidgetTagConverter;
import org.apache.rave.portal.model.util.WidgetStatistics;
import org.apache.rave.portal.repository.TagRepository;
import org.apache.rave.portal.repository.WidgetRepository;
import org.apache.rave.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class JpaWidgetRepository
implements WidgetRepository {
    private final Logger log = LoggerFactory.getLogger(JpaWidgetRepository.class);
    @Autowired
    private JpaWidgetConverter converter;
    @Autowired
    private JpaWidgetTagConverter tagConverter;
    @Autowired
    private JpaWidgetCommentConverter commentConverter;
    @Autowired
    JpaWidgetRatingConverter ratingConverter;
    @Autowired
    private TagRepository tagRepository;
    @PersistenceContext
    private EntityManager manager;

    public List<Widget> getAll() {
        this.log.warn("Requesting potentially large resultset of Widget. No pagesize set.");
        TypedQuery query = this.manager.createNamedQuery("Widget.getAll", JpaWidget.class);
        return this.expandProperties(query.getResultList());
    }

    public List<Widget> getLimitedList(int offset, int pageSize) {
        TypedQuery query = this.manager.createNamedQuery("Widget.getAll", JpaWidget.class);
        return this.expandProperties(JpaUtil.getPagedResultList(query, offset, pageSize));
    }

    public int getCountAll() {
        Query query = this.manager.createNamedQuery("Widget.countAll");
        Number countResult = (Number)query.getSingleResult();
        return countResult.intValue();
    }

    public List<Widget> getByFreeTextSearch(String searchTerm, int offset, int pageSize) {
        TypedQuery query = this.manager.createNamedQuery("Widget.getByFreeText", JpaWidget.class);
        this.setFreeTextSearchTerm((Query)query, searchTerm);
        return this.expandProperties(JpaUtil.getPagedResultList(query, offset, pageSize));
    }

    public int getCountFreeTextSearch(String searchTerm) {
        Query query = this.manager.createNamedQuery("Widget.countByFreeText");
        this.setFreeTextSearchTerm(query, searchTerm);
        Number countResult = (Number)query.getSingleResult();
        return countResult.intValue();
    }

    public List<Widget> getByStatus(WidgetStatus widgetStatus, int offset, int pageSize) {
        TypedQuery query = this.manager.createNamedQuery("Widget.getByStatus", JpaWidget.class);
        query.setParameter("widgetStatus", (Object)widgetStatus);
        return this.expandProperties(JpaUtil.getPagedResultList(query, offset, pageSize));
    }

    public int getCountByStatus(WidgetStatus widgetStatus) {
        Query query = this.manager.createNamedQuery("Widget.countByStatus");
        query.setParameter("widgetStatus", (Object)widgetStatus);
        Number countResult = (Number)query.getSingleResult();
        return countResult.intValue();
    }

    public List<Widget> getByStatusAndTypeAndFreeTextSearch(WidgetStatus widgetStatus, String type, String searchTerm, int offset, int pageSize) {
        CriteriaBuilder cb = this.manager.getCriteriaBuilder();
        CriteriaQuery query = cb.createQuery(JpaWidget.class);
        Root widgetType = query.from(JpaWidget.class);
        query.where(this.getStatusAndTypeAndFreeTextPredicates(cb, (Root<JpaWidget>)widgetType, widgetStatus, type, searchTerm));
        query.orderBy(new Order[]{this.getOrderByTitleAsc(cb, (Root<JpaWidget>)widgetType)});
        return this.expandProperties(JpaUtil.getPagedResultList(this.manager.createQuery(query), offset, pageSize));
    }

    public int getCountByStatusAndTypeAndFreeText(WidgetStatus widgetStatus, String type, String searchTerm) {
        CriteriaBuilder cb = this.manager.getCriteriaBuilder();
        CriteriaQuery query = cb.createQuery(Long.class);
        Root widgetType = query.from(JpaWidget.class);
        query.select((Selection)cb.count((Expression)widgetType));
        query.where(this.getStatusAndTypeAndFreeTextPredicates(cb, (Root<JpaWidget>)widgetType, widgetStatus, type, searchTerm));
        Long countResult = (Long)this.manager.createQuery(query).getSingleResult();
        return countResult.intValue();
    }

    public List<Widget> getByOwner(User owner, int offset, int pageSize) {
        TypedQuery query = this.manager.createNamedQuery("Widget.getByOwner", JpaWidget.class);
        query.setParameter("owner", (Object)owner.getId());
        return this.expandProperties(JpaUtil.getPagedResultList(query, offset, pageSize));
    }

    public int getCountByOwner(User owner, int offset, int pageSize) {
        Query query = this.manager.createNamedQuery("Widget.countByOwner");
        query.setParameter("owner", (Object)owner.getId());
        Number countResult = (Number)query.getSingleResult();
        return countResult.intValue();
    }

    public JpaWidget getByUrl(String widgetUrl) {
        if (StringUtils.isBlank((CharSequence)widgetUrl)) {
            throw new IllegalArgumentException("Widget URL must not be empty");
        }
        TypedQuery query = this.manager.createNamedQuery("Widget.getByUrl", JpaWidget.class);
        query.setParameter("url", (Object)widgetUrl);
        List resultList = query.getResultList();
        return this.expandProperties((JpaWidget)JpaUtil.getSingleResult(resultList));
    }

    public WidgetStatistics getWidgetStatistics(String widget_id, String user_id) {
        WidgetStatistics widgetStatistics = new WidgetStatistics();
        Query query = this.manager.createNamedQuery("widget_total_likes");
        query.setParameter("widgetId", (Object)Long.parseLong(widget_id));
        widgetStatistics.setTotalLike(((Number)query.getSingleResult()).intValue());
        query = this.manager.createNamedQuery("widget_total_dislikes");
        query.setParameter("widgetId", (Object)Long.parseLong(widget_id));
        widgetStatistics.setTotalDislike(((Number)query.getSingleResult()).intValue());
        query = this.manager.createNamedQuery("JpaRegionWidget.getDistinctUserCount");
        query.setParameter("widgetId", (Object)Long.parseLong(widget_id));
        widgetStatistics.setTotalUserCount(((Number)query.getSingleResult()).intValue());
        try {
            query = this.manager.createNamedQuery("widget_user_rating");
            query.setParameter("widgetId", (Object)Long.parseLong(widget_id));
            query.setParameter("userId", (Object)Long.parseLong(user_id));
            widgetStatistics.setUserRating(((Number)query.getSingleResult()).intValue());
        }
        catch (NoResultException e) {
            widgetStatistics.setUserRating(JpaWidgetRating.UNSET.intValue());
        }
        return widgetStatistics;
    }

    public Map<String, WidgetRating> getUsersWidgetRatings(String user_id) {
        TypedQuery query = this.manager.createNamedQuery("widget_all_user_ratings", JpaWidgetRating.class);
        query.setParameter("userId", user_id == null ? null : Long.valueOf(Long.parseLong(user_id)));
        HashMap<String, WidgetRating> map = new HashMap<String, WidgetRating>();
        for (JpaWidgetRating widgetRating : query.getResultList()) {
            map.put(widgetRating.getWidgetId(), widgetRating);
        }
        return map;
    }

    public Map<String, WidgetStatistics> getAllWidgetStatistics(String userId) {
        WidgetStatistics widgetStatistics;
        Long widgetId;
        HashMap<String, WidgetStatistics> map = new HashMap<String, WidgetStatistics>();
        Query query = this.manager.createNamedQuery("widget_all_total_likes");
        for (Object[] result : query.getResultList()) {
            Long totalLikes = (Long)result[0];
            widgetId = (Long)result[1];
            widgetStatistics = new WidgetStatistics();
            widgetStatistics.setTotalLike(totalLikes.intValue());
            map.put(widgetId.toString(), widgetStatistics);
        }
        query = this.manager.createNamedQuery("widget_all_total_dislikes");
        for (Object[] result : query.getResultList()) {
            Long totalDislikes = (Long)result[0];
            widgetId = (Long)result[1];
            widgetStatistics = (WidgetStatistics)map.get(widgetId.toString());
            if (widgetStatistics == null) {
                widgetStatistics = new WidgetStatistics();
                map.put(widgetId.toString(), widgetStatistics);
            }
            widgetStatistics.setTotalDislike(totalDislikes.intValue());
        }
        query = this.manager.createNamedQuery("JpaRegionWidget.getDistinctUserCountForAllWidgets");
        for (Object[] result : query.getResultList()) {
            Long widgetId2 = (Long)result[0];
            Long totalUserCount = (Long)result[1];
            widgetStatistics = map.get(widgetId2.toString());
            if (widgetStatistics == null) {
                widgetStatistics = new WidgetStatistics();
                map.put(widgetId2.toString(), widgetStatistics);
            }
            widgetStatistics.setTotalUserCount(totalUserCount.intValue());
        }
        Map<String, WidgetRating> userRatings = this.getUsersWidgetRatings(userId);
        for (Map.Entry entry : map.entrySet()) {
            if (userRatings.containsKey(entry.getKey())) {
                ((WidgetStatistics)entry.getValue()).setUserRating(userRatings.get(entry.getKey()).getScore().intValue());
                continue;
            }
            ((WidgetStatistics)entry.getValue()).setUserRating(JpaWidgetRating.UNSET.intValue());
        }
        return map;
    }

    public List<Widget> getWidgetsByTag(String tagKeyword, int offset, int pageSize) {
        if (tagKeyword != null) {
            tagKeyword = tagKeyword.toLowerCase();
        }
        Tag tag = this.tagRepository.getByKeyword(tagKeyword);
        TypedQuery query = this.manager.createNamedQuery("Widget.getByTag", JpaWidget.class);
        query.setParameter("tagId", tag == null ? null : Long.valueOf(Long.parseLong(tag.getId())));
        return this.expandProperties(JpaUtil.getPagedResultList(query, offset, pageSize));
    }

    public int getCountByTag(String tagKeyword) {
        if (tagKeyword != null) {
            tagKeyword = tagKeyword.toLowerCase();
        }
        Tag tag = this.tagRepository.getByKeyword(tagKeyword);
        Query query = this.manager.createNamedQuery("Widget.countByTag");
        query.setParameter("tagId", tag == null ? null : Long.valueOf(Long.parseLong(tag.getId())));
        Number countResult = (Number)query.getSingleResult();
        return countResult.intValue();
    }

    public int unassignWidgetOwner(String userId) {
        Query query = this.manager.createNamedQuery("Widget.unassignOwner");
        query.setParameter("owner", (Object)userId);
        return query.executeUpdate();
    }

    public Class<? extends Widget> getType() {
        return JpaWidget.class;
    }

    public Widget get(String id) {
        return this.expandProperties((JpaWidget)this.manager.find(JpaWidget.class, (Object)Long.parseLong(id)));
    }

    public Widget save(Widget item) {
        JpaWidget converted = this.converter.convert(item);
        converted.serializeData();
        return this.expandProperties(JpaUtil.saveOrUpdate(item.getId(), this.manager, converted));
    }

    public void delete(Widget item) {
        this.manager.remove((Object)this.converter.convert(item));
    }

    protected void setFreeTextSearchTerm(Query query, String searchTerm) {
        query.setParameter("searchTerm", (Object)this.getLowercaseWildcardSearchTerm(searchTerm));
    }

    private Predicate[] getStatusAndTypeAndFreeTextPredicates(CriteriaBuilder cb, Root<JpaWidget> widgetType, WidgetStatus widgetStatus, String type, String searchTerm) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (StringUtils.isNotBlank((CharSequence)searchTerm)) {
            predicates.add(cb.or((Expression)cb.like(cb.lower(this.getTitleField(widgetType)), this.getLowercaseWildcardSearchTerm(searchTerm)), (Expression)cb.like(cb.lower(this.getDescriptionField(widgetType)), this.getLowercaseWildcardSearchTerm(searchTerm))));
        }
        if (StringUtils.isNotBlank((CharSequence)type)) {
            predicates.add(cb.and(new Predicate[]{cb.equal(this.getTypeField(widgetType), (Object)type)}));
        }
        if (widgetStatus != null) {
            predicates.add(cb.and(new Predicate[]{cb.equal(this.getWidgetStatusField(widgetType), (Object)widgetStatus)}));
        }
        return predicates.toArray(new Predicate[predicates.size()]);
    }

    private Order getOrderByTitleAsc(CriteriaBuilder cb, Root<JpaWidget> widgetType) {
        return cb.asc(this.getTitleField(widgetType));
    }

    private Path<String> getTitleField(Root<JpaWidget> widgetType) {
        return widgetType.get("title");
    }

    private Path<String> getDescriptionField(Root<JpaWidget> widgetType) {
        return widgetType.get("description");
    }

    private Path<String> getTypeField(Root<JpaWidget> widgetType) {
        return widgetType.get("type");
    }

    private Path<WidgetStatus> getWidgetStatusField(Root<JpaWidget> widgetType) {
        return widgetType.get("widgetStatus");
    }

    private String getLowercaseWildcardSearchTerm(String searchTerm) {
        if (StringUtils.isBlank((CharSequence)searchTerm)) {
            return searchTerm;
        }
        return "%" + searchTerm.toLowerCase() + "%";
    }

    public WidgetTag getTagByWidgetIdAndKeyword(String widgetId, String keyword) {
        if (keyword != null) {
            keyword = keyword.trim();
        }
        Tag tag = this.tagRepository.getByKeyword(keyword);
        TypedQuery query = this.manager.createNamedQuery("findByWidgetIDAndTagID", JpaWidgetTag.class);
        query.setParameter("tagId", tag == null ? null : Long.valueOf(Long.parseLong(tag.getId())));
        query.setParameter("widgetId", widgetId == null ? null : Long.valueOf(Long.parseLong(widgetId)));
        return (WidgetTag)JpaUtil.getSingleResult(query.getResultList());
    }

    public WidgetTag getTagById(String widgetTagId) {
        return (WidgetTag)this.manager.find(JpaWidgetTag.class, (Object)Long.parseLong(widgetTagId));
    }

    public WidgetTag saveWidgetTag(String widgetId, WidgetTag tag) {
        JpaWidgetTag jpaWidgetTag = this.tagConverter.convert(tag, widgetId);
        return JpaUtil.saveOrUpdate(jpaWidgetTag.getId(), this.manager, jpaWidgetTag);
    }

    public void deleteWidgetTag(WidgetTag tag) {
        this.manager.remove(tag instanceof JpaWidgetTag ? tag : this.manager.find(Tag.class, (Object)Long.parseLong(tag.getTagId())));
    }

    public WidgetComment getCommentById(String widgetId, String widgetCommentId) {
        return (WidgetComment)this.manager.find(JpaWidgetComment.class, (Object)Long.parseLong(widgetCommentId));
    }

    public WidgetComment createWidgetComment(String widgetId, WidgetComment comment) {
        JpaWidgetComment category = this.commentConverter.convert(comment, widgetId);
        return JpaUtil.saveOrUpdate(category.getEntityId(), this.manager, category);
    }

    public WidgetComment updateWidgetComment(String widgetId, WidgetComment comment) {
        JpaWidgetComment category = this.commentConverter.convert(comment, widgetId);
        return JpaUtil.saveOrUpdate(category.getEntityId(), this.manager, category);
    }

    public void deleteWidgetComment(String widgetId, WidgetComment comment) {
        this.manager.remove((Object)(comment instanceof JpaWidgetComment ? comment : this.getCommentById(widgetId, comment.getId())));
    }

    public int deleteAllWidgetComments(String userId) {
        TypedQuery query = this.manager.createNamedQuery("WidgetComment.deleteAllByUserId", JpaWidgetComment.class);
        query.setParameter("userId", (Object)userId);
        return query.executeUpdate();
    }

    public WidgetRating getRatingById(String widgetId, String widgetRatingId) {
        return (WidgetRating)this.manager.find(JpaWidgetRating.class, (Object)Long.parseLong(widgetRatingId));
    }

    public WidgetRating createWidgetRating(String widgetId, WidgetRating rating) {
        JpaWidgetRating jpaItem = this.ratingConverter.convert(rating, widgetId);
        return JpaUtil.saveOrUpdate(jpaItem.getEntityId(), this.manager, jpaItem);
    }

    public WidgetRating updateWidgetRating(String widgetId, WidgetRating rating) {
        JpaWidgetRating jpaItem = this.ratingConverter.convert(rating, widgetId);
        return JpaUtil.saveOrUpdate(jpaItem.getEntityId(), this.manager, jpaItem);
    }

    public void deleteWidgetRating(String widgetId, WidgetRating rating) {
        this.manager.remove((Object)this.ratingConverter.convert(rating, widgetId));
    }

    public WidgetRating getWidgetRatingsByWidgetIdAndUserId(String widgetId, String userId) {
        TypedQuery query = this.manager.createNamedQuery("widget_rating_by_widget_and_user", JpaWidgetRating.class);
        query.setParameter("widgetId", (Object)Long.parseLong(widgetId));
        query.setParameter("userId", (Object)Long.parseLong(userId));
        List resultList = query.getResultList();
        return (WidgetRating)JpaUtil.getSingleResult(resultList);
    }

    public int deleteAllWidgetRatings(String userId) {
        TypedQuery query = this.manager.createNamedQuery("delete_all_for_user", JpaWidgetRating.class);
        query.setParameter("userId", userId == null ? null : Long.valueOf(Long.parseLong(userId)));
        return query.executeUpdate();
    }

    private List<Widget> expandProperties(List<JpaWidget> widgets) {
        for (JpaWidget widget : widgets) {
            this.expandProperties(widget);
        }
        return CollectionUtils.toBaseTypedList(widgets);
    }

    private JpaWidget expandProperties(JpaWidget widget) {
        if (widget != null) {
            widget.deserializeData();
        }
        return widget;
    }
}

