/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.provider.opensocial.controller;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.rave.exception.ResourceNotFoundException;
import org.apache.rave.provider.opensocial.service.OpenSocialService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/rest/opensocial"})
public class SecurityTokenController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private OpenSocialService openSocialService;

    @RequestMapping(value={"/gadget"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Map<String, Object> getUnboundTokenAndMetadata(@RequestParam(value="url") String url, @RequestParam(value="pageid") String pageId) {
        HashMap<String, Object> jsonResponse = new HashMap<String, Object>();
        jsonResponse.put("securityToken", this.openSocialService.getEncryptedSecurityToken(pageId, url));
        jsonResponse.put("metadata", this.openSocialService.getGadgetMetadata(url));
        return jsonResponse;
    }

    @ExceptionHandler(value={ResourceNotFoundException.class})
    @ResponseBody
    public Map<String, String> handleNotFound(Exception ex, HttpServletRequest request, HttpServletResponse response) {
        return this.setResponse(ex, request, response, HttpStatus.NOT_FOUND);
    }

    @ExceptionHandler(value={IllegalStateException.class})
    @ResponseBody
    public Map<String, String> handleIllegalState(Exception ex, HttpServletRequest request, HttpServletResponse response) {
        return this.setResponse(ex, request, response, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public Map<String, String> handleALl(Exception ex, HttpServletRequest request, HttpServletResponse response) {
        return this.setResponse(ex, request, response, HttpStatus.INTERNAL_SERVER_ERROR);
    }

    private Map<String, String> setResponse(Exception ex, HttpServletRequest request, HttpServletResponse response, HttpStatus status) {
        this.logger.error("Not Found Exception: " + request.getUserPrincipal().getName() + " attempted to access resource " + request.getRequestURI(), (Throwable)ex);
        response.setStatus(status.value());
        HashMap errors = Maps.newHashMap();
        errors.put("error", ex.getMessage());
        return errors;
    }
}

