/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.provider.opensocial.service.impl;

import org.apache.rave.model.Widget;
import org.apache.rave.portal.model.impl.WidgetImpl;
import org.apache.rave.portal.service.WidgetMetadataResolver;
import org.apache.rave.provider.opensocial.repository.GadgetMetadataRepository;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OpenSocialWidgetMetadataResolver
implements WidgetMetadataResolver {
    private static Logger logger = LoggerFactory.getLogger(OpenSocialWidgetMetadataResolver.class);
    private GadgetMetadataRepository gadgetMetadataRepository;

    @Autowired
    public OpenSocialWidgetMetadataResolver(GadgetMetadataRepository gadgetMetadataRepository) {
        this.gadgetMetadataRepository = gadgetMetadataRepository;
    }

    public String getSupportedContext() {
        return "OpenSocial";
    }

    public Widget getMetadata(String url) {
        WidgetImpl widget = new WidgetImpl();
        JSONObject jsonGadget = null;
        try {
            JSONObject jsonModulePrefsObject;
            String query;
            jsonGadget = (JSONObject)new JSONTokener(this.gadgetMetadataRepository.getGadgetMetadata(url)).nextValue();
            if (jsonGadget != null && (query = jsonGadget.getString("modulePrefs")) != null && (jsonModulePrefsObject = (JSONObject)new JSONTokener(query).nextValue()) != null) {
                widget.setTitle(this.parseProperty(jsonModulePrefsObject, "title"));
                widget.setTitleUrl(this.parseProperty(jsonModulePrefsObject, "titleUrl"));
                widget.setDescription(this.parseProperty(jsonModulePrefsObject, "description"));
                widget.setAuthor(this.parseProperty(jsonModulePrefsObject, "author"));
                widget.setAuthorEmail(this.parseProperty(jsonModulePrefsObject, "authorEmail"));
                widget.setThumbnailUrl(this.parseProperty(jsonModulePrefsObject, "thumbnail"));
                widget.setScreenshotUrl(this.parseProperty(jsonModulePrefsObject, "screenshot"));
                widget.setUrl(url);
                widget.setType(this.getSupportedContext());
            }
        }
        catch (JSONException e) {
            try {
                JSONObject jsonModuleErrorObject;
                String query = jsonGadget.getString("error");
                if (query != null && (jsonModuleErrorObject = (JSONObject)new JSONTokener(query).nextValue()) != null) {
                    String errorMessage = jsonModuleErrorObject.getString("message");
                    String errorCode = jsonModuleErrorObject.getString("code");
                    throw new IllegalArgumentException("HTTP error: " + errorCode + ". Message: " + errorMessage);
                }
            }
            catch (JSONException e1) {
                logger.info("Error while reading: " + e.getLocalizedMessage(), (Throwable)e);
                throw new IllegalArgumentException("Error occurred while processing response for Widget metadata call", e1);
            }
            throw new IllegalArgumentException("Error occurred while processing response for Widget metadata call", e);
        }
        return widget;
    }

    private String parseProperty(JSONObject prefsObject, String name) {
        try {
            return prefsObject.getString(name);
        }
        catch (JSONException e) {
            logger.error("Error while reading: " + e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    public Widget[] getMetadataGroup(String groupUrl) {
        return null;
    }

    public Widget publishRemote(String url) {
        return null;
    }
}

