/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.provider.opensocial.web.renderer;

import org.apache.rave.exception.NotSupportedException;
import org.apache.rave.model.Page;
import org.apache.rave.model.RegionWidget;
import org.apache.rave.model.RegionWidgetPreference;
import org.apache.rave.model.Widget;
import org.apache.rave.portal.web.renderer.RegionWidgetWrapperRenderer;
import org.apache.rave.portal.web.renderer.RenderScope;
import org.apache.rave.portal.web.renderer.ScriptLocation;
import org.apache.rave.portal.web.renderer.ScriptManager;
import org.apache.rave.portal.web.renderer.model.RegionWidgetWrapper;
import org.apache.rave.portal.web.renderer.model.RenderContext;
import org.apache.rave.provider.opensocial.service.OpenSocialService;
import org.apache.rave.provider.opensocial.service.SecurityTokenService;
import org.apache.rave.util.JsonUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OpenSocialWidgetWrapperRenderer
implements RegionWidgetWrapperRenderer {
    private static Logger logger = LoggerFactory.getLogger(OpenSocialWidgetWrapperRenderer.class);
    public static final String REGISTER_WIDGET_KEY = "openSocialRegisterWidget";
    private OpenSocialService openSocialService;
    private SecurityTokenService securityTokenService;
    private ScriptManager scriptManager;
    private static final String SCRIPT_BLOCK = "<script>require(['rave'], function(rave){rave.registerWidget('%1$s', {type: '%2$s', regionWidgetId: '%3$s', widgetUrl: '%4$s',  securityToken: '%5$s',  metadata: %6$s, userPrefs: %7$s, collapsed: %8$s,  widgetId: '%9$s', locked: %10$s, hideChrome: %11$s, subPage: {id: %12$s, name: '%13$s', isDefault: %14$s}, properties: %15$s, regionProperties: %16$s, regionWidgetProperties: %17$s})});</script>";
    private static final String MARKUP = "<!-- RegionWidget '%1$s' placeholder -->";

    @Autowired
    public OpenSocialWidgetWrapperRenderer(OpenSocialService openSocialService, SecurityTokenService securityTokenService, ScriptManager scriptManager) {
        this.openSocialService = openSocialService;
        this.securityTokenService = securityTokenService;
        this.scriptManager = scriptManager;
    }

    public String getSupportedContext() {
        return "OpenSocial";
    }

    public String render(RegionWidgetWrapper item, RenderContext context) {
        Widget widget = item.getWidget();
        String type = widget.getType();
        if (!"OpenSocial".equals(type)) {
            throw new NotSupportedException("Invalid widget type passed to renderer: " + type);
        }
        RegionWidget regionWidget = item.getRegionWidget();
        String widgetScript = this.getWidgetScript(regionWidget, widget);
        String key = REGISTER_WIDGET_KEY + (regionWidget.getId() == null ? "" : "-" + regionWidget.getId());
        this.scriptManager.registerScriptBlock(key, widgetScript, ScriptLocation.AFTER_RAVE, RenderScope.CURRENT_REQUEST, context);
        logger.debug("Gadget Script Data from OpenSocialWidgetWrapperRenderer: " + widgetScript);
        return String.format(MARKUP, regionWidget.getId());
    }

    public RegionWidgetWrapper prepareForRender(RegionWidgetWrapper item) {
        throw new UnsupportedOperationException();
    }

    private String getWidgetScript(RegionWidget item, Widget widget) {
        JSONObject userPrefs = new JSONObject();
        if (item.getPreferences() != null) {
            for (RegionWidgetPreference regionWidgetPreference : item.getPreferences()) {
                try {
                    userPrefs.put(regionWidgetPreference.getName(), (Object)regionWidgetPreference.getValue());
                }
                catch (JSONException e) {
                    logger.error("Exception caught adding preference to JSONObject: " + regionWidgetPreference, (Throwable)e);
                }
            }
        }
        String pageId = null;
        String pageName = "";
        boolean isDefault = false;
        Page page = item.getRegion().getPage();
        if (page.getParentPage() != null) {
            pageId = "'" + page.getId() + "'";
            pageName = page.getName();
            isDefault = this.isDefaultSubPage(page);
        }
        return String.format(SCRIPT_BLOCK, item.getRegion().getId(), "OpenSocial", item.getId(), widget.getUrl(), this.securityTokenService.getEncryptedSecurityToken(item, widget), this.openSocialService.getGadgetMetadata(widget.getUrl()), userPrefs.toString(), item.isCollapsed(), widget.getId(), item.isLocked(), item.isHideChrome(), pageId, pageName, isDefault, JsonUtils.stringify((Object)widget.getProperties()), JsonUtils.stringify((Object)item.getRegion().getProperties()), JsonUtils.stringify((Object)item.getProperties()));
    }

    private boolean isDefaultSubPage(Page subPage) {
        return ((Page)subPage.getParentPage().getSubPages().get(0)).getId().equals(subPage.getId());
    }
}

