/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.commoncontainer;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.CreationException;
import com.google.inject.name.Names;
import com.google.inject.spi.Message;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class ConfigurablePropertiesModule
extends AbstractModule {
    private static final String DEFAULT_PROPERTIES = "rave.shindig.properties";
    private static final String SHINDIG_OVERRIDE_PROPERTIES = "rave-shindig.override.properties";
    private static final String CLASSPATH = "classpath:";
    private final Properties properties = this.initProperties();

    protected void configure() {
        this.bindPropertiesAsConstants();
        this.bindNonConstantProperties();
    }

    private void bindPropertiesAsConstants() {
        for (String propertyName : ConfigurablePropertiesModule.constantGuiceProperties()) {
            this.binder().bindConstant().annotatedWith((Annotation)Names.named((String)propertyName)).to(this.getProperties().getProperty(propertyName));
        }
    }

    private void bindNonConstantProperties() {
        Properties p = this.getProperties();
        for (String overridableProperty : ConfigurablePropertiesModule.constantGuiceProperties()) {
            p.remove(overridableProperty);
        }
        Names.bindProperties((Binder)this.binder(), (Properties)p);
    }

    protected Properties initProperties() {
        Resource propertyResource = this.getPropertyResource();
        try {
            Properties initProperties = this.loadPropertiesFromPropertyResource(propertyResource);
            ConfigurablePropertiesModule.overridePropertyValuesWithSystemProperties(initProperties, ConfigurablePropertiesModule.overridableProperties());
            ConfigurablePropertiesModule.replacePlaceholderWithValue(initProperties, "%contextRoot%", this.getContextRootValue(initProperties));
            return initProperties;
        }
        catch (IOException e) {
            throw new CreationException(Arrays.asList(new Message("Unable to load properties from resource. " + e.getMessage())));
        }
    }

    private Properties loadPropertiesFromPropertyResource(Resource propertyResource) throws IOException {
        Properties properties = new Properties();
        properties.load(propertyResource.getInputStream());
        return properties;
    }

    private Resource getPropertyResource() {
        String overrideProperty = System.getProperty(SHINDIG_OVERRIDE_PROPERTIES);
        if (StringUtils.isBlank((CharSequence)overrideProperty)) {
            return new ClassPathResource(DEFAULT_PROPERTIES);
        }
        if (overrideProperty.startsWith(CLASSPATH)) {
            return new ClassPathResource(overrideProperty.trim().substring(CLASSPATH.length()));
        }
        return new FileSystemResource(overrideProperty.trim());
    }

    static void overridePropertyValuesWithSystemProperties(Properties properties, List<String> overridablePropertyNames) {
        for (String propertyName : overridablePropertyNames) {
            properties.setProperty(propertyName, ConfigurablePropertiesModule.getOverridablePropertyValue(propertyName, properties));
        }
    }

    static void replacePlaceholderWithValue(Properties properties, String placeholder, String value) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String propertyValue = (String)entry.getValue();
            if (propertyValue == null || !propertyValue.contains(placeholder)) continue;
            properties.put(entry.getKey(), propertyValue.replace(placeholder, value));
        }
    }

    static String getOverridablePropertyValue(String propertyKey, Properties properties) {
        if (System.getProperty(propertyKey) != null) {
            return System.getProperty(propertyKey);
        }
        if (properties.get(propertyKey) != null) {
            return properties.getProperty(propertyKey);
        }
        return "";
    }

    private String getContextRootValue(Properties properties) {
        return properties.getProperty("shindig.contextroot");
    }

    protected Properties getProperties() {
        return this.properties;
    }

    private static List<String> overridableProperties() {
        ArrayList<String> propertyNames = new ArrayList<String>();
        propertyNames.add("shindig.host");
        propertyNames.add("shindig.port");
        propertyNames.add("shindig.contextroot");
        return propertyNames;
    }

    private static List<String> constantGuiceProperties() {
        ArrayList<String> propertyNames = new ArrayList<String>();
        propertyNames.add("shindig.host");
        propertyNames.add("shindig.port");
        propertyNames.add("shindig.contextroot");
        return propertyNames;
    }
}

