/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.inject;

import com.google.inject.Provider;
import java.util.Map;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;

public class SpringContextProvider<T>
implements Provider<T> {
    private final Class<T> clazz;
    private final ApplicationContext context;

    public SpringContextProvider(Class<T> clazz, ApplicationContext context) {
        this.clazz = clazz;
        this.context = context;
    }

    public T get() {
        Map beans = this.context.getBeansOfType(this.clazz);
        return beans.size() == 1 ? this.getSingleBean(beans) : this.getPrimaryBean(beans);
    }

    private T getPrimaryBean(Map<String, T> beans) {
        AutowireCapableBeanFactory factory = this.context.getAutowireCapableBeanFactory();
        for (Map.Entry<String, T> bean : beans.entrySet()) {
            if (!(factory instanceof ConfigurableListableBeanFactory) || !((ConfigurableListableBeanFactory)factory).getBeanDefinition(bean.getKey()).isPrimary()) continue;
            return bean.getValue();
        }
        throw new NoSuchBeanDefinitionException(this.clazz, "Matching bean count for class: " + beans.size());
    }

    private T getSingleBean(Map<String, T> beans) {
        return beans.entrySet().iterator().next().getValue();
    }
}

