/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.opensocial.service.impl;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Futures;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import org.apache.rave.model.Person;
import org.apache.rave.opensocial.repository.OpenSocialPersonRepository;
import org.apache.rave.opensocial.service.SimplePersonService;
import org.apache.rave.opensocial.service.impl.FieldRestrictingPerson;
import org.apache.rave.util.CollectionUtils;
import org.apache.shindig.auth.AbstractSecurityToken;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.protocol.ProtocolException;
import org.apache.shindig.protocol.RestfulCollection;
import org.apache.shindig.social.opensocial.spi.CollectionOptions;
import org.apache.shindig.social.opensocial.spi.GroupId;
import org.apache.shindig.social.opensocial.spi.PersonService;
import org.apache.shindig.social.opensocial.spi.UserId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DefaultPersonService
implements PersonService,
SimplePersonService {
    private final OpenSocialPersonRepository repository;
    private static Logger log = Logger.getLogger(DefaultPersonService.class.getName());

    @Autowired
    public DefaultPersonService(OpenSocialPersonRepository repository) {
        this.repository = repository;
    }

    public Future<RestfulCollection<org.apache.shindig.social.opensocial.model.Person>> getPeople(Set<UserId> userIds, GroupId groupId, CollectionOptions collectionOptions, Set<String> fields, SecurityToken token) throws ProtocolException {
        collectionOptions = this.manipulateCollectionOptions(collectionOptions, token);
        List<Person> people = this.getPeople(userIds, groupId, collectionOptions, token);
        return Futures.immediateFuture((Object)new RestfulCollection(DefaultPersonService.convertPeople(people, fields)));
    }

    public Future<org.apache.shindig.social.opensocial.model.Person> getPerson(UserId id, Set<String> fields, SecurityToken token) throws ProtocolException {
        return Futures.immediateFuture((Object)DefaultPersonService.convertPerson(this.getPersonForId(id, token), fields));
    }

    public Future<org.apache.shindig.social.opensocial.model.Person> updatePerson(UserId id, org.apache.shindig.social.opensocial.model.Person person, SecurityToken token) throws ProtocolException {
        throw new ProtocolException(501, "Not Implemented");
    }

    @Override
    public List<Person> getPeople(Set<UserId> userIds, GroupId groupId, CollectionOptions collectionOptions, SecurityToken token) {
        switch (groupId.getType()) {
            case all: {
                return this.getUniqueListOfConnectedPeople(userIds, collectionOptions, token);
            }
            case friends: {
                return this.getUniqueListOfFriends(userIds, collectionOptions, token);
            }
            case objectId: {
                return this.getGroupMembersFromRepository(collectionOptions, groupId.getObjectId().toString(), token.getAppId());
            }
            case self: {
                UserId id = userIds.size() == 1 ? userIds.iterator().next() : new UserId(UserId.Type.me, null);
                return Lists.newArrayList((Object[])new Person[]{this.getPersonForId(id, token)});
            }
            case custom: {
                throw new ProtocolException(501, "Custom GroupIDs are not tracked by the container");
            }
        }
        throw new ProtocolException(400, "Invalid group id specified by request");
    }

    private List<Person> getUniqueListOfFriends(Set<UserId> userIds, CollectionOptions collectionOptions, SecurityToken token) {
        ArrayList<Person> people = new ArrayList<Person>();
        for (UserId id : userIds) {
            Person person = this.getPersonForId(id, token);
            CollectionUtils.addUniqueValues(this.getFriendsFromRepository(collectionOptions, token.getAppId(), person.getUsername()), people);
        }
        return people;
    }

    private List<Person> getUniqueListOfConnectedPeople(Set<UserId> userIds, CollectionOptions collectionOptions, SecurityToken token) {
        ArrayList<Person> people = new ArrayList<Person>();
        for (UserId id : userIds) {
            Person person = this.getPersonForId(id, token);
            CollectionUtils.addUniqueValues(this.getConnectedPeopleFromRepository(collectionOptions, token.getAppId(), person.getUsername()), people);
        }
        return people;
    }

    private List<Person> getFriendsFromRepository(CollectionOptions collectionOptions, String appId, String userId) {
        String filter;
        String string = filter = collectionOptions == null ? null : collectionOptions.getFilter();
        List<Object> current = filter == null || filter.equals("all") || filter.equals("topFriends") ? this.repository.findFriends(userId) : (filter.equals("hasApp") ? this.repository.findFriends(userId, appId) : (filter.equals("isFriendsWith") ? this.repository.findFriendsWithFriend(userId, collectionOptions.getFilterValue()) : this.repository.findFriends(userId, filter, collectionOptions.getFilterOperation(), collectionOptions.getFilterValue())));
        return current;
    }

    private List<Person> getConnectedPeopleFromRepository(CollectionOptions collectionOptions, String appId, String userId) {
        String filter;
        String string = filter = collectionOptions == null ? null : collectionOptions.getFilter();
        List<Object> current = filter == null || filter.equals("all") || filter.equals("topFriends") ? this.repository.findAllConnectedPeople(userId) : (filter.equals("hasApp") ? this.repository.findAllConnectedPeople(userId, appId) : (filter.equals("isFriendsWith") ? this.repository.findAllConnectedPeopleWithFriend(userId, collectionOptions.getFilterValue()) : this.repository.findAllConnectedPeople(userId, filter, collectionOptions.getFilterOperation(), collectionOptions.getFilterValue())));
        return current;
    }

    private List<Person> getGroupMembersFromRepository(CollectionOptions collectionOptions, String groupId, String appId) {
        String filter;
        String string = filter = collectionOptions == null ? null : collectionOptions.getFilter();
        List<Object> current = filter == null || filter.equals("all") || filter.equals("topFriends") ? this.repository.findByGroup(groupId) : (filter.equals("hasApp") ? this.repository.findByGroup(groupId, appId) : (filter.equals("isFriendsWith") ? this.repository.findByGroupWithFriend(groupId, collectionOptions.getFilterValue()) : this.repository.findByGroup(groupId, filter, collectionOptions.getFilterOperation(), collectionOptions.getFilterValue())));
        return current;
    }

    private Person getPersonForId(UserId id, SecurityToken token) {
        return this.getFromRepository(id.getUserId(token));
    }

    private Person getFromRepository(String userId) {
        Person person = this.repository.findByUsername(userId);
        if (person == null) {
            throw new ProtocolException(404, "The person with the id " + userId + " was not found.");
        }
        return person;
    }

    private static List<org.apache.shindig.social.opensocial.model.Person> convertPeople(List<Person> people, Set<String> fields) {
        ArrayList<org.apache.shindig.social.opensocial.model.Person> wrappedPeople = new ArrayList<org.apache.shindig.social.opensocial.model.Person>();
        for (Person person : people) {
            wrappedPeople.add(DefaultPersonService.convertPerson(person, fields));
        }
        return wrappedPeople;
    }

    private static org.apache.shindig.social.opensocial.model.Person convertPerson(Person person, Set<String> fields) {
        return new FieldRestrictingPerson(person, fields);
    }

    private CollectionOptions manipulateCollectionOptions(CollectionOptions options, SecurityToken token) {
        if (options != null && options.getFilterValue() != null) {
            if (options.getFilterValue().equalsIgnoreCase(AbstractSecurityToken.Keys.OWNER.name())) {
                options.setFilterValue(token.getOwnerId());
            } else if (options.getFilterValue().equalsIgnoreCase(AbstractSecurityToken.Keys.VIEWER.name())) {
                options.setFilterValue(token.getViewerId());
            }
        }
        return options;
    }
}

