/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.opensocial.service.impl;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.rave.exception.NotSupportedException;
import org.apache.rave.model.Address;
import org.apache.rave.model.Person;
import org.apache.rave.model.PersonProperty;
import org.apache.rave.util.CollectionUtils;
import org.apache.shindig.protocol.model.Enum;
import org.apache.shindig.protocol.model.EnumImpl;
import org.apache.shindig.social.core.model.AccountImpl;
import org.apache.shindig.social.core.model.AddressImpl;
import org.apache.shindig.social.core.model.BodyTypeImpl;
import org.apache.shindig.social.core.model.ListFieldImpl;
import org.apache.shindig.social.core.model.NameImpl;
import org.apache.shindig.social.core.model.OrganizationImpl;
import org.apache.shindig.social.core.model.UrlImpl;
import org.apache.shindig.social.opensocial.model.Account;
import org.apache.shindig.social.opensocial.model.BodyType;
import org.apache.shindig.social.opensocial.model.Drinker;
import org.apache.shindig.social.opensocial.model.ListField;
import org.apache.shindig.social.opensocial.model.LookingFor;
import org.apache.shindig.social.opensocial.model.Name;
import org.apache.shindig.social.opensocial.model.NetworkPresence;
import org.apache.shindig.social.opensocial.model.Organization;
import org.apache.shindig.social.opensocial.model.Person;
import org.apache.shindig.social.opensocial.model.Smoker;
import org.apache.shindig.social.opensocial.model.Url;

public class FieldRestrictingPerson
implements org.apache.shindig.social.opensocial.model.Person,
Serializable {
    private Person internal;
    private Set<String> fields;
    private Map<String, ?> appData;
    private boolean isOwner;
    private boolean isViewer;
    private Map<String, List<PersonProperty>> propertyMap;

    public FieldRestrictingPerson(Person internal, Set<String> fields) {
        this.internal = internal;
        this.fields = fields;
        this.propertyMap = internal != null && internal.getProperties() != null ? FieldRestrictingPerson.createPropertyMap(internal.getProperties()) : new HashMap<String, List<PersonProperty>>();
    }

    public String getDisplayName() {
        return this.internal.getDisplayName();
    }

    public void setDisplayName(String displayName) {
        throw new NotSupportedException();
    }

    public String getAboutMe() {
        return this.displayField(Person.Field.ABOUT_ME) ? this.internal.getAboutMe() : null;
    }

    public void setAboutMe(String aboutMe) {
        throw new NotSupportedException();
    }

    public List<Account> getAccounts() {
        if (this.displayField(Person.Field.ACCOUNTS)) {
            List<PersonProperty> properties = this.getFromProperties(Person.Field.ACCOUNTS);
            return FieldRestrictingPerson.convertAccounts(properties);
        }
        return null;
    }

    public void setAccounts(List<Account> accounts) {
        throw new NotSupportedException();
    }

    public List<String> getActivities() {
        return this.getValuesFromProperties(Person.Field.ACTIVITIES);
    }

    public void setActivities(List<String> activities) {
        throw new NotSupportedException();
    }

    public List<org.apache.shindig.social.opensocial.model.Address> getAddresses() {
        return this.displayField(Person.Field.ADDRESSES) ? this.convertAddresses(this.internal.getAddresses()) : null;
    }

    public void setAddresses(List<org.apache.shindig.social.opensocial.model.Address> addresses) {
        throw new NotSupportedException();
    }

    public Integer getAge() {
        String value = this.getSingleValueFromProperties(Person.Field.AGE);
        return value == null ? null : Integer.valueOf(Integer.parseInt(value));
    }

    public void setAge(Integer age) {
        throw new NotSupportedException();
    }

    public Map<String, ?> getAppData() {
        return this.appData;
    }

    public void setAppData(Map<String, ?> appData) {
        this.appData = appData;
    }

    public Date getBirthday() {
        String value = this.getSingleValueFromProperties(Person.Field.BIRTHDAY);
        return value == null ? null : FieldRestrictingPerson.tryParseDate(value);
    }

    public void setBirthday(Date birthday) {
        throw new NotSupportedException();
    }

    public BodyType getBodyType() {
        BodyTypeImpl type = null;
        if (this.displayField(Person.Field.BODY_TYPE)) {
            Map<String, String> map = FieldRestrictingPerson.mapValuesByQualifier(this.getFromProperties(Person.Field.BODY_TYPE));
            type = new BodyTypeImpl();
            type.setBuild(map.get("build"));
            type.setEyeColor(map.get("eyeColor"));
            type.setHairColor(map.get("hairColor"));
            type.setHeight(map.containsKey("height") ? Float.valueOf(Float.parseFloat(map.get("height"))) : null);
            type.setWeight(map.containsKey("weight") ? Float.valueOf(Float.parseFloat(map.get("weight"))) : null);
        }
        return type;
    }

    public void setBodyType(BodyType bodyType) {
        throw new NotSupportedException();
    }

    public List<String> getBooks() {
        return this.getValuesFromProperties(Person.Field.BOOKS);
    }

    public void setBooks(List<String> books) {
        throw new NotSupportedException();
    }

    public List<String> getCars() {
        return this.getValuesFromProperties(Person.Field.CARS);
    }

    public void setCars(List<String> cars) {
        throw new NotSupportedException();
    }

    public String getChildren() {
        return this.getSingleValueFromProperties(Person.Field.CHILDREN);
    }

    public void setChildren(String children) {
        throw new NotSupportedException();
    }

    public org.apache.shindig.social.opensocial.model.Address getCurrentLocation() {
        String qualifier = this.getSingleValueFromProperties(Person.Field.CURRENT_LOCATION);
        if (qualifier != null) {
            for (Address address : this.internal.getAddresses()) {
                if (!qualifier.equals(address.getQualifier())) continue;
                return this.convertAddress(address);
            }
        }
        return null;
    }

    public void setCurrentLocation(org.apache.shindig.social.opensocial.model.Address currentLocation) {
        throw new NotSupportedException();
    }

    public Enum<Drinker> getDrinker() {
        String value = this.getSingleValueFromProperties(Person.Field.DRINKER);
        return value == null ? null : new EnumImpl((Enum.EnumKey)Drinker.valueOf((String)value));
    }

    public void setDrinker(Enum<Drinker> newDrinker) {
        throw new NotSupportedException();
    }

    public List<ListField> getEmails() {
        if (!this.displayField(Person.Field.EMAILS)) {
            return null;
        }
        List<ListField> fields = this.getListFromProperties(Person.Field.EMAILS);
        for (ListField field : fields) {
            field.setPrimary(Boolean.valueOf(false));
        }
        ListFieldImpl listField = new ListFieldImpl("Registered", this.internal.getEmail());
        listField.setPrimary(Boolean.valueOf(true));
        fields.add((ListField)listField);
        return fields;
    }

    public void setEmails(List<ListField> emails) {
        throw new NotSupportedException();
    }

    public String getEthnicity() {
        return this.getSingleValueFromProperties(Person.Field.ETHNICITY);
    }

    public void setEthnicity(String ethnicity) {
        throw new NotSupportedException();
    }

    public String getFashion() {
        return this.getSingleValueFromProperties(Person.Field.FASHION);
    }

    public void setFashion(String fashion) {
        throw new NotSupportedException();
    }

    public List<String> getFood() {
        return this.getValuesFromProperties(Person.Field.FOOD);
    }

    public void setFood(List<String> food) {
        throw new NotSupportedException();
    }

    public Person.Gender getGender() {
        String value = this.getSingleValueFromProperties(Person.Field.GENDER);
        return value == null ? null : Person.Gender.valueOf((String)value);
    }

    public void setGender(Person.Gender newGender) {
        throw new NotSupportedException();
    }

    public String getHappiestWhen() {
        return this.getSingleValueFromProperties(Person.Field.HAPPIEST_WHEN);
    }

    public void setHappiestWhen(String happiestWhen) {
        throw new NotSupportedException();
    }

    public Boolean getHasApp() {
        return null;
    }

    public void setHasApp(Boolean hasApp) {
        throw new NotSupportedException();
    }

    public List<String> getHeroes() {
        return this.getValuesFromProperties(Person.Field.HEROES);
    }

    public void setHeroes(List<String> heroes) {
        throw new NotSupportedException();
    }

    public String getHumor() {
        return this.getSingleValueFromProperties(Person.Field.HUMOR);
    }

    public void setHumor(String humor) {
        throw new NotSupportedException();
    }

    public String getId() {
        return this.internal.getUsername();
    }

    public void setId(String id) {
        this.internal.setUsername(id);
    }

    public List<ListField> getIms() {
        return this.getListFromProperties(Person.Field.IMS);
    }

    public void setIms(List<ListField> ims) {
        throw new NotSupportedException();
    }

    public List<String> getInterests() {
        return this.getValuesFromProperties(Person.Field.INTERESTS);
    }

    public void setInterests(List<String> interests) {
        throw new NotSupportedException();
    }

    public String getJobInterests() {
        return this.getSingleValueFromProperties(Person.Field.JOB_INTERESTS);
    }

    public void setJobInterests(String jobInterests) {
        throw new NotSupportedException();
    }

    public List<String> getLanguagesSpoken() {
        return this.getValuesFromProperties(Person.Field.LANGUAGES_SPOKEN);
    }

    public void setLanguagesSpoken(List<String> languagesSpoken) {
        throw new NotSupportedException();
    }

    public Date getUpdated() {
        String value = this.getSingleValueFromProperties(Person.Field.LAST_UPDATED);
        return value == null ? null : FieldRestrictingPerson.tryParseDate(value);
    }

    public void setUpdated(Date updated) {
        throw new NotSupportedException();
    }

    public String getLivingArrangement() {
        return this.getSingleValueFromProperties(Person.Field.LIVING_ARRANGEMENT);
    }

    public void setLivingArrangement(String livingArrangement) {
        throw new NotSupportedException();
    }

    public List<Enum<LookingFor>> getLookingFor() {
        return this.displayField(Person.Field.LOOKING_FOR) ? FieldRestrictingPerson.getEnumsFromValues(this.getValuesFromProperties(Person.Field.LOOKING_FOR)) : null;
    }

    public void setLookingFor(List<Enum<LookingFor>> lookingFor) {
        throw new NotSupportedException();
    }

    public List<String> getMovies() {
        return this.getValuesFromProperties(Person.Field.MOVIES);
    }

    public void setMovies(List<String> movies) {
        throw new NotSupportedException();
    }

    public List<String> getMusic() {
        return this.getValuesFromProperties(Person.Field.MUSIC);
    }

    public void setMusic(List<String> music) {
        throw new NotSupportedException();
    }

    public Name getName() {
        if (this.displayField(Person.Field.NAME)) {
            NameImpl name = new NameImpl();
            name.setGivenName(this.internal.getGivenName());
            name.setFamilyName(this.internal.getFamilyName());
            name.setAdditionalName(this.internal.getAdditionalName());
            name.setFormatted(this.internal.getDisplayName());
            name.setHonorificPrefix(this.internal.getHonorificPrefix());
            return name;
        }
        return null;
    }

    public void setName(Name name) {
        throw new NotSupportedException();
    }

    public Enum<NetworkPresence> getNetworkPresence() {
        String value = this.getSingleValueFromProperties(Person.Field.NETWORKPRESENCE);
        return value == null ? null : new EnumImpl((Enum.EnumKey)NetworkPresence.valueOf((String)value));
    }

    public void setNetworkPresence(Enum<NetworkPresence> networkPresence) {
        throw new NotSupportedException();
    }

    public String getNickname() {
        return this.displayField(Person.Field.NICKNAME) ? this.internal.getPreferredName() : null;
    }

    public void setNickname(String nickname) {
        throw new NotSupportedException();
    }

    public List<Organization> getOrganizations() {
        return this.displayField(Person.Field.ORGANIZATIONS) ? this.convertOrganizations(this.internal.getOrganizations()) : null;
    }

    public void setOrganizations(List<Organization> organizations) {
        throw new NotSupportedException();
    }

    public String getPets() {
        return this.getSingleValueFromProperties(Person.Field.PETS);
    }

    public void setPets(String pets) {
        throw new NotSupportedException();
    }

    public List<ListField> getPhoneNumbers() {
        return this.getListFromProperties(Person.Field.PHONE_NUMBERS);
    }

    public void setPhoneNumbers(List<ListField> phoneNumbers) {
        throw new NotSupportedException();
    }

    public List<ListField> getPhotos() {
        return this.getListFromProperties(Person.Field.PHOTOS);
    }

    public void setPhotos(List<ListField> photos) {
        throw new NotSupportedException();
    }

    public String getPoliticalViews() {
        return this.getSingleValueFromProperties(Person.Field.POLITICAL_VIEWS);
    }

    public void setPoliticalViews(String politicalViews) {
        throw new NotSupportedException();
    }

    public String getPreferredUsername() {
        return this.displayField(Person.Field.PREFERRED_USERNAME) ? this.internal.getUsername() : null;
    }

    public void setPreferredUsername(String preferredString) {
        throw new NotSupportedException();
    }

    public Url getProfileSong() {
        return this.displayField(Person.Field.PROFILE_SONG) ? FieldRestrictingPerson.convertToUrl((PersonProperty)CollectionUtils.getSingleValue(this.getFromProperties(Person.Field.PROFILE_SONG))) : null;
    }

    public void setProfileSong(Url profileSong) {
        throw new NotSupportedException();
    }

    public Url getProfileVideo() {
        return this.displayField(Person.Field.PROFILE_SONG) ? FieldRestrictingPerson.convertToUrl((PersonProperty)CollectionUtils.getSingleValue(this.getFromProperties(Person.Field.PROFILE_VIDEO))) : null;
    }

    public void setProfileVideo(Url profileVideo) {
        throw new NotSupportedException();
    }

    public List<String> getQuotes() {
        return this.getValuesFromProperties(Person.Field.QUOTES);
    }

    public void setQuotes(List<String> quotes) {
        throw new NotSupportedException();
    }

    public String getRelationshipStatus() {
        return this.getSingleValueFromProperties(Person.Field.RELATIONSHIP_STATUS);
    }

    public void setRelationshipStatus(String relationshipStatus) {
        throw new NotSupportedException();
    }

    public String getReligion() {
        return this.getSingleValueFromProperties(Person.Field.RELIGION);
    }

    public void setReligion(String religion) {
        throw new NotSupportedException();
    }

    public String getRomance() {
        return this.getSingleValueFromProperties(Person.Field.ROMANCE);
    }

    public void setRomance(String romance) {
        throw new NotSupportedException();
    }

    public String getScaredOf() {
        return this.getSingleValueFromProperties(Person.Field.SCARED_OF);
    }

    public void setScaredOf(String scaredOf) {
        throw new NotSupportedException();
    }

    public String getSexualOrientation() {
        return this.getSingleValueFromProperties(Person.Field.SEXUAL_ORIENTATION);
    }

    public void setSexualOrientation(String sexualOrientation) {
        throw new NotSupportedException();
    }

    public Enum<Smoker> getSmoker() {
        String value = this.getSingleValueFromProperties(Person.Field.SMOKER);
        return value == null ? null : new EnumImpl((Enum.EnumKey)Smoker.valueOf((String)value));
    }

    public void setSmoker(Enum<Smoker> newSmoker) {
        throw new NotSupportedException();
    }

    public List<String> getSports() {
        return this.getValuesFromProperties(Person.Field.SPORTS);
    }

    public void setSports(List<String> sports) {
        throw new NotSupportedException();
    }

    public String getStatus() {
        return this.displayField(Person.Field.STATUS) ? this.internal.getStatus() : null;
    }

    public void setStatus(String status) {
        throw new NotSupportedException();
    }

    public List<String> getTags() {
        return this.getValuesFromProperties(Person.Field.TAGS);
    }

    public void setTags(List<String> tags) {
        throw new NotSupportedException();
    }

    public Long getUtcOffset() {
        String value = this.getSingleValueFromProperties(Person.Field.UTC_OFFSET);
        return value == null ? null : Long.valueOf(Long.parseLong(value));
    }

    public void setUtcOffset(Long utcOffset) {
        throw new NotSupportedException();
    }

    public List<String> getTurnOffs() {
        return this.getValuesFromProperties(Person.Field.TURN_OFFS);
    }

    public void setTurnOffs(List<String> turnOffs) {
        throw new NotSupportedException();
    }

    public List<String> getTurnOns() {
        return this.getValuesFromProperties(Person.Field.TURN_ONS);
    }

    public void setTurnOns(List<String> turnOns) {
        throw new NotSupportedException();
    }

    public List<String> getTvShows() {
        return this.getValuesFromProperties(Person.Field.TV_SHOWS);
    }

    public void setTvShows(List<String> tvShows) {
        throw new NotSupportedException();
    }

    public List<Url> getUrls() {
        if (!this.displayField(Person.Field.URLS)) {
            return null;
        }
        List<PersonProperty> properties = this.getFromProperties(Person.Field.URLS);
        ArrayList<Url> urls = new ArrayList<Url>();
        for (PersonProperty property : properties) {
            urls.add(FieldRestrictingPerson.convertToUrl(property));
        }
        return urls;
    }

    public void setUrls(List<Url> urls) {
        throw new NotSupportedException();
    }

    public boolean getIsOwner() {
        return this.isOwner;
    }

    public String getProfileUrl() {
        return this.getSingleValueFromProperties(Person.Field.PROFILE_URL);
    }

    public void setProfileUrl(String profileUrl) {
        throw new NotSupportedException();
    }

    public String getThumbnailUrl() {
        return this.getSingleValueFromProperties(Person.Field.THUMBNAIL_URL);
    }

    public void setThumbnailUrl(String thumbnailUrl) {
        throw new NotSupportedException();
    }

    public void setIsOwner(boolean isOwner) {
        this.isOwner = isOwner;
    }

    public boolean getIsViewer() {
        return this.isViewer;
    }

    public void setIsViewer(boolean isViewer) {
        this.isViewer = isViewer;
    }

    private String getSingleValueFromProperties(Person.Field field) {
        List<String> values = this.getValuesFromProperties(field);
        return values == null ? null : (String)CollectionUtils.getSingleValue(values);
    }

    private boolean displayField(Person.Field field) {
        return this.fields == null || this.fields.isEmpty() || this.fields.contains(field.toString());
    }

    private List<PersonProperty> getFromProperties(Person.Field field) {
        return this.propertyMap.containsKey(field.toString()) ? this.propertyMap.get(field.toString()) : new ArrayList<PersonProperty>();
    }

    private List<String> getValuesFromProperties(Person.Field field) {
        return this.displayField(field) ? FieldRestrictingPerson.toValueList(this.getFromProperties(field)) : null;
    }

    private List<ListField> getListFromProperties(Person.Field field) {
        return this.displayField(field) ? FieldRestrictingPerson.convertFromProperties(this.getFromProperties(field)) : null;
    }

    private static List<ListField> convertFromProperties(List<PersonProperty> properties) {
        ArrayList<ListField> fieldList = new ArrayList<ListField>();
        for (PersonProperty property : properties) {
            ListFieldImpl field = new ListFieldImpl(property.getQualifier(), property.getValue());
            field.setPrimary(property.getPrimary());
            fieldList.add((ListField)field);
        }
        return fieldList;
    }

    private static List<Enum<LookingFor>> getEnumsFromValues(List<String> values) {
        ArrayList<Enum<LookingFor>> looking = new ArrayList<Enum<LookingFor>>();
        if (values != null) {
            for (String value : values) {
                looking.add((Enum<LookingFor>)new EnumImpl((Enum.EnumKey)LookingFor.valueOf((String)value)));
            }
        }
        return looking;
    }

    private static Date tryParseDate(String value) {
        try {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").parse(value);
        }
        catch (ParseException e) {
            throw new IllegalStateException("Invalid Date found:   " + value);
        }
    }

    private static List<String> toValueList(List<PersonProperty> properties) {
        ArrayList<String> values = new ArrayList<String>();
        for (PersonProperty property : properties) {
            values.add(property.getValue());
        }
        return values;
    }

    private static Map<String, String> mapValuesByQualifier(List<PersonProperty> properties) {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        for (PersonProperty property : properties) {
            propertyMap.put(property.getQualifier(), property.getValue());
        }
        return propertyMap;
    }

    private static Url convertToUrl(PersonProperty property) {
        return new UrlImpl(property.getValue(), property.getExtendedValue(), property.getQualifier());
    }

    private List<org.apache.shindig.social.opensocial.model.Address> convertAddresses(List<Address> addresses) {
        ArrayList<org.apache.shindig.social.opensocial.model.Address> converted = new ArrayList<org.apache.shindig.social.opensocial.model.Address>();
        if (addresses != null) {
            for (Address address : addresses) {
                converted.add(this.convertAddress(address));
            }
        }
        return converted;
    }

    private org.apache.shindig.social.opensocial.model.Address convertAddress(Address address) {
        AddressImpl converted = new AddressImpl(address.getFormatted());
        converted.setCountry(address.getCountry());
        converted.setLatitude(address.getLatitude());
        converted.setLocality(address.getLocality());
        converted.setLongitude(address.getLongitude());
        converted.setPostalCode(address.getPostalCode());
        converted.setRegion(address.getRegion());
        converted.setStreetAddress(address.getStreetAddress());
        converted.setType(address.getQualifier());
        converted.setPrimary(address.getPrimary());
        return converted;
    }

    private static Map<String, List<PersonProperty>> createPropertyMap(List<PersonProperty> properties) {
        HashMap<String, List<PersonProperty>> map = new HashMap<String, List<PersonProperty>>();
        for (PersonProperty property : properties) {
            List<PersonProperty> propertyList;
            String fieldType = property.getType();
            if (map.containsKey(fieldType)) {
                propertyList = (List)map.get(fieldType);
            } else {
                propertyList = new ArrayList();
                map.put(fieldType, propertyList);
            }
            propertyList.add(property);
        }
        return map;
    }

    private static List<Account> convertAccounts(List<PersonProperty> properties) {
        ArrayList<Account> accounts = new ArrayList<Account>();
        for (PersonProperty property : properties) {
            Account account = FieldRestrictingPerson.convertToAccount(property);
            accounts.add(account);
        }
        return accounts;
    }

    private static Account convertToAccount(PersonProperty property) {
        AccountImpl account = new AccountImpl();
        account.setUsername(property.getValue());
        account.setUserId(property.getExtendedValue());
        account.setDomain(property.getQualifier());
        return account;
    }

    private List<Organization> convertOrganizations(List<org.apache.rave.model.Organization> organizations) {
        ArrayList<Organization> converted = new ArrayList<Organization>();
        if (organizations != null) {
            for (org.apache.rave.model.Organization org : organizations) {
                converted.add(this.convertOrganization(org));
            }
        }
        return converted;
    }

    private Organization convertOrganization(org.apache.rave.model.Organization org) {
        OrganizationImpl converted = new OrganizationImpl();
        converted.setAddress(this.convertAddress(org.getAddress()));
        converted.setDescription(org.getDescription());
        converted.setStartDate(org.getStartDate());
        converted.setEndDate(org.getEndDate());
        converted.setField(org.getField());
        converted.setName(org.getName());
        converted.setSubField(org.getSubField());
        converted.setType(org.getQualifier());
        converted.setTitle(org.getTitle());
        converted.setWebpage(org.getWebpage());
        return converted;
    }
}

