<%--
  Licensed to the Apache Software Foundation (ASF) under one
  or more contributor license agreements.  See the NOTICE file
  distributed with this work for additional information
  regarding copyright ownership.  The ASF licenses this file
  to you under the Apache License, Version 2.0 (the
  "License"); you may not use this file except in compliance
  with the License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing,
  software distributed under the License is distributed on an
  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
  KIND, either express or implied.  See the License for the
  specific language governing permissions and limitations
  under the License.
  --%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt" %>
<fmt:setBundle basename="messages"/>
<%--@elvariable id="tabs" type="org.apache.rave.portal.web.model.NavigationMenu"--%>
<c:if test="${not empty tabs}">
    <nav>
        <div class="tabbable">
            <ul class="nav nav-tabs nav-stacked">
                <c:forEach items="${tabs.navigationItems}" var="navItem">
                    <c:choose>
                        <c:when test="${navItem.selected}">
                            <li class="active">
                                <a href="<spring:url value="${navItem.url}"/>"><fmt:message key="${navItem.name}"/></a>
                            </li>
                        </c:when>
                        <c:otherwise>
                            <li>
                                <a href="<spring:url value="${navItem.url}"/>"><fmt:message key="${navItem.name}"/></a>
                            </li>
                        </c:otherwise>
                    </c:choose>
                </c:forEach>
            </ul>
        </div>
    </nav>
</c:if>

