/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.web.api.rest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.util.ClassUtils;
import org.springframework.web.bind.annotation.ExceptionHandler;

public abstract class AbstractRestApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @ExceptionHandler(value={AccessDeniedException.class})
    public void handleAccessDeniedException(Exception ex, HttpServletRequest request, HttpServletResponse response) {
        this.logger.info("AccessDeniedException: " + request.getUserPrincipal().getName() + " attempted to access resource " + request.getRequestURL(), (Throwable)ex);
        response.setStatus(HttpStatus.FORBIDDEN.value());
    }

    @ExceptionHandler(value={Exception.class})
    public String handleException(Exception ex, HttpServletRequest request, HttpServletResponse response) {
        this.logger.info("Error occured while accessing " + request.getRequestURL(), (Throwable)ex);
        response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        return ClassUtils.getShortName(ex.getClass());
    }
}

