/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.web.api.rest;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.rave.model.Person;
import org.apache.rave.model.Tag;
import org.apache.rave.model.Widget;
import org.apache.rave.model.WidgetComment;
import org.apache.rave.model.WidgetRating;
import org.apache.rave.model.WidgetTag;
import org.apache.rave.portal.model.impl.TagImpl;
import org.apache.rave.portal.model.impl.WidgetCommentImpl;
import org.apache.rave.portal.model.impl.WidgetRatingImpl;
import org.apache.rave.portal.model.impl.WidgetTagImpl;
import org.apache.rave.portal.service.TagService;
import org.apache.rave.portal.service.UserService;
import org.apache.rave.portal.service.WidgetService;
import org.apache.rave.portal.web.api.rest.AbstractRestApi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/rest/widgets"})
public class WidgetApi
extends AbstractRestApi {
    private static Logger logger = LoggerFactory.getLogger(WidgetApi.class);
    private final UserService userService;
    private final TagService tagService;
    private final WidgetService widgetService;

    @Autowired
    public WidgetApi(UserService userService, TagService tagService, WidgetService widgetService) {
        this.userService = userService;
        this.tagService = tagService;
        this.widgetService = widgetService;
    }

    @RequestMapping(method={RequestMethod.GET})
    public void getAllWidgets() {
        logger.debug("GET received for all widgets");
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/{widgetId}/comments"})
    public void createWidgetComment(@PathVariable String widgetId, @RequestParam String text, HttpServletResponse response) {
        WidgetCommentImpl widgetComment = new WidgetCommentImpl();
        widgetComment.setUserId(this.userService.getAuthenticatedUser().getId());
        widgetComment.setText(text);
        widgetComment.setCreatedDate(new Date());
        widgetComment.setLastModifiedDate(new Date());
        this.widgetService.createWidgetComment(widgetId, (WidgetComment)widgetComment);
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, value={"/{widgetId}/comments/{widgetCommentId}"})
    public WidgetComment getWidgetComment(@PathVariable String widgetId, @PathVariable String widgetCommentId) {
        return this.widgetService.getWidgetComment(widgetId, widgetCommentId);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/{widgetId}/comments/{widgetCommentId}"})
    public void updateWidgetComment(@PathVariable String widgetId, @PathVariable String widgetCommentId, @RequestParam String text, HttpServletResponse response) {
        WidgetComment widgetComment = this.widgetService.getWidgetComment(widgetId, widgetCommentId);
        if (widgetComment == null) {
            widgetComment = new WidgetCommentImpl();
            widgetComment.setUserId(this.userService.getAuthenticatedUser().getId());
            widgetComment.setCreatedDate(new Date());
            widgetComment.setLastModifiedDate(new Date());
            widgetComment.setText(text);
            this.widgetService.createWidgetComment(widgetId, widgetComment);
        } else {
            widgetComment.setText(text);
            this.widgetService.updateWidgetComment(widgetId, widgetComment);
        }
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }

    @RequestMapping(method={RequestMethod.DELETE}, value={"/{widgetId}/comments/{widgetCommentId}"})
    public void deleteWidgetComment(@PathVariable String widgetId, @PathVariable String widgetCommentId, HttpServletResponse response) {
        this.widgetService.removeWidgetComment(widgetId, widgetCommentId);
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }

    @RequestMapping(value={"/{widgetId}/rating"}, method={RequestMethod.DELETE})
    public void deleteWidgetRating(@PathVariable String widgetId, HttpServletResponse response) {
        logger.debug("DELETE WidgetRating received for /api/rest/widgets/{}", (Object)widgetId);
        this.widgetService.removeWidgetRating(widgetId, this.userService.getAuthenticatedUser().getId());
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }

    @RequestMapping(value={"/{widgetId}/rating"}, method={RequestMethod.POST})
    public void setWidgetRating(@PathVariable String widgetId, @RequestParam(value="score") Integer score, HttpServletResponse response) {
        logger.debug("POST WidgetRating received for /api/rest/widgets/{} score: {}", (Object)widgetId, (Object)score);
        WidgetRatingImpl widgetRating = new WidgetRatingImpl();
        widgetRating.setScore(score);
        widgetRating.setUserId(this.userService.getAuthenticatedUser().getId());
        this.widgetService.saveWidgetRating(widgetId, (WidgetRating)widgetRating);
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, value={"/{widgetId}/users"})
    public List<Person> getAllUsers(@PathVariable String widgetId) {
        return this.userService.getAllByAddedWidget(widgetId);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/{widgetId}/tags"})
    public void createWidgetTag(@PathVariable String widgetId, @RequestParam String tagText, HttpServletResponse response) {
        WidgetTag existed;
        logger.debug("add tags " + tagText + " to widget " + widgetId);
        if (tagText != null && !tagText.trim().isEmpty() && (existed = this.widgetService.getWidgetTagByWidgetIdAndKeyword(widgetId, tagText)) == null) {
            WidgetTagImpl widgetTag = new WidgetTagImpl(this.userService.getAuthenticatedUser(), new Date(), this.getTag(tagText));
            this.widgetService.createWidgetTag(widgetId, (WidgetTag)widgetTag);
            logger.debug("widget tag is saved.");
        }
        response.setStatus(HttpStatus.NO_CONTENT.value());
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, value={"/{widgetId}/tags"})
    public List<Tag> getTags(@PathVariable String widgetId, HttpServletResponse response) {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        Widget widget = this.widgetService.getWidget(widgetId);
        if (widget == null) {
            response.setStatus(404);
            return null;
        }
        for (WidgetTag wt : widget.getTags()) {
            tags.add(this.tagService.getTagById(wt.getTagId()));
        }
        return tags;
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, value={"/tags"})
    public List<Tag> getAllTags() {
        return this.tagService.getAllTagsList();
    }

    private Tag getTag(String keyword) {
        Tag tag = this.tagService.getTagByKeyword(keyword);
        if (tag == null) {
            tag = new TagImpl(keyword);
            tag = this.tagService.save(tag);
        }
        return tag;
    }
}

