/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.web.api.rpc;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.rave.model.Page;
import org.apache.rave.model.Region;
import org.apache.rave.model.RegionWidget;
import org.apache.rave.portal.service.OmdlService;
import org.apache.rave.portal.service.PageService;
import org.apache.rave.portal.web.api.rpc.model.RpcOperation;
import org.apache.rave.portal.web.api.rpc.model.RpcResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller(value="rpcPageApi")
@RequestMapping(value={"/api/rpc/page/*"})
public class PageApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final PageService pageService;
    private OmdlService omdlService;

    @Autowired
    public PageApi(PageService pageService, OmdlService omdlService) {
        this.pageService = pageService;
        this.omdlService = omdlService;
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.POST}, value={"{pageId}/widget/add"})
    public RpcResult<RegionWidget> addWidgetToPage(final @PathVariable String pageId, final @RequestParam String widgetId) {
        return new RpcOperation<RegionWidget>(){

            @Override
            public RegionWidget execute() {
                return PageApi.this.pageService.addWidgetToPage(pageId, widgetId);
            }
        }.getResult();
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.POST}, value={"{pageId}/widget/add/region/{regionId}"})
    public RpcResult<RegionWidget> addWidgetToPageRegion(final @PathVariable String pageId, final @RequestParam String widgetId, final @PathVariable String regionId) {
        return new RpcOperation<RegionWidget>(){

            @Override
            public RegionWidget execute() {
                return PageApi.this.pageService.addWidgetToPageRegion(pageId, widgetId, regionId);
            }
        }.getResult();
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.POST}, value={"regionWidget/{regionWidgetId}/move"})
    public RpcResult<RegionWidget> moveWidgetOnPage(final @PathVariable String regionWidgetId, final @RequestParam int newPosition, final @RequestParam String toRegion, final @RequestParam String fromRegion) {
        return new RpcOperation<RegionWidget>(){

            @Override
            public RegionWidget execute() {
                return PageApi.this.pageService.moveRegionWidget(regionWidgetId, newPosition, toRegion, fromRegion);
            }
        }.getResult();
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.POST}, value={"regionWidget/{regionWidgetId}/delete"})
    public RpcResult<Region> removeWidgetFromPage(final @PathVariable String regionWidgetId) {
        return new RpcOperation<Region>(){

            @Override
            public Region execute() {
                return PageApi.this.pageService.removeWidgetFromPage(regionWidgetId);
            }
        }.getResult();
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.POST}, value={"add"})
    public RpcResult<Page> addPage(final @RequestParam String pageName, final @RequestParam String pageLayoutCode) {
        return new RpcOperation<Page>(){

            @Override
            public Page execute() {
                return PageApi.this.pageService.addNewUserPage(pageName, pageLayoutCode);
            }
        }.getResult();
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, value={"get"})
    public RpcResult<Page> getPage(final @RequestParam String pageId) {
        return new RpcOperation<Page>(){

            @Override
            public Page execute() {
                return PageApi.this.pageService.getPage(pageId);
            }
        }.getResult();
    }

    @ResponseBody
    @RequestMapping(value={"{pageId}/update"}, method={RequestMethod.POST})
    public RpcResult<Page> updatePageProperties(final @PathVariable String pageId, final @RequestParam String name, final @RequestParam String layout) {
        return new RpcOperation<Page>(){

            @Override
            public Page execute() {
                return PageApi.this.pageService.updatePage(pageId, name, layout);
            }
        }.getResult();
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.POST}, value={"{pageId}/move"})
    public RpcResult<Page> movePage(final @PathVariable String pageId, final @RequestParam(required=false) String moveAfterPageId) {
        return new RpcOperation<Page>(){

            @Override
            public Page execute() {
                Page page = null;
                page = moveAfterPageId == null ? PageApi.this.pageService.movePageToDefault(pageId) : PageApi.this.pageService.movePage(pageId, moveAfterPageId);
                return page;
            }
        }.getResult();
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.POST}, value={"{toPageId}/moveWidget"})
    public RpcResult<RegionWidget> moveWidgetToPage(final @PathVariable String toPageId, final @RequestParam(required=false) String regionWidgetId) {
        return new RpcOperation<RegionWidget>(){

            @Override
            public RegionWidget execute() {
                return PageApi.this.pageService.moveRegionWidgetToPage(regionWidgetId, toPageId);
            }
        }.getResult();
    }

    @ResponseBody
    @RequestMapping(value={"{pageId}/clone"}, method={RequestMethod.POST})
    public RpcResult<Page> clonePageForUser(final @PathVariable String pageId, final @RequestParam String userId, final @RequestParam String pageName) {
        return new RpcOperation<Page>(){

            @Override
            public Page execute() {
                return PageApi.this.pageService.clonePageForUser(pageId, userId, pageName);
            }
        }.getResult();
    }

    @ResponseBody
    @RequestMapping(value={"{pageId}/addmember"}, method={RequestMethod.POST})
    public RpcResult<Boolean> addMemberToPage(final @PathVariable String pageId, final @RequestParam String userId) {
        return new RpcOperation<Boolean>(){

            @Override
            public Boolean execute() {
                return PageApi.this.pageService.addMemberToPage(pageId, userId);
            }
        }.getResult();
    }

    @ResponseBody
    @RequestMapping(value={"{pageId}/removemember"}, method={RequestMethod.POST})
    public RpcResult<Boolean> removeMemberFromPage(final @PathVariable String pageId, final @RequestParam String userId) {
        return new RpcOperation<Boolean>(){

            @Override
            public Boolean execute() {
                return PageApi.this.pageService.removeMemberFromPage(pageId, userId);
            }
        }.getResult();
    }

    @ResponseBody
    @RequestMapping(value={"{pageId}/sharestatus"}, method={RequestMethod.POST})
    public RpcResult<Boolean> updateSharedPageStatus(final @PathVariable String pageId, final @RequestParam String shareStatus) {
        return new RpcOperation<Boolean>(){

            @Override
            public Boolean execute() {
                return PageApi.this.pageService.updateSharedPageStatus(pageId, shareStatus);
            }
        }.getResult();
    }

    @ResponseBody
    @RequestMapping(value={"{pageId}/editstatus"}, method={RequestMethod.POST})
    public RpcResult<Boolean> updatePageEditingStatus(final @PathVariable String pageId, final @RequestParam String userId, final @RequestParam boolean isEditor) {
        return new RpcOperation<Boolean>(){

            @Override
            public Boolean execute() {
                return PageApi.this.pageService.updatePageEditingStatus(pageId, userId, isEditor);
            }
        }.getResult();
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.POST}, value={"import/omdl"})
    public RpcResult<Page> importPage(HttpServletRequest request, HttpServletResponse response, final @RequestParam String pageName) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        final MultipartFile multipartFile = multipartRequest.getFile("omdlFile");
        return new RpcOperation<Page>(){

            @Override
            public Page execute() {
                return PageApi.this.omdlService.importOmdl(multipartFile, pageName);
            }
        }.getResult();
    }
}

