/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.web.api.rpc;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;
import org.apache.rave.model.Person;
import org.apache.rave.portal.service.UserService;
import org.apache.rave.portal.web.api.rpc.model.RpcOperation;
import org.apache.rave.portal.web.api.rpc.model.RpcResult;
import org.apache.rave.rest.model.SearchResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller(value="rpcPersonApi")
@RequestMapping(value={"/api/rpc/person/*"})
public class PersonApi {
    public static final int DEFAULT_PAGE_SIZE = 10;
    private final UserService userService;

    @Autowired
    public PersonApi(UserService userService) {
        this.userService = userService;
    }

    @ResponseBody
    @RequestMapping(value={"getFriends"}, method={RequestMethod.POST})
    public RpcResult<HashMap<String, List<Person>>> getFriends() {
        return new RpcOperation<HashMap<String, List<Person>>>(){

            @Override
            public HashMap<String, List<Person>> execute() {
                return PersonApi.this.userService.getFriendsAndRequests(PersonApi.this.userService.getAuthenticatedUser().getUsername());
            }
        }.getResult();
    }

    @ResponseBody
    @RequestMapping(value={"{friendUsername}/addfriend"}, method={RequestMethod.POST})
    public RpcResult<Boolean> addFriend(final @PathVariable String friendUsername) {
        return new RpcOperation<Boolean>(){

            @Override
            public Boolean execute() {
                try {
                    boolean result = PersonApi.this.userService.addFriend(URLDecoder.decode(friendUsername, "UTF-8"), PersonApi.this.userService.getAuthenticatedUser().getUsername());
                    return result;
                }
                catch (UnsupportedEncodingException e) {
                    return false;
                }
            }
        }.getResult();
    }

    @ResponseBody
    @RequestMapping(value={"{friendUsername}/removefriend"}, method={RequestMethod.POST})
    public RpcResult<Boolean> removeFriend(final @PathVariable String friendUsername) {
        return new RpcOperation<Boolean>(){

            @Override
            public Boolean execute() {
                try {
                    PersonApi.this.userService.removeFriend(URLDecoder.decode(friendUsername, "UTF-8"), PersonApi.this.userService.getAuthenticatedUser().getUsername());
                    return true;
                }
                catch (UnsupportedEncodingException e) {
                    return false;
                }
            }
        }.getResult();
    }

    @ResponseBody
    @RequestMapping(value={"{friendUsername}/acceptfriendrequest"}, method={RequestMethod.POST})
    public RpcResult<Boolean> acceptFriendRequest(final @PathVariable String friendUsername) {
        return new RpcOperation<Boolean>(){

            @Override
            public Boolean execute() {
                try {
                    boolean result = PersonApi.this.userService.acceptFriendRequest(URLDecoder.decode(friendUsername, "UTF-8"), PersonApi.this.userService.getAuthenticatedUser().getUsername());
                    return result;
                }
                catch (UnsupportedEncodingException e) {
                    return false;
                }
            }
        }.getResult();
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, value={"get"})
    public RpcResult<SearchResult<Person>> viewUsers(final @RequestParam int offset) {
        return new RpcOperation<SearchResult<Person>>(){

            @Override
            public SearchResult<Person> execute() {
                return PersonApi.this.userService.getLimitedListOfPersons(offset, 10);
            }
        }.getResult();
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, value={"search"})
    public RpcResult<SearchResult<Person>> searchUsers(final @RequestParam String searchTerm, final @RequestParam int offset) {
        return new RpcOperation<SearchResult<Person>>(){

            @Override
            public SearchResult<Person> execute() {
                return PersonApi.this.userService.getPersonsByFreeTextSearch(searchTerm, offset, 10);
            }
        }.getResult();
    }
}

