/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.web.api.rpc.model;

import org.apache.rave.exception.DuplicateItemException;
import org.apache.rave.portal.web.api.rpc.model.RpcResult;

public abstract class RpcOperation<T> {
    public RpcResult<T> getResult() {
        RpcResult<T> result;
        try {
            T subject = this.execute();
            result = new RpcResult<T>(false, subject);
        }
        catch (IllegalArgumentException e) {
            result = this.createRpcResultError(e, RpcResult.ErrorCode.INVALID_PARAMS);
        }
        catch (DuplicateItemException e) {
            result = this.createRpcResultError((Exception)((Object)e), RpcResult.ErrorCode.DUPLICATE_ITEM);
        }
        catch (Exception e) {
            result = this.createRpcResultError(e, RpcResult.ErrorCode.INTERNAL_ERROR);
        }
        return result;
    }

    public abstract T execute();

    private RpcResult<T> createRpcResultError(Exception e, RpcResult.ErrorCode errorCode) {
        return new RpcResult(true, e.getMessage(), errorCode);
    }
}

