/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.web.controller;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.rave.model.Page;
import org.apache.rave.model.PageInvitationStatus;
import org.apache.rave.model.PageLayout;
import org.apache.rave.model.PageUser;
import org.apache.rave.model.User;
import org.apache.rave.portal.service.PageLayoutService;
import org.apache.rave.portal.service.PageService;
import org.apache.rave.portal.service.UserService;
import org.apache.rave.portal.web.controller.util.ControllerUtils;
import org.apache.rave.portal.web.util.ViewNames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class PageController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private PageService pageService;
    private UserService userService;
    private PageLayoutService pageLayoutService;

    @Autowired
    public PageController(PageService pageService, UserService userService, PageLayoutService pageLayoutService) {
        this.pageService = pageService;
        this.userService = userService;
        this.pageLayoutService = pageLayoutService;
    }

    @RequestMapping(value={"/login"}, method={RequestMethod.GET})
    public String login(Model model, HttpServletRequest httpServletRequest) {
        return "login";
    }

    @RequestMapping(value={"/page/view", "/index.html"}, method={RequestMethod.GET})
    public String viewDefault(Model model, HttpServletRequest request) {
        List<Page> pages = this.getAllPagesForAuthenticatedUser();
        Page page = this.pageService.getDefaultPageFromList(pages);
        PageUser currentPageUser = null;
        User thisUser = this.userService.getAuthenticatedUser();
        for (PageUser pageUser : page.getMembers()) {
            if (!pageUser.getUserId().equals(thisUser.getId())) continue;
            currentPageUser = pageUser;
        }
        List pageLayouts = this.pageLayoutService.getAllUserSelectable();
        this.addAttributesToModel(model, page, currentPageUser, pages, pageLayouts);
        String view = ControllerUtils.getDeviceAppropriateView(request, ViewNames.getPageView(page.getPageLayout().getCode()), "templates.user.mobile_home");
        ControllerUtils.addNavItemsToModel(view, model, page.getId(), this.userService.getAuthenticatedUser(), currentPageUser.isEditor());
        return view;
    }

    @RequestMapping(value={"/page/view/{pageId}"}, method={RequestMethod.GET})
    public String view(@PathVariable String pageId, Model model, HttpServletRequest request) {
        try {
            List<Page> pages = this.getAllPagesForAuthenticatedUser();
            Page page = this.pageService.getPageFromList(pageId, pages);
            PageUser currentPageUser = null;
            User thisUser = this.userService.getAuthenticatedUser();
            for (PageUser pageUser : page.getMembers()) {
                if (!pageUser.getUserId().equals(thisUser.getId())) continue;
                currentPageUser = pageUser;
            }
            List pageLayouts = this.pageLayoutService.getAllUserSelectable();
            this.addAttributesToModel(model, page, currentPageUser, pages, pageLayouts);
            String view = ControllerUtils.getDeviceAppropriateView(request, ViewNames.getPageView(page.getPageLayout().getCode()), "templates.user.mobile_home");
            ControllerUtils.addNavItemsToModel(view, model, page.getId(), thisUser, currentPageUser.isEditor());
            return view;
        }
        catch (Exception e) {
            this.logger.info("unable to get page - possibly because a shared page was revoked by its owner");
            return this.viewDefault(model, request);
        }
    }

    private List<Page> getAllPagesForAuthenticatedUser() {
        User user = this.userService.getAuthenticatedUser();
        String userId = user.getId();
        List pages = this.pageService.getAllUserPages(userId);
        List<Object> viewablePages = new ArrayList<Page>();
        for (Page page : pages) {
            for (PageUser pageUser : page.getMembers()) {
                if (pageUser == null || !pageUser.getUserId().equals(user.getId()) || pageUser.getPageStatus().equals((Object)PageInvitationStatus.REFUSED)) continue;
                viewablePages.add(page);
            }
        }
        if (viewablePages.isEmpty()) {
            this.logger.info("User {} does not have any pages - creating default page", (Object)user.getUsername());
            this.pageService.addNewDefaultUserPage(userId);
            viewablePages = this.pageService.getAllUserPages(userId);
        }
        return viewablePages;
    }

    private void addAttributesToModel(Model model, Page page, PageUser pageUser, List<Page> pages, List<PageLayout> pageLayouts) {
        model.addAttribute("page", (Object)page);
        model.addAttribute("pages", pages);
        model.addAttribute("pageLayouts", pageLayouts);
        model.addAttribute("pageUser", (Object)pageUser);
    }
}

