/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.web.controller.admin;

import java.util.List;
import org.apache.rave.model.Category;
import org.apache.rave.model.User;
import org.apache.rave.portal.model.impl.CategoryImpl;
import org.apache.rave.portal.service.CategoryService;
import org.apache.rave.portal.service.UserService;
import org.apache.rave.portal.web.controller.admin.AdminControllerUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.bind.support.SessionStatus;

@Controller
@SessionAttributes(value={"category", "tokencheck"})
public class CategoryController {
    private static final String SELECTED_ITEM = "categories";
    @Autowired
    private UserService userService;
    @Autowired
    private CategoryService categoryService;

    @RequestMapping(value={"/admin/categories", "/admin/categories/"}, method={RequestMethod.GET})
    public String getCategories(@RequestParam(required=false) String action, @RequestParam(required=false) String referringPageId, Model model) {
        AdminControllerUtil.addNavigationMenusToModel(SELECTED_ITEM, model, referringPageId);
        List categories = this.categoryService.getAllList();
        model.addAttribute(SELECTED_ITEM, (Object)categories);
        model.addAttribute("category", (Object)new CategoryImpl());
        model.addAttribute("tokencheck", (Object)AdminControllerUtil.generateSessionToken());
        model.addAttribute("referringPageId", (Object)referringPageId);
        if (AdminControllerUtil.isCreateDeleteOrUpdate(action)) {
            model.addAttribute("actionresult", (Object)action);
        }
        return "templates.admin.categories";
    }

    @RequestMapping(value={"/admin/category/create"}, method={RequestMethod.POST})
    public String createCategory(@ModelAttribute CategoryImpl category, @ModelAttribute(value="tokencheck") String sessionToken, @RequestParam String token, @RequestParam(required=false) String referringPageId, Model model, SessionStatus status) {
        AdminControllerUtil.checkTokens(sessionToken, token, status);
        User creator = this.userService.getAuthenticatedUser();
        boolean isValidRequest = this.validateRequest(category.getText(), creator);
        if (!isValidRequest) {
            model.addAttribute("referringPageId", (Object)referringPageId);
            AdminControllerUtil.addNavigationMenusToModel(SELECTED_ITEM, model, referringPageId);
            return "templates.admin.categories";
        }
        this.categoryService.create(category.getText(), creator);
        status.setComplete();
        return "redirect:/app/admin/categories?action=create&referringPageId=" + referringPageId;
    }

    @RequestMapping(value={"/admin/category/update"}, method={RequestMethod.POST})
    public String updateCategory(@ModelAttribute(value="category") Category category, @ModelAttribute(value="tokencheck") String sessionToken, @RequestParam String token, @RequestParam(required=false) String referringPageId, Model model, SessionStatus status) {
        AdminControllerUtil.checkTokens(sessionToken, token, status);
        model.addAttribute("referringPageId", (Object)referringPageId);
        User currentUser = this.userService.getAuthenticatedUser();
        boolean isValidRequest = this.validateRequest(category, currentUser);
        if (!isValidRequest) {
            AdminControllerUtil.addNavigationMenusToModel(SELECTED_ITEM, model, referringPageId);
            return "templates.admin.categoryDetail";
        }
        this.categoryService.update(category.getId(), category.getText(), currentUser);
        status.setComplete();
        model.asMap().clear();
        return "redirect:/app/admin/categories?action=update&referringPageId=" + referringPageId;
    }

    @RequestMapping(value={"/admin/category/delete"}, method={RequestMethod.POST})
    public String deleteCategory(@ModelAttribute(value="category") Category category, @ModelAttribute(value="tokencheck") String sessionToken, @RequestParam String token, @RequestParam(required=false) String confirmdelete, @RequestParam(required=false) String referringPageId, Model model, SessionStatus status) {
        AdminControllerUtil.checkTokens(sessionToken, token, status);
        User creator = this.userService.getAuthenticatedUser();
        if (!Boolean.parseBoolean(confirmdelete)) {
            model.addAttribute("referringPageId", (Object)referringPageId);
            AdminControllerUtil.addNavigationMenusToModel(SELECTED_ITEM, model, referringPageId);
            model.addAttribute("missingConfirm", (Object)true);
            return "templates.admin.categoryDetail";
        }
        boolean isValidRequest = this.validateRequest(category, creator);
        if (!isValidRequest) {
            model.addAttribute("referringPageId", (Object)referringPageId);
            AdminControllerUtil.addNavigationMenusToModel(SELECTED_ITEM, model, referringPageId);
            return "templates.admin.categoryDetail";
        }
        this.categoryService.delete(category);
        status.setComplete();
        return "redirect:/app/admin/categories?action=delete&referringPageId=" + referringPageId;
    }

    @RequestMapping(value={"/admin/category/edit"}, method={RequestMethod.GET})
    public String editCategory(@RequestParam(required=true) String id, @RequestParam(required=false) String referringPageId, Model model) {
        model.addAttribute("referringPageId", (Object)referringPageId);
        AdminControllerUtil.addNavigationMenusToModel(SELECTED_ITEM, model, referringPageId);
        model.addAttribute("tokencheck", (Object)AdminControllerUtil.generateSessionToken());
        model.addAttribute("category", (Object)this.categoryService.get(id));
        return "templates.admin.categoryDetail";
    }

    private boolean validateRequest(String text, User creator) {
        return text != null && creator != null && !text.equals("");
    }

    private boolean validateRequest(Category category, User modifier) {
        return this.validateRequest(category.getText(), modifier) && this.categoryService.get(category.getId()) != null;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public void setCategoryService(CategoryService categoryService) {
        this.categoryService = categoryService;
    }
}

