/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.web.controller.handler;

import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.rave.model.User;
import org.apache.rave.portal.model.impl.UserImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.openid.OpenIDAttribute;
import org.springframework.security.openid.OpenIDAuthenticationStatus;
import org.springframework.security.openid.OpenIDAuthenticationToken;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.stereotype.Controller;

@Controller
public class OpenIDAuthenticationFailureHandler
extends SimpleUrlAuthenticationFailureHandler {
    private static Logger log = LoggerFactory.getLogger(OpenIDAuthenticationFailureHandler.class);

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        if (exception instanceof UsernameNotFoundException && exception.getAuthentication() instanceof OpenIDAuthenticationToken && ((OpenIDAuthenticationToken)exception.getAuthentication()).getStatus().equals((Object)OpenIDAuthenticationStatus.SUCCESS)) {
            OpenIDAuthenticationToken token = (OpenIDAuthenticationToken)exception.getAuthentication();
            String url = token.getIdentityUrl();
            User user = this.createTemporaryUser(token, url);
            request.getSession(true).setAttribute("newUser", (Object)user);
            DefaultRedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
            log.info("Redirecting to new user account creation page");
            super.setRedirectStrategy((RedirectStrategy)redirectStrategy);
            redirectStrategy.sendRedirect(request, response, "/app/openidregister");
            return;
        }
        super.onAuthenticationFailure(request, response, exception);
    }

    private User createTemporaryUser(OpenIDAuthenticationToken token, String openId) {
        List attributes = token.getAttributes();
        String email = null;
        String firstName = null;
        String lastName = null;
        String displayName = null;
        for (OpenIDAttribute attribute : attributes) {
            if ("email".equals(attribute.getName()) && !attribute.getValues().isEmpty()) {
                email = (String)attribute.getValues().get(0);
                continue;
            }
            if ("firstname".equals(attribute.getName()) && !attribute.getValues().isEmpty()) {
                firstName = (String)attribute.getValues().get(0);
                continue;
            }
            if ("lastname".equals(attribute.getName()) && !attribute.getValues().isEmpty()) {
                lastName = (String)attribute.getValues().get(0);
                continue;
            }
            if (!"fullname".equals(attribute.getName()) || attribute.getValues().isEmpty()) continue;
            displayName = (String)attribute.getValues().get(0);
        }
        UserImpl user = new UserImpl();
        String username = StringUtils.substringAfter((String)openId, (String)"://").replace("/", "");
        if (username.length() > 35) {
            username = username.substring(0, 35);
        }
        if (displayName == null && firstName != null && lastName != null) {
            displayName = firstName + " " + lastName;
        }
        user.setUsername(username);
        user.setEmail(email);
        user.setGivenName(firstName);
        user.setFamilyName(lastName);
        user.setDisplayName(displayName);
        user.setOpenId(openId);
        return user;
    }
}

