/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rave.portal.web.controller.util;

import javax.servlet.http.HttpServletRequest;
import org.apache.rave.model.User;
import org.apache.rave.portal.web.model.NavigationItem;
import org.apache.rave.portal.web.model.NavigationMenu;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mobile.device.DeviceUtils;
import org.springframework.ui.Model;

public class ControllerUtils {
    private static final Logger log = LoggerFactory.getLogger(ControllerUtils.class);

    public static boolean isMobileDevice(HttpServletRequest request) {
        return DeviceUtils.getCurrentDevice((HttpServletRequest)request).isMobile();
    }

    public static String getDeviceAppropriateView(HttpServletRequest request, String defaultView, String mobileView) {
        String viewName = null;
        if (ControllerUtils.isMobileDevice(request)) {
            log.debug("mobile device detected - viewing default mobile page template");
            viewName = mobileView;
        } else {
            log.debug("non-mobile device detected - viewing regular page layout");
            viewName = defaultView;
        }
        log.debug("viewName: " + viewName);
        return viewName;
    }

    public static void addNavItemsToModel(String view, Model model, String referringPageId, User user) {
        NavigationMenu topMenu = ControllerUtils.getTopMenu(view, referringPageId, user, true);
        model.addAttribute(topMenu.getName(), (Object)topMenu);
    }

    public static void addNavItemsToModel(String view, Model model, String referringPageId, User user, boolean addStore) {
        NavigationMenu topMenu = ControllerUtils.getTopMenu(view, referringPageId, user, addStore);
        model.addAttribute(topMenu.getName(), (Object)topMenu);
    }

    public static NavigationMenu getTopMenu(String view, String referringPageId, User user, boolean addStoreLink) {
        NavigationMenu menu = new NavigationMenu("topnav");
        if (view.startsWith("templates.user.page") || view.startsWith("templates.user.mobile_home")) {
            NavigationItem profile = new NavigationItem("page.profile.title", ControllerUtils.getDisplayName(user), "/app/person/id/" + user.getId() + "?referringPageId=" + referringPageId);
            menu.addNavigationItem(profile);
            if (addStoreLink) {
                NavigationItem store = new NavigationItem("page.store.title", null, "/app/store?referringPageId=" + referringPageId);
                menu.addNavigationItem(store);
            }
            NavigationItem admin = ControllerUtils.getAdminItem(referringPageId);
            menu.addNavigationItem(admin);
            NavigationItem logout = ControllerUtils.getLogoutItem();
            menu.addNavigationItem(logout);
        } else if (view.startsWith("templates.user.store")) {
            NavigationItem addWidget = new NavigationItem("page.addwidget.title", null, "/app/store/widget/add?referringPageId=" + referringPageId);
            menu.addNavigationItem(addWidget);
            NavigationItem back = ControllerUtils.getBackItem(referringPageId);
            menu.addNavigationItem(back);
            NavigationItem admin = ControllerUtils.getAdminItem(referringPageId);
            menu.addNavigationItem(admin);
            NavigationItem logout = ControllerUtils.getLogoutItem();
            menu.addNavigationItem(logout);
        } else if (view.startsWith("templates.user.personProfile") || view.startsWith("templates.user.usernotfound")) {
            NavigationItem back = ControllerUtils.getBackItem(referringPageId);
            menu.addNavigationItem(back);
            NavigationItem admin = ControllerUtils.getAdminItem(referringPageId);
            menu.addNavigationItem(admin);
            NavigationItem logout = ControllerUtils.getLogoutItem();
            menu.addNavigationItem(logout);
        } else if (view.startsWith("templates.user.addwidget") || view.startsWith("templates.user.widget")) {
            NavigationItem addWidget;
            if (view.equals("templates.user.widget.marketplace")) {
                addWidget = new NavigationItem("page.widget.backToMarketplace", null, "/app/marketplace?referringPageId=" + referringPageId);
                menu.addNavigationItem(addWidget);
            }
            addWidget = new NavigationItem("page.widget.backToStore", null, "/app/store?referringPageId=" + referringPageId);
            menu.addNavigationItem(addWidget);
            NavigationItem back = ControllerUtils.getBackItem(referringPageId);
            menu.addNavigationItem(back);
            NavigationItem admin = ControllerUtils.getAdminItem(referringPageId);
            menu.addNavigationItem(admin);
            NavigationItem logout = ControllerUtils.getLogoutItem();
            menu.addNavigationItem(logout);
        }
        return menu;
    }

    public static String getDisplayName(User user) {
        String displayName = user.getDisplayName();
        return displayName == null || "".equals(displayName) ? user.getUsername() : displayName;
    }

    private static NavigationItem getBackItem(String referringPageId) {
        NavigationItem back = new NavigationItem();
        back.setName("page.general.back");
        if (referringPageId != null && !referringPageId.isEmpty()) {
            back.setUrl("/app/page/view/" + referringPageId);
        } else {
            back.setUrl("/");
        }
        return back;
    }

    private static NavigationItem getAdminItem(String referringPageId) {
        NavigationItem admin = new NavigationItem();
        admin.setName("page.general.toadmininterface");
        if (referringPageId != null && !referringPageId.isEmpty()) {
            admin.setUrl("/app/admin?referringPageId=" + referringPageId);
        } else {
            admin.setUrl("/app/admin");
        }
        return admin;
    }

    private static NavigationItem getLogoutItem() {
        return new NavigationItem("page.general.logout", null, "/j_spring_security_logout");
    }
}

